/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.JsonUtils;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public class DefaultJWTCallerPrincipal
extends JWTCallerPrincipal {
    private static final Logger LOGGER = Logger.getLogger(DefaultJWTCallerPrincipal.class);
    private final JwtClaims claimsSet;

    public DefaultJWTCallerPrincipal(String rawToken, String tokenType, JwtClaims claimsSet) {
        super(rawToken, tokenType);
        this.claimsSet = claimsSet;
        this.fixJoseTypes();
    }

    public DefaultJWTCallerPrincipal(String tokenType, JwtClaims claimsSet) {
        this(DefaultJWTCallerPrincipal.getRawToken(claimsSet), tokenType, claimsSet);
    }

    public DefaultJWTCallerPrincipal(JwtClaims claimsSet) {
        this("JWT", claimsSet);
    }

    protected static String getRawToken(JwtClaims claimsSet) {
        Object rawToken = claimsSet.getClaimValue(Claims.raw_token.name());
        return rawToken != null ? rawToken.toString() : null;
    }

    @Override
    public Set<String> getAudience() {
        LinkedHashSet<String> audSet = null;
        if (this.claimsSet.hasAudience()) {
            try {
                audSet = new LinkedHashSet<String>(this.claimsSet.getAudience());
            }
            catch (MalformedClaimException e) {
                LOGGER.warnf("getAudience failure: %s", (Object)e.getMessage());
            }
        }
        return audSet;
    }

    @Override
    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List<String> globalGroups = this.claimsSet.getStringListClaimValue(Claims.groups.name());
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException e) {
            LOGGER.warn((Object)"getGroups failure: ", e);
        }
        return groups;
    }

    @Override
    protected Collection<String> doGetClaimNames() {
        return this.claimsSet.getClaimNames();
    }

    @Override
    protected Object getClaimValue(String claimName) {
        Claims claimType = this.getClaimType(claimName);
        Object claim = null;
        switch (claimType) {
            case exp: 
            case iat: 
            case auth_time: 
            case nbf: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = 0L;
                }
                catch (MalformedClaimException e) {
                    LOGGER.warn((Object)("getClaimValue failure for: " + claimName), e);
                }
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    private void fixJoseTypes() {
        if (this.claimsSet.hasClaim(Claims.address.name())) {
            this.replaceMap(Claims.address.name());
        }
        if (this.claimsSet.hasClaim(Claims.jwk.name())) {
            this.replaceMap(Claims.jwk.name());
        }
        if (this.claimsSet.hasClaim(Claims.sub_jwk.name())) {
            this.replaceMap(Claims.sub_jwk.name());
        }
        Set<String> customClaimNames = this.filterCustomClaimNames(this.claimsSet.getClaimNames());
        for (String name : customClaimNames) {
            Object claimValue = this.claimsSet.getClaimValue(name);
            if (claimValue instanceof List) {
                this.replaceList(name);
                continue;
            }
            if (claimValue instanceof Map) {
                this.replaceMap(name);
                continue;
            }
            if (!(claimValue instanceof Number)) continue;
            this.replaceNumber(name);
        }
    }

    protected Set<String> filterCustomClaimNames(Collection<String> claimNames) {
        HashSet<String> customNames = new HashSet<String>(claimNames);
        for (Claims claim : Claims.values()) {
            customNames.remove(claim.name());
        }
        return customNames;
    }

    protected void replaceMap(String name) {
        try {
            Map map = this.claimsSet.getClaimValue(name, Map.class);
            JsonObject jsonObject = JsonUtils.replaceMap(map);
            this.claimsSet.setClaim(name, jsonObject);
        }
        catch (MalformedClaimException e) {
            LOGGER.warn((Object)("replaceMap failure for: " + name), e);
        }
    }

    protected void replaceList(String name) {
        try {
            JsonArray array = (JsonArray)JsonUtils.wrapValue(this.claimsSet.getClaimValue(name, List.class));
            this.claimsSet.setClaim(name, array);
        }
        catch (MalformedClaimException e) {
            LOGGER.warn((Object)("replaceList failure for: " + name), e);
        }
    }

    protected void replaceNumber(String name) {
        try {
            Number number = this.claimsSet.getClaimValue(name, Number.class);
            JsonNumber jsonNumber = (JsonNumber)JsonUtils.wrapValue(number);
            this.claimsSet.setClaim(name, jsonNumber);
        }
        catch (MalformedClaimException e) {
            LOGGER.warn((Object)("replaceNumber failure for: " + name), e);
        }
    }
}

