/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaMessage;
import io.smallrye.reactive.messaging.kafka.MessageHeaders;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class SendingKafkaMessage<K, T>
implements KafkaMessage<K, T> {
    private final String topic;
    private final K key;
    private final T value;
    private final Integer partition;
    private final Long timestamp;
    private final MessageHeaders headers;
    private final Supplier<CompletionStage<Void>> ack;

    public SendingKafkaMessage(String topic, K key, T value, Long timestamp, Integer partition, MessageHeaders headers, Supplier<CompletionStage<Void>> ack) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.timestamp = timestamp;
        this.headers = headers;
        this.ack = ack;
    }

    @Override
    public CompletionStage<Void> ack() {
        if (this.ack == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.ack.get();
    }

    @Override
    public T getPayload() {
        return this.value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public MessageHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public Supplier<CompletionStage<Void>> getAckSupplier() {
        return this.ack;
    }

    @Override
    public Integer getPartition() {
        if (this.partition == null || this.partition < 0) {
            return null;
        }
        return this.partition;
    }
}

