/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import io.reactivex.Flowable;
import io.reactivex.processors.AsyncProcessor;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class CompletionStageToPublisher {
    private CompletionStageToPublisher() {
    }

    public static <T> Flowable<T> fromCompletionStage(CompletionStage<T> future, boolean acceptNullValue) {
        AsyncProcessor processor = AsyncProcessor.create();
        Objects.requireNonNull(future).whenComplete((v, e) -> {
            if (e != null) {
                processor.onError((Throwable)e);
            } else if (v != null) {
                processor.onNext(v);
                processor.onComplete();
            } else if (acceptNullValue) {
                processor.onComplete();
            } else {
                processor.onError(new NullPointerException("Redeemed value is `null`"));
            }
        });
        return processor;
    }
}

