/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import io.smallrye.reactive.streams.utils.EmptySubscription;
import io.smallrye.reactive.streams.utils.WrappedSubscription;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class SubscriptionObserver<X> {
    private final Publisher<X> upstream;
    private final AtomicReference<Subscriber<? super X>> downstream = new AtomicReference();
    private final AtomicReference<SubscriptionObserver> observer = new AtomicReference();
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final AtomicReference<Throwable> failure = new AtomicReference();

    SubscriptionObserver(Publisher<X> upstream, Subscriber<? super X> downstream) {
        this.upstream = Objects.requireNonNull(upstream);
        this.downstream.set(Objects.requireNonNull(downstream));
    }

    void setObserver(SubscriptionObserver other) {
        this.observer.set(Objects.requireNonNull(other));
    }

    public void run() {
        this.upstream.subscribe(new Subscriber<X>(){

            @Override
            public synchronized void onSubscribe(Subscription sub) {
                if (SubscriptionObserver.this.manageCompletionOrErrorFromBeforeSubscription(sub) || SubscriptionObserver.this.manageAlreadySubscribed(sub)) {
                    return;
                }
                if (SubscriptionObserver.this.downstream.get() == null) {
                    sub.cancel();
                }
                SubscriptionObserver.this.state.set(State.SUBSCRIBED);
                SubscriptionObserver.this.injectSubscription((Subscriber)SubscriptionObserver.this.downstream.get(), sub);
            }

            @Override
            public void onNext(X o) {
                SubscriptionObserver.apply(SubscriptionObserver.this.downstream, d -> d.onNext(Objects.requireNonNull(o)));
            }

            @Override
            public synchronized void onError(Throwable t) {
                SubscriptionObserver.this.state.set(State.FAILED);
                SubscriptionObserver.apply(SubscriptionObserver.this.downstream, d -> d.onError(Objects.requireNonNull(t)));
                SubscriptionObserver.apply(SubscriptionObserver.this.subscription, Subscription::cancel);
                SubscriptionObserver.this.failure.set(t);
                SubscriptionObserver.apply(SubscriptionObserver.this.observer, obs -> obs.error(t));
            }

            @Override
            public synchronized void onComplete() {
                SubscriptionObserver.this.state.set(State.COMPLETED);
                SubscriptionObserver.apply(SubscriptionObserver.this.downstream, Subscriber::onComplete);
                SubscriptionObserver.apply(SubscriptionObserver.this.subscription, Subscription::cancel);
                SubscriptionObserver.apply(SubscriptionObserver.this.observer, SubscriptionObserver::complete);
            }
        });
    }

    private void injectSubscription(Subscriber<? super X> subscriber, Subscription sub) {
        subscriber.onSubscribe(new WrappedSubscription(sub, () -> {
            if (this.state.get() == State.SUBSCRIBED || this.state.get() == State.INIT) {
                this.state.set(State.COMPLETED);
            }
            this.downstream.set(null);
            SubscriptionObserver.apply(this.observer, SubscriptionObserver::complete);
        }));
    }

    private boolean manageAlreadySubscribed(Subscription sub) {
        if (!this.subscription.compareAndSet(null, sub)) {
            sub.cancel();
            return true;
        }
        return false;
    }

    private synchronized Throwable failure() {
        return this.failure.get();
    }

    private synchronized boolean manageCompletionOrErrorFromBeforeSubscription(Subscription sub) {
        SubscriptionObserver obs = this.observer.get();
        if (obs != null) {
            if (obs.state.get() == State.FAILED) {
                this.state.set(State.FAILED);
                SubscriptionObserver.apply(this.downstream, d -> {
                    d.onSubscribe(new EmptySubscription());
                    d.onError(obs.failure());
                });
                sub.cancel();
                return true;
            }
            if (obs.state.get() == State.COMPLETED) {
                this.state.set(State.COMPLETED);
                SubscriptionObserver.apply(this.downstream, d -> {
                    d.onSubscribe(new EmptySubscription());
                    d.onComplete();
                });
                sub.cancel();
                return true;
            }
        }
        return false;
    }

    public synchronized void error(Throwable failure) {
        if (this.state.compareAndSet(State.SUBSCRIBED, State.FAILED)) {
            SubscriptionObserver.apply(this.downstream, stream -> stream.onError(failure));
            SubscriptionObserver.apply(this.subscription, Subscription::cancel);
            this.downstream.set(null);
        }
    }

    public synchronized void complete() {
        if (this.state.compareAndSet(State.SUBSCRIBED, State.COMPLETED)) {
            SubscriptionObserver.apply(this.downstream, Subscriber::onComplete);
            SubscriptionObserver.apply(this.subscription, Subscription::cancel);
            this.downstream.set(null);
        }
    }

    private static <X> void apply(AtomicReference<X> ref, Consumer<X> consumer) {
        X x = ref.get();
        if (x != null) {
            consumer.accept(x);
        }
    }

    private static enum State {
        INIT,
        SUBSCRIBED,
        COMPLETED,
        FAILED;

    }
}

