/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class WrappedProcessor<T>
implements Processor<T, T> {
    private final Subscriber<T> subscriber;
    private final Publisher<T> publisher;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    public WrappedProcessor(Subscriber<T> subscriber, Publisher<T> publisher) {
        this.subscriber = subscriber;
        this.publisher = publisher;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        this.publisher.subscribe(subscriber);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        if (!this.subscribed.compareAndSet(false, true)) {
            subscription.cancel();
        } else {
            this.subscriber.onSubscribe(subscription);
        }
    }

    @Override
    public void onNext(T item) {
        this.subscriber.onNext(item);
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(Objects.requireNonNull(throwable));
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }
}

