/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.axle.FlowableReadStream;
import io.vertx.axle.FlowableUnmarshaller;
import io.vertx.axle.ReadStreamSubscriber;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class PublisherHelper {
    public static <T> ReadStream<T> toReadStream(Flowable<T> observable) {
        return ReadStreamSubscriber.asReadStream(observable, Function.identity());
    }

    public static <T, U> Publisher<U> toPublisher(ReadStream<T> stream, Function<T, U> mapping) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream<T, U>(stream, 256L, mapping));
    }

    public static <T, U> Flowable<U> toFlowable(ReadStream<T> stream, Function<T, U> mapping) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream<T, U>(stream, 256L, mapping));
    }

    public static <T> Publisher<T> toPublisher(ReadStream<T> stream) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream(stream, 256L, Function.identity()));
    }

    public static <T> Flowable<T> toFlowable(ReadStream<T> stream) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream(stream, 256L, Function.identity()));
    }

    public static <T> Flowable<T> toFlowable(ReadStream<T> stream, long maxBufferSize) {
        return RxJavaPlugins.onAssembly(new FlowableReadStream(stream, maxBufferSize, Function.identity()));
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new FlowableUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new FlowableUnmarshaller(Function.identity(), mappedTypeRef);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(Class<T> mappedType, ObjectMapper mapper) {
        return new FlowableUnmarshaller(Function.identity(), mappedType, mapper);
    }

    public static <T> FlowableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        return new FlowableUnmarshaller(Function.identity(), mappedTypeRef, mapper);
    }
}

