/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.WebSocketBase;
import io.vertx.reactivex.core.http.WebSocketFrame;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket
implements WebSocketBase {
    public static final TypeArg<ServerWebSocket> __TYPE_ARG = new TypeArg<ServerWebSocket>(obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket)obj), ServerWebSocket::getDelegate);
    private final io.vertx.core.http.ServerWebSocket delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerWebSocket that = (ServerWebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
        this.delegate = delegate;
    }

    @Override
    public io.vertx.core.http.ServerWebSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.end(data.getDelegate());
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(data.getDelegate(), handler);
    }

    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public WebSocketBase writePing(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writePing(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase writePong(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writePong(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.pongHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void close(short statusCode) {
        this.delegate.close(statusCode);
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable(handler -> this.close(statusCode, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void close(short statusCode, String reason) {
        this.delegate.close(statusCode, reason);
    }

    @Override
    public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(handler -> this.close(statusCode, reason, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Override
    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public ServerWebSocket handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public ServerWebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public ServerWebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public ServerWebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public ServerWebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public ServerWebSocket write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    @Override
    public ServerWebSocket write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), (Handler)handler);
        return this;
    }

    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(data, (Handler)handler));
    }

    @Override
    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public ServerWebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public ServerWebSocket writeFrame(WebSocketFrame frame) {
        this.delegate.writeFrame(frame.getDelegate());
        return this;
    }

    @Override
    public ServerWebSocket writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame.getDelegate(), (Handler)handler);
        return this;
    }

    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeFrame(frame, (Handler)handler));
    }

    @Override
    public ServerWebSocket writeFinalTextFrame(String text) {
        this.delegate.writeFinalTextFrame(text);
        return this;
    }

    @Override
    public ServerWebSocket writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, (Handler)handler);
        return this;
    }

    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeFinalTextFrame(text, (Handler)handler));
    }

    @Override
    public ServerWebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate());
        return this;
    }

    @Override
    public ServerWebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate(), (Handler)handler);
        return this;
    }

    public Completable rxWriteFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeFinalBinaryFrame(data, (Handler)handler));
    }

    @Override
    public ServerWebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writeBinaryMessage(data.getDelegate());
        return this;
    }

    @Override
    public ServerWebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data.getDelegate(), (Handler)handler);
        return this;
    }

    public Completable rxWriteBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeBinaryMessage(data, (Handler)handler));
    }

    @Override
    public ServerWebSocket writeTextMessage(String text) {
        this.delegate.writeTextMessage(text);
        return this;
    }

    @Override
    public ServerWebSocket writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, (Handler)handler);
        return this;
    }

    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.writeTextMessage(text, (Handler)handler));
    }

    @Override
    public ServerWebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler((Handler)handler);
        return this;
    }

    @Override
    public ServerWebSocket frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            @Override
            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle(WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public void accept() {
        this.delegate.accept();
    }

    public void reject() {
        this.delegate.reject();
    }

    public void reject(int status) {
        this.delegate.reject(status);
    }

    public void setHandshake(Future<Integer> future, Handler<AsyncResult<Integer>> handler) {
        this.delegate.setHandshake(future.getDelegate(), handler);
    }

    public Single<Integer> rxSetHandshake(Future<Integer> future) {
        return AsyncResultSingle.toSingle(handler -> this.setHandshake(future, (Handler<AsyncResult<Integer>>)handler));
    }

    public void setHandshake(Future<Integer> future) {
        this.delegate.setHandshake(future.getDelegate());
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
        return arg != null ? new ServerWebSocket(arg) : null;
    }
}

