/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2.providers;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.reactivex.ext.auth.oauth2.providers.OpenIDConnectAuth;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.oauth2.providers.AzureADAuth.class)
public class AzureADAuth
extends OpenIDConnectAuth {
    public static final TypeArg<AzureADAuth> __TYPE_ARG = new TypeArg<AzureADAuth>(obj -> new AzureADAuth((io.vertx.ext.auth.oauth2.providers.AzureADAuth)obj), AzureADAuth::getDelegate);
    private final io.vertx.ext.auth.oauth2.providers.AzureADAuth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureADAuth that = (AzureADAuth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AzureADAuth(io.vertx.ext.auth.oauth2.providers.AzureADAuth delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public io.vertx.ext.auth.oauth2.providers.AzureADAuth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.AzureADAuth.create(vertx.getDelegate(), clientId, clientSecret, guid));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid, HttpClientOptions httpClientOptions) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.AzureADAuth.create(vertx.getDelegate(), clientId, clientSecret, guid, httpClientOptions));
        return ret;
    }

    public static void discover(Vertx vertx, OAuth2ClientOptions config, final Handler<AsyncResult<OAuth2Auth>> handler) {
        io.vertx.ext.auth.oauth2.providers.AzureADAuth.discover(vertx.getDelegate(), config, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(OAuth2Auth.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public static Single<OAuth2Auth> rxDiscover(Vertx vertx, OAuth2ClientOptions config) {
        return AsyncResultSingle.toSingle(handler -> AzureADAuth.discover(vertx, config, handler));
    }

    public static AzureADAuth newInstance(io.vertx.ext.auth.oauth2.providers.AzureADAuth arg) {
        return arg != null ? new AzureADAuth(arg) : null;
    }
}

