/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.admin.ZkSecurityMigrator;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class ZkSecurityMigrator$
implements Logging {
    public static ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ZkSecurityMigrator$ zkSecurityMigrator$ = this;
        synchronized (zkSecurityMigrator$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    public void run(String[] args) {
        boolean bl;
        String jaasFile = System.getProperty("java.security.auth.login.config");
        ZkSecurityMigrator.ZkSecurityMigratorOptions opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
        if (jaasFile == null) {
            String errorMsg = new StringBuilder(82).append("No JAAS configuration file has been specified. Please make sure that you have set ").append(new StringOps(Predef$.MODULE$.augmentString("the system property %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"java.security.auth.login.config"}))).toString();
            System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        if (!JaasUtils.isZkSecurityEnabled()) {
            String errorMsg = new StringOps(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jaasFile}));
            System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        String string = opts.options().valueOf(opts.zkAclOpt());
        if ("secure".equals(string)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "zookeeper.acl option is secure");
            bl = true;
        } else if ("unsecure".equals(string)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "zookeeper.acl option is unsecure");
            bl = false;
        } else {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), this.usageMessage());
        }
        boolean zkAcl = bl;
        String zkUrl = opts.options().valueOf(opts.zkUrlOpt());
        int zkSessionTimeout = opts.options().valueOf(opts.zkSessionTimeoutOpt());
        int zkConnectionTimeout = opts.options().valueOf(opts.zkConnectionTimeoutOpt());
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, zkAcl, zkSessionTimeout, zkConnectionTimeout, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        ZkSecurityMigrator migrator = new ZkSecurityMigrator(zkClient);
        migrator.kafka$admin$ZkSecurityMigrator$$run();
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    }
}

