/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogOffsetSnapshot;
import kafka.log.LogSegment;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0016-\u0001EB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003G\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011q\u0003!\u00111A\u0005\u0002uC\u0001B\u001a\u0001\u0003\u0002\u0004%\ta\u001a\u0005\t[\u0002\u0011\t\u0011)Q\u0005=\")!\u000f\u0001C\u0001g\"11\u0010\u0001Q!\nqDq!a\u0002\u0001A\u0003&A\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0015B-\t\u000f\u0005=\u0001\u0001)Q\u00053\"9\u00111\u0003\u0001!B\u0013I\u0006bBA\f\u0001\u0001\u0006K!\u0017\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t9\u0007\u0001C\u0001\u0003OAq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002(!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAA\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003\u0007\u0003A\u0011AA3\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u0011Q\u0015\u0001\u0005B\u0005\u001dv!CA`Y\u0005\u0005\t\u0012AAa\r!YC&!A\t\u0002\u0005\r\u0007B\u0002:'\t\u0003\t)\rC\u0005\u0002H\u001a\n\n\u0011\"\u0001\u0002J\"I\u0011q\u001c\u0014\u0012\u0002\u0013\u0005\u0011\u0011\u001d\u0005\n\u0003K4\u0013\u0013!C\u0001\u0003O\u0014qAU3qY&\u001c\u0017M\u0003\u0002.]\u000591\r\\;ti\u0016\u0014(\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g!\tID(D\u0001;\u0015\tYd&A\u0003vi&d7/\u0003\u0002>u\t9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0016\u0003\u0001\u0003\"aM!\n\u0005\t#$aA%oi\u0006I!M]8lKJLE\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u00051\u0005CA$P\u001b\u0005A%BA%K\u0003\u0019\u0019w.\\7p]*\u0011qf\u0013\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\u0011\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\tQLW.\u001a\t\u0003)Zk\u0011!\u0016\u0006\u0003w!K!aV+\u0003\tQKW.Z\u0001\u001aS:LG/[1m\u0011&<\u0007nV1uKJl\u0017M]6WC2,X\r\u0005\u000245&\u00111\f\u000e\u0002\u0005\u0019>tw-A\u0002m_\u001e,\u0012A\u0018\t\u0004g}\u000b\u0017B\u000115\u0005\u0019y\u0005\u000f^5p]B\u0011!\rZ\u0007\u0002G*\u0011ALL\u0005\u0003K\u000e\u00141\u0001T8h\u0003\u001dawnZ0%KF$\"\u0001[6\u0011\u0005MJ\u0017B\u000165\u0005\u0011)f.\u001b;\t\u000f1D\u0011\u0011!a\u0001=\u0006\u0019\u0001\u0010J\u0019\u0002\t1|w\r\t\u0015\u0003\u0013=\u0004\"a\r9\n\u0005E$$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\rqJg.\u001b;?)\u0019!ho\u001e=zuB\u0011Q\u000fA\u0007\u0002Y!)aH\u0003a\u0001\u0001\")AI\u0003a\u0001\r\"9!K\u0003I\u0001\u0002\u0004\u0019\u0006b\u0002-\u000b!\u0003\u0005\r!\u0017\u0005\b9*\u0001\n\u00111\u0001_\u0003UA\u0017n\u001a5XCR,'/\\1sW6+G/\u00193bi\u0006\u00042!`A\u0001\u001b\u0005q(BA@/\u0003\u0019\u0019XM\u001d<fe&\u0019\u00111\u0001@\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u000b\u0002\f_\u0006)r\f\\8h\u000b:$wJ\u001a4tKRlU\r^1eCR\f\u0007F\u0001\u0007p\u0003=yFn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bFA\u0007p\u0003ma\u0017m\u001d;GKR\u001c\u0007\u000eT3bI\u0016\u0014Hj\\4F]\u0012|eMZ:fi\"\u0012ab\\\u0001\u0010Y\u0006\u001cHOR3uG\"$\u0016.\\3Ng\"\u0012qb\\\u0001\u0014?2\f7\u000f^\"bk\u001eDG/\u00169US6,Wj\u001d\u0015\u0003!=\fq![:M_\u000e\fG.\u0006\u0002\u0002 A\u00191'!\t\n\u0007\u0005\rBGA\u0004C_>dW-\u00198\u0002%1\f7\u000f^\"bk\u001eDG/\u00169US6,Wj]\u000b\u00023\u0006\u0019R\u000f\u001d3bi\u0016dun\u001a*fC\u0012\u0014Vm];miR\u0019\u0001.!\f\t\u000f\u0005=2\u00031\u0001\u00022\u0005iAn\\4SK\u0006$'+Z:vYR\u00042!`A\u001a\u0013\r\t)D \u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\u0002+I,7/\u001a;MCN$8)Y;hQR,\u0006\u000fV5nKR9\u0001.a\u000f\u0002@\u0005\r\u0003BBA\u001f)\u0001\u0007\u0011,A\u000bdkJdU-\u00193fe2{w-\u00128e\u001f\u001a47/\u001a;\t\r\u0005\u0005C\u00031\u0001Z\u0003%\u0019WO\u001d+j[\u0016l5\u000f\u0003\u0004\u0002&Q\u0001\r!W\u0001\u0019Y><WI\u001c3PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1`I\u0015\fHc\u00015\u0002J!1\u00111J\u000bA\u0002q\fqB\\3x\u0019><WI\u001c3PM\u001a\u001cX\r^\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007.\u0006\u0002\u0002RA\u00191g\u0018!\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u0002X\u0005}\u0003\u0003B\u001a`\u00033\u00022!`A.\u0013\r\tiF \u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u0019\t\tg\u0006a\u0001\u0001\u0006YA.Z1eKJ,\u0005o\\2i\u0003QawnZ#oI>3gm]3u\u001b\u0016$\u0018\rZ1uCV\tA0\u0001\u0007m_\u001e,e\u000eZ(gMN,G/\u0001\u000fnCf\u0014W-\u00138de\u0016lWM\u001c;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0007!\fi\u0007\u0003\u0004\u0002pi\u0001\r!W\u0001\u0012]\u0016<Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018A\u00057pON#\u0018M\u001d;PM\u001a\u001cX\r^0%KF$2\u0001[A;\u0011\u0019\tyg\u0007a\u00013\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018!\u00055jO\"<\u0016\r^3s[\u0006\u00148n\u0018\u0013fcR\u0019\u0001.! \t\r\u0005}T\u00041\u0001}\u0003AqWm\u001e%jO\"<\u0016\r^3s[\u0006\u00148.A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0011Y\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\fadY8om\u0016\u0014H\u000fS,U_2{7-\u00197PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0003!\fab\u001c4gg\u0016$8K\\1qg\"|G/\u0006\u0002\u0002\u000eB\u0019!-a$\n\u0007\u0005E5MA\tM_\u001e|eMZ:fiNs\u0017\r]:i_R\fa!Z9vC2\u001cH\u0003BA\u0010\u0003/Cq!!'#\u0001\u0004\tY*\u0001\u0003uQ\u0006$\bcA\u001a\u0002\u001e&\u0019\u0011q\u0014\u001b\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f)\u0005\u0001\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0006\u0003BAV\u0003ssA!!,\u00026B\u0019\u0011q\u0016\u001b\u000e\u0005\u0005E&bAAZa\u00051AH]8pizJ1!a.5\u0003\u0019\u0001&/\u001a3fM&!\u00111XA_\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0017\u001b\u0002\u000fI+\u0007\u000f\\5dCB\u0011QOJ\n\u0003MI\"\"!!1\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYMK\u0002T\u0003\u001b\\#!a4\u0011\t\u0005E\u00171\\\u0007\u0003\u0003'TA!!6\u0002X\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033$\u0014AC1o]>$\u0018\r^5p]&!\u0011Q\\Aj\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\r(fA-\u0002N\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!!;+\u0007y\u000bi\r")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final long initialHighWatermarkValue;
    private volatile Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    private volatile LogOffsetMetadata _logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public void log_$eq(Option<Log> x$1) {
        this.log = x$1;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logStartOffset_$eq(logReadResult.followerLogStartOffset());
        this.logEndOffsetMetadata_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffsetMetadata_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringBuilder(60).append("Should not set log end offset on partition ").append(this.topicPartition()).append("'s local replica ").append(this.brokerId()).toString());
        }
        this._logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Setting log end offset for replica ").append(this.brokerId()).append(" for partition ").append(this.topicPartition()).append(" to [").append($this._logEndOffsetMetadata).append("]").toString());
    }

    public Option<Object> latestEpoch() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringBuilder(48).append("Cannot get latest epoch of non-local replica of ").append(this.topicPartition()).toString());
        }
        return ((Log)this.log().get()).latestEpoch();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
        if (!this.isLocal()) {
            throw new KafkaException(new StringBuilder(59).append("Cannot lookup end offset for epoch of non-local replica of ").append(this.topicPartition()).toString());
        }
        return ((Log)this.log().get()).endOffsetForEpoch(leaderEpoch);
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this._logEndOffsetMetadata;
    }

    public long logEndOffset() {
        return this.logEndOffsetMetadata().messageOffset();
    }

    public void maybeIncrementLogStartOffset(long newLogStartOffset) {
        if (this.isLocal()) {
            if (newLogStartOffset > this.highWatermark().messageOffset()) {
                throw new OffsetOutOfRangeException(new StringBuilder(56).append("Cannot increment the log start offset to ").append(newLogStartOffset).append(" of partition ").append(this.topicPartition()).append(" ").append(new StringBuilder(43).append("since it is larger than the high watermark ").append(this.highWatermark().messageOffset()).toString()).toString());
            }
        } else {
            throw new KafkaException(new StringBuilder(67).append("Should not try to delete records on partition ").append(this.topicPartition()).append("'s non-local replica ").append(this.brokerId()).toString());
        }
        ((Log)this.log().get()).maybeIncrementLogStartOffset(newLogStartOffset);
    }

    private void logStartOffset_$eq(long newLogStartOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringBuilder(110).append("Should not set log start offset on partition ").append(this.topicPartition()).append("'s local replica ").append(this.brokerId()).append(" ").append("without attempting to delete records of the log").toString());
        }
        this._logStartOffset = newLogStartOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Setting log start offset for remote replica ").append(this.brokerId()).append(" for partition ").append(this.topicPartition()).append(" to [").append(newLogStartOffset).append("]").toString());
    }

    public long logStartOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logStartOffset() : this._logStartOffset;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            if (newHighWatermark.messageOffset() < 0L) {
                throw new IllegalArgumentException("High watermark offset should be non-negative");
            }
        } else {
            throw new KafkaException(new StringBuilder(64).append("Should not set high watermark on partition ").append(this.topicPartition()).append("'s non-local replica ").append(this.brokerId()).toString());
        }
        this.highWatermarkMetadata = newHighWatermark;
        this.log().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onHighWatermarkIncremented(newHighWatermark.messageOffset());
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Setting high watermark for replica ").append(this.brokerId()).append(" partition ").append(this.topicPartition()).append(" to [").append(newHighWatermark).append("]").toString());
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public LogOffsetMetadata lastStableOffset() {
        return (LogOffsetMetadata)this.log().map((Function1 & Serializable & scala.Serializable)log -> {
            Some some;
            LogOffsetMetadata offsetMetadata;
            Option<LogOffsetMetadata> option = log.firstUnstableOffset();
            LogOffsetMetadata logOffsetMetadata = option instanceof Some && (offsetMetadata = (LogOffsetMetadata)(some = (Some)option).value()).messageOffset() < this.highWatermark().messageOffset() ? offsetMetadata : this.highWatermark();
            return logOffsetMetadata;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(48).append("Cannot fetch last stable offset on partition ").append(this.topicPartition()).append("'s ").append(new StringBuilder(18).append("non-local replica ").append(this.brokerId()).toString()).toString());
        });
    }

    public void convertHWToLocalOffsetMetadata() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringBuilder(79).append("Should not construct complete high watermark on partition ").append(this.topicPartition()).append("'s non-local replica ").append(this.brokerId()).toString());
        }
        this.highWatermarkMetadata = (LogOffsetMetadata)((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (LogOffsetMetadata)((Log)this.log().get()).convertToOffsetMetadata(this.logStartOffset()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            long firstSegmentOffset = ((LogSegment)((Log)this.log().get()).logSegments().head()).baseOffset();
            return new LogOffsetMetadata(firstSegmentOffset, firstSegmentOffset, 0);
        }));
    }

    public LogOffsetSnapshot offsetSnapshot() {
        return new LogOffsetSnapshot(this.logStartOffset(), this.logEndOffsetMetadata(), this.highWatermark(), this.lastStableOffset());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!((Object)topicPartition).equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        BoxedUnit boxedUnit;
        scala.collection.mutable.StringBuilder replicaString = new scala.collection.mutable.StringBuilder();
        replicaString.append(new StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new StringBuilder(10).append(", isLocal=").append(this.isLocal()).toString());
        replicaString.append(new StringBuilder(21).append(", lastCaughtUpTimeMs=").append(this.lastCaughtUpTimeMs()).toString());
        if (this.isLocal()) {
            replicaString.append(new StringBuilder(16).append(", highWatermark=").append(this.highWatermark()).toString());
            boxedUnit = replicaString.append(new StringBuilder(19).append(", lastStableOffset=").append(this.lastStableOffset()).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        replicaString.append(")");
        return replicaString.toString();
    }

    public Replica(int brokerId, TopicPartition topicPartition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.initialHighWatermarkValue = initialHighWatermarkValue;
        this.log = log;
        Logging.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this._logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownLogStartOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Replica loaded for partition ").append(this.topicPartition()).append(" with initial high watermark ").append($this.initialHighWatermarkValue).toString());
        this.log().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onHighWatermarkIncremented(this.initialHighWatermarkValue);
            return BoxedUnit.UNIT;
        });
    }
}

