/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me!B\r\u001b\u0001iq\u0002\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011A\u0014\t\u0011M\u0002!\u0011!Q\u0001\n!B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003=\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u000f9\u0003!\u0019!C\u0005\u001f\"11\f\u0001Q\u0001\nACq\u0001\u0018\u0001C\u0002\u0013%1\b\u0003\u0004^\u0001\u0001\u0006I\u0001\u0010\u0005\u0006=\u0002!Ia\u0018\u0005\u0006_\u0002!I\u0001\u001d\u0005\u0006g\u0002!I\u0001\u001e\u0005\u0006s\u0002!IA\u001f\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\t)\u0001\u0001C\u0001\u0003KAq!a\u0010\u0001\t\u0003\t\t\u0005\u0003\u0004\u0002V\u0001!\ta\u000f\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a\"\u0001\t\u0003\nII\u0001\nQe>$WoY3s\u0003B\u0004XM\u001c3J]\u001a|'BA\u000e\u001d\u0003\rawn\u001a\u0006\u0002;\u0005)1.\u00194lCN\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u000e\u0001Q#\u0001\u0015\u0011\u0005%\nT\"\u0001\u0016\u000b\u0005-b\u0013AB2p[6|gN\u0003\u0002\u001e[)\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u0011$F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n!\u0002\u001d:pIV\u001cWM]%e+\u00051\u0004C\u0001\u00118\u0013\tA\u0014E\u0001\u0003M_:<\u0017a\u00039s_\u0012,8-\u001a:JI\u0002\nAbY;se\u0016tG/\u00128uef,\u0012\u0001\u0010\t\u0003{yj\u0011AG\u0005\u0003\u007fi\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ss\u0006i1-\u001e:sK:$XI\u001c;ss\u0002\naB^1mS\u0012\fG/[8o)f\u0004X-F\u0001D!\tiD)\u0003\u0002F5\tqa+\u00197jI\u0006$\u0018n\u001c8UsB,\u0017a\u0004<bY&$\u0017\r^5p]RK\b/\u001a\u0011\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\ti\u0004\u0001C\u0003&\u0013\u0001\u0007\u0001\u0006C\u00035\u0013\u0001\u0007a\u0007C\u0003;\u0013\u0001\u0007A\bC\u0003B\u0013\u0001\u00071)\u0001\u0007ue\u0006t7/Y2uS>t7/F\u0001Q!\r\tf\u000bW\u0007\u0002%*\u00111\u000bV\u0001\b[V$\u0018M\u00197f\u0015\t)\u0016%\u0001\u0006d_2dWm\u0019;j_:L!a\u0016*\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0002>3&\u0011!L\u0007\u0002\f)btW*\u001a;bI\u0006$\u0018-A\u0007ue\u0006t7/Y2uS>t7\u000fI\u0001\rkB$\u0017\r^3e\u000b:$(/_\u0001\u000ekB$\u0017\r^3e\u000b:$(/\u001f\u0011\u0002'5\f\u0017PY3WC2LG-\u0019;f\u0003B\u0004XM\u001c3\u0015\t\u0001\u001c\u0007.\u001c\t\u0003A\u0005L!AY\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006I:\u0001\r!Z\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0005\u00012\u0017BA4\"\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0015Ig\u00021\u0001k\u0003!1\u0017N]:u'\u0016\f\bC\u0001\u0011l\u0013\ta\u0017EA\u0002J]RDQA\u001c\bA\u0002Y\naa\u001c4gg\u0016$\u0018AE2iK\u000e\\\u0007K]8ek\u000e,'/\u00129pG\"$2\u0001Y9s\u0011\u0015!w\u00021\u0001f\u0011\u0015qw\u00021\u00017\u00035\u0019\u0007.Z2l'\u0016\fX/\u001a8dKR!\u0001-\u001e<y\u0011\u0015!\u0007\u00031\u0001f\u0011\u00159\b\u00031\u0001k\u00039\t\u0007\u000f]3oI\u001aK'o\u001d;TKFDQA\u001c\tA\u0002Y\n!\"\u001b8TKF,XM\\2f)\u0011Yh0!\u0001\u0011\u0005\u0001b\u0018BA?\"\u0005\u001d\u0011un\u001c7fC:DQa`\tA\u0002)\fq\u0001\\1tiN+\u0017\u000f\u0003\u0004\u0002\u0004E\u0001\rA[\u0001\b]\u0016DHoU3r\u0003\u0019\t\u0007\u000f]3oIR!\u0011\u0011BA\u000b!\u0015\u0001\u00131BA\b\u0013\r\ti!\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\n\t\"C\u0002\u0002\u0014i\u0011AbQ8na2,G/\u001a3Uq:Dq!a\u0006\u0013\u0001\u0004\tI\"A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyBK\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005\r\u0012Q\u0004\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eF\ba\u0003O\tY#!\f\u00020\u0005M\u0012qGA\u001e\u0011\u0019\tIc\u0005a\u0001K\u0006)Q\r]8dQ\")\u0011n\u0005a\u0001U\")qp\u0005a\u0001U\"1\u0011\u0011G\nA\u0002Y\nQ\u0002\\1tiRKW.Z:uC6\u0004\bBBA\u001b'\u0001\u0007a'A\u0006gSJ\u001cHo\u00144gg\u0016$\bBBA\u001d'\u0001\u0007a'\u0001\u0006mCN$xJ\u001a4tKRDa!!\u0010\u0014\u0001\u0004Y\u0018aD5t)J\fgn]1di&|g.\u00197\u0002%\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u000b\u000b\u0003\u001f\t\u0019%!\u0014\u0002P\u0005E\u0003bBA#)\u0001\u0007\u0011qI\u0001\rK:$G\u000b\u001f8NCJ\\WM\u001d\t\u0005\u00037\tI%\u0003\u0003\u0002L\u0005u!\u0001F#oIR\u0013\u0018M\\:bGRLwN\\'be.,'\u000fC\u0003e)\u0001\u0007Q\rC\u0003o)\u0001\u0007a\u0007\u0003\u0004\u0002TQ\u0001\rAN\u0001\ni&lWm\u001d;b[B\fq\u0001^8F]R\u0014\u00180A\nti\u0006\u0014H/\u001a3Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002\\A)\u0011QLA71:!\u0011qLA5\u001d\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3M\u00051AH]8pizJ\u0011AI\u0005\u0004\u0003W\n\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003_\n\tH\u0001\u0003MSN$(bAA6C\u0005\u0001S.Y=cK\u000e\u000b7\r[3Uq:4\u0015N]:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\r\u0001\u0017q\u000f\u0005\b\u0003s:\u0002\u0019AA>\u0003EawnZ(gMN,G/T3uC\u0012\fG/\u0019\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\u000f\u0002\rM,'O^3s\u0013\u0011\t))a \u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-\u0001\u0005u_N#(/\u001b8h)\t\tY\t\u0005\u0003\u0002\u000e\u0006Ue\u0002BAH\u0003#\u00032!!\u0019\"\u0013\r\t\u0019*I\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0015\u0011\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M\u0015\u0005")
public class ProducerAppendInfo {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq, long offset) {
        ValidationType validationType = this.validationType();
        if (ValidationType$None$.MODULE$.equals(validationType)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$EpochOnly$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$Full$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch, offset);
            this.checkSequence(producerEpoch, firstSeq, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)validationType);
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder(50).append("Producer's epoch at offset ").append(offset).append(" is no longer valid in ").append(new StringBuilder(46).append("partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(this.updatedEntry().producerEpoch()).append(" (current epoch)").toString()).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset) {
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0) {
                if (this.updatedEntry().producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringBuilder(52).append("Invalid sequence number for new epoch at offset ").append(offset).append(" in ").append(new StringBuilder(44).append("partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(appendFirstSeq).append(" (seq. number)").toString()).toString());
                }
                throw new UnknownProducerIdException(new StringBuilder(103).append("Found no record of producerId=").append(this.producerId()).append(" on the broker at offset ").append(offset).append(new StringBuilder(77).append("in partition ").append(this.topicPartition()).append(". It is possible that the last message with the producerId=").append(this.producerId()).append(" has ").toString()).append("been removed due to hitting the retention limit.").toString());
            }
        } else {
            int currentLastSeq;
            int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
            if (currentLastSeq == -1 && appendFirstSeq != 0) {
                throw new UnknownProducerIdException(new StringBuilder(74).append("Local producer state matches expected epoch ").append(producerEpoch).append(" ").append(new StringBuilder(64).append("for producerId=").append(this.producerId()).append(" at offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(", but the next expected ").toString()).append("sequence number is not known.").toString());
            }
            if (!this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException(new StringBuilder(48).append("Out of order sequence number for producerId ").append(this.producerId()).append(" at ").append(new StringBuilder(48).append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(appendFirstSeq).append(" (incoming seq. number), ").toString()).append(new StringBuilder(30).append(currentLastSeq).append(" (current end sequence number)").toString()).toString());
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize(record);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.baseOffset(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long firstOffset, long lastOffset, boolean isTransactional) {
        this.maybeValidateAppend(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(47).append("Expected transactional write from producer ").append(this.producerId()).append(" at ").append(new StringBuilder(21).append("offset ").append(firstOffset).append(" in partition ").append(this.topicPartition()).toString()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        this.checkProducerEpoch(producerEpoch, offset);
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            throw new TransactionCoordinatorFencedException(new StringBuilder(45).append("Invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append(new StringBuilder(24).append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").toString()).append(new StringBuilder(20).append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString()).toString());
        }
        this.updatedEntry().maybeUpdateEpoch(producerEpoch);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !((Object)((Object)controlRecordType)).equals((Object)controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            ProducerAppendInfo.$anonfun$maybeCacheTxnFirstOffsetMetadata$1(logOffsetMetadata, txn);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return new StringBuilder(19).append("ProducerAppendInfo(").append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").toString()).append(new StringBuilder(16).append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").toString()).append(new StringBuilder(15).append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").toString()).append(new StringBuilder(24).append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").toString()).append(new StringBuilder(19).append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").toString()).append(new StringBuilder(21).append("startedTransactions=").append(this.transactions()).append(")").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$maybeCacheTxnFirstOffsetMetadata$1(LogOffsetMetadata logOffsetMetadata$1, TxnMetadata txn) {
        block0: {
            if (txn.firstOffset().messageOffset() != logOffsetMetadata$1.messageOffset()) break block0;
            txn.firstOffset_$eq(logOffsetMetadata$1);
        }
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

