/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\rd!\u0002,X\u0003\u0003a\u0006\"C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023r\u0011!\u0011\bA!A!\u0002\u0013!\u0007\u0002C:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011m\u0004!\u0011!Q\u0001\nUD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\r\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u00111\u0002\u0005\b\u0003\u001b\u0001A\u0011AA\b\u000b\u0019\ty\u0002\u0001\u0001\u0002\"\u00151\u0011q\n\u0001\u0001\u0003#B\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\t\u0011\u0005M\u0004\u0001)A\u0005\u0003CB\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005E\u0005\u0001)A\u0005\u0003sB\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005u\u0005\u0001)A\u0005\u0003/C\u0011\"a(\u0001\u0005\u0004%I!!)\t\u0011\u00055\u0006\u0001)A\u0005\u0003GC\u0011\"a,\u0001\u0005\u0004%\t!!-\t\u0011\u0005e\u0006\u0001)A\u0005\u0003gC\u0011\"a/\u0001\u0005\u0004%\t!!0\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003\u007fCq!a2\u0001\r#\tI\rC\u0004\u0002|\u00021\t\"!@\t\u000f\tE\u0001A\"\u0005\u0003\u0014!9!1\u0004\u0001\u0007\u0012\tu\u0001bBB%\u0001\u0019E11\n\u0005\b\u0007#\u0002a\u0011CB*\u0011\u001d\u00199\u0006\u0001D\t\u00073Bqa!\u001b\u0001\r#\u0019Y\u0007C\u0004\u0004~\u00011\tba \t\u000f\re\u0005A\"\u0005\u0004\u001c\"911\u0015\u0001\u0007\u0012\r\u0015\u0006bBBV\u0001\u0019E1Q\u0016\u0005\b\u0007_\u0003A\u0011IBY\u0011\u001d\u0019\u0019\f\u0001C!\u0007cCqa!.\u0001\t\u0013\u0019\t\fC\u0004\u00048\u0002!Ia!/\t\u000f\r\r\u0007\u0001\"\u0003\u0004F\"91\u0011\u001a\u0001\u0005\n\rE\u0006bBBf\u0001\u0011%1Q\u001a\u0005\t\u0007'\u0004A\u0011A,\u0004V\"91\u0011\u001c\u0001\u0005\n\rm\u0007bBBs\u0001\u0011%1q\u001d\u0005\b\u0007[\u0004A\u0011BBx\u0011\u001d\u00199\u0010\u0001C\u0001\u0007sDq\u0001\"\u0001\u0001\t\u0003!\u0019\u0001C\u0004\u0005\f\u0001!I\u0001\"\u0004\t\u000f\u0011M\u0001\u0001\"\u0003\u0005\u0016!9AQ\u0004\u0001\u0005\n\u0011}\u0001b\u0002C\u0014\u0001\u0011EA\u0011\u0006\u0005\b\t_\u0001A\u0011\u0001C\u0019\u0011\u001d!I\u0004\u0001C\u0001\twAq\u0001\"\u0011\u0001\t\u0003\u0011i\u000e\u0003\u0005\u0005&\u0001!\ta\u0016C\"\u0011!!I\u0005\u0001C\u0001/\u0012-\u0003b\u0002C+\u0001\u0011EAqK\u0004\b\u0005G9\u0006\u0012\u0001B\u0013\r\u00191v\u000b#\u0001\u0003(!9\u0011Q\u0002\u001e\u0005\u0002\t=bA\u0002B\u0019u\u0001\u0013\u0019\u0004\u0003\u0006\u0003Dq\u0012)\u001a!C\u0001\u0005\u000bB!B!\u0018=\u0005#\u0005\u000b\u0011\u0002B$\u0011)\u0011y\u0006\u0010BK\u0002\u0013\u0005!\u0011\r\u0005\u000b\u0005_b$\u0011#Q\u0001\n\t\r\u0004bBA\u0007y\u0011\u0005!\u0011\u000f\u0005\n\u0005wb\u0014\u0011!C\u0001\u0005{B\u0011Ba#=#\u0003%\tA!$\t\u0013\t\u001dF(%A\u0005\u0002\t%\u0006\"\u0003BYy\u0005\u0005I\u0011\tBZ\u0011%\u0011y\fPA\u0001\n\u0003\u0011\t\rC\u0005\u0003Dr\n\t\u0011\"\u0001\u0003F\"I!1\u001a\u001f\u0002\u0002\u0013\u0005#Q\u001a\u0005\n\u0005+d\u0014\u0011!C\u0001\u0005/D\u0011Ba7=\u0003\u0003%\tE!8\t\u0013\t}G(!A\u0005B\t\u0005\b\"\u0003Bry\u0005\u0005I\u0011\tBs\u000f%\u0011IOOA\u0001\u0012\u0003\u0011YOB\u0005\u00032i\n\t\u0011#\u0001\u0003n\"9\u0011Q\u0002(\u0005\u0002\t=\b\"\u0003Bp\u001d\u0006\u0005IQ\tBq\u0011%\u0011\tPTA\u0001\n\u0003\u0013\u0019\u0010C\u0005\u0004\u00029\u000b\t\u0011\"!\u0004\u0004!I1\u0011\u0004(\u0002\u0002\u0013%11\u0004\u0005\n\u0007GQ\u0014\u0013!C\u0001\u0007KA\u0011b!\u000b;#\u0003%\taa\u000b\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI*\u0011\u0001,W\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;B\u0011a,Y\u0007\u0002?*\u0011\u0001-W\u0001\u0006kRLGn]\u0005\u0003E~\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006!a.Y7f!\t)gN\u0004\u0002gYB\u0011qM[\u0007\u0002Q*\u0011\u0011nW\u0001\u0007yI|w\u000e\u001e \u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[*L!aY1\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\fAb]8ve\u000e,'I]8lKJ,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003qf\u000bqa\u00197vgR,'/\u0003\u0002{o\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018!D:pkJ\u001cWM\u0011:pW\u0016\u0014\b%\u0001\bgKR\u001c\u0007NQ1dW>3g-T:\u0011\u0005y|X\"\u00016\n\u0007\u0005\u0005!NA\u0002J]R\fq\"[:J]R,'O];qi&\u0014G.\u001a\t\u0004}\u0006\u001d\u0011bAA\u0005U\n9!i\\8mK\u0006t\u0017bAA\u0002C\u00061A(\u001b8jiz\"B\"!\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\u00012!a\u0005\u0001\u001b\u00059\u0006\"B2\b\u0001\u0004!\u0007\"\u0002:\b\u0001\u0004!\u0007\"B:\b\u0001\u0004)\bb\u0002?\b!\u0003\u0005\r! \u0005\n\u0003\u00079\u0001\u0013!a\u0001\u0003\u000b\u0011\u0011BR3uG\"$\u0015\r^1\u0011\r\u0005\r\u0012QHA\"\u001d\u0011\t)#!\u000f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003[\ty#\u0001\u0004d_6lwN\u001c\u0006\u00045\u0006E\"\u0002BA\u001a\u0003k\ta!\u00199bG\",'BAA\u001c\u0003\ry'oZ\u0005\u0005\u0003w\t9#A\u0007GKR\u001c\u0007NU3ta>t7/Z\u0005\u0005\u0003\u007f\t\tEA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003w\t9\u0003\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\u000b\u0002\rI,7m\u001c:e\u0013\u0011\ti%a\u0012\u0003\u000fI+7m\u001c:eg\nIQ\t]8dQ\u0012\u000bG/\u0019\t\u0005\u0003'\nIF\u0004\u0003\u0002&\u0005U\u0013\u0002BA,\u0003O\tAd\u00144gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002@\u0005m#\u0002BA,\u0003O\tq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0003C\u0002b!a\u0019\u0002j\u00055TBAA3\u0015\u0011\t9'a\u000b\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002BA6\u0003K\u0012q\u0002U1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\t\u0005\u0003'\ty'C\u0002\u0002r]\u00131\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016\f\u0001\u0003]1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002!A\f'\u000f^5uS>tW*\u00199M_\u000e\\WCAA=!\u0011\tY(!$\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000bQ\u0001\\8dWNTA!a!\u0002\u0006\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0005kRLGN\u0003\u0002\u0002\f\u0006!!.\u0019<b\u0013\u0011\ty)! \u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003E\u0001\u0018M\u001d;ji&|g.T1q\u0019>\u001c7\u000eI\u0001\u0011a\u0006\u0014H/\u001b;j_:l\u0015\r]\"p]\u0012,\"!a&\u0011\t\u0005m\u0014\u0011T\u0005\u0005\u00037\u000biHA\u0005D_:$\u0017\u000e^5p]\u0006\t\u0002/\u0019:uSRLwN\\'ba\u000e{g\u000e\u001a\u0011\u0002\u00115,GO]5d\u0013\u0012,\"!a)\u0011\t\u0005\u0015\u0016\u0011V\u0007\u0003\u0003OS1!!\fZ\u0013\u0011\tY+a*\u0003#\rc\u0017.\u001a8u\u0013\u0012\fe\u000e\u001a\"s_.,'/A\u0005nKR\u0014\u0018nY%eA\u0005aa-\u001a;dQ\u0016\u00148\u000b^1ugV\u0011\u00111\u0017\t\u0005\u0003'\t),C\u0002\u00028^\u0013ABR3uG\",'o\u0015;biN\fQBZ3uG\",'o\u0015;biN\u0004\u0013a\u00044fi\u000eDWM\u001d'bON#\u0018\r^:\u0016\u0005\u0005}\u0006\u0003BA\n\u0003\u0003L1!a1X\u0005=1U\r^2iKJd\u0015mZ*uCR\u001c\u0018\u0001\u00054fi\u000eDWM\u001d'bON#\u0018\r^:!\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA\u00111ZAo\u0003S\f\u0019\u0010E\u0003\u007f\u0003\u001b\f\t.C\u0002\u0002P*\u0014aa\u00149uS>t\u0007\u0003BAj\u00033l!!!6\u000b\u0007\u0005]\u0017,A\u0002m_\u001eLA!a7\u0002V\niAj\\4BaB,g\u000eZ%oM>Dq!a8\u0017\u0001\u0004\t\t/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\r\u0018Q]\u0007\u0003\u0003WIA!a:\u0002,\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAv-\u0001\u0007\u0011Q^\u0001\fM\u0016$8\r[(gMN,G\u000fE\u0002\u007f\u0003_L1!!=k\u0005\u0011auN\\4\t\u000f\u0005Uh\u00031\u0001\u0002x\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u00042!!?\t\u001b\u0005\u0001\u0011\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005}(Q\u0001B\u0004!\rq(\u0011A\u0005\u0004\u0005\u0007Q'\u0001B+oSRDq!a8\u0018\u0001\u0004\t\t\u000fC\u0004\u0003\n]\u0001\rAa\u0003\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u0004B!a\u0005\u0003\u000e%\u0019!qB,\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003\u007f\u0014)Ba\u0006\t\u000f\u0005}\u0007\u00041\u0001\u0002b\"9!\u0011\u0004\rA\u0002\u00055\u0018AB8gMN,G/\u0001\u0006ck&dGMR3uG\"$BAa\b\u0004@A)!\u0011\u0005\u001f\u000409\u0019\u00111C\u001d\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bIB\u0019\u00111\u0003\u001e\u0014\u0007i\u0012I\u0003E\u0002\u007f\u0005WI1A!\fk\u0005\u0019\te.\u001f*fMR\u0011!Q\u0005\u0002\u0015%\u0016\u001cX\u000f\u001c;XSRD\u0007+\u0019:uSRLwN\\:\u0016\t\tU\"1J\n\by\t%\"q\u0007B\u001f!\rq(\u0011H\u0005\u0004\u0005wQ'a\u0002)s_\u0012,8\r\u001e\t\u0004}\n}\u0012b\u0001B!U\na1+\u001a:jC2L'0\u00192mK\u00061!/Z:vYR,\"Aa\u0012\u0011\t\t%#1\n\u0007\u0001\t\u001d\u0011i\u0005\u0010b\u0001\u0005\u001f\u0012\u0011AU\t\u0005\u0005#\u00129\u0006E\u0002\u007f\u0005'J1A!\u0016k\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A B-\u0013\r\u0011YF\u001b\u0002\u0004\u0003:L\u0018a\u0002:fgVdG\u000fI\u0001\u0014a\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u000bJ\u0014xN]\u000b\u0003\u0005G\u0002bA!\u001a\u0003l\u0005\u0005XB\u0001B4\u0015\r\u0011IG[\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B7\u0005O\u00121aU3u\u0003Q\u0001\u0018M\u001d;ji&|gn],ji\",%O]8sAQ1!1\u000fB<\u0005s\u0002RA!\u001e=\u0005\u000fj\u0011A\u000f\u0005\b\u0005\u0007\n\u0005\u0019\u0001B$\u0011\u001d\u0011y&\u0011a\u0001\u0005G\nAaY8qsV!!q\u0010BC)\u0019\u0011\tIa\"\u0003\nB)!Q\u000f\u001f\u0003\u0004B!!\u0011\nBC\t\u001d\u0011iE\u0011b\u0001\u0005\u001fB\u0011Ba\u0011C!\u0003\u0005\rAa!\t\u0013\t}#\t%AA\u0002\t\r\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0005\u001f\u0013)+\u0006\u0002\u0003\u0012*\"!q\tBJW\t\u0011)\n\u0005\u0003\u0003\u0018\n\u0005VB\u0001BM\u0015\u0011\u0011YJ!(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BPU\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r&\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,Ga\u0002B'\u0007\n\u0007!qJ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u0011YKa,\u0016\u0005\t5&\u0006\u0002B2\u0005'#qA!\u0014E\u0005\u0004\u0011y%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005k\u0003BAa.\u0003>6\u0011!\u0011\u0018\u0006\u0005\u0005w\u000bI)\u0001\u0003mC:<\u0017bA8\u0003:\u0006a\u0001O]8ek\u000e$\u0018I]5usV\tQ0\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t]#q\u0019\u0005\t\u0005\u0013<\u0015\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa4\u0011\r\t\u0015$\u0011\u001bB,\u0013\u0011\u0011\u0019Na\u001a\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000b\u0011I\u000eC\u0005\u0003J&\u000b\t\u00111\u0001\u0003X\u0005A\u0001.Y:i\u0007>$W\rF\u0001~\u0003!!xn\u0015;sS:<GC\u0001B[\u0003\u0019)\u0017/^1mgR!\u0011Q\u0001Bt\u0011%\u0011I\rTA\u0001\u0002\u0004\u00119&\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004\u0005kr5#\u0002(\u0003*\tuBC\u0001Bv\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\u0011)Pa?\u0015\r\t](Q B\u0000!\u0015\u0011)\b\u0010B}!\u0011\u0011IEa?\u0005\u000f\t5\u0013K1\u0001\u0003P!9!1I)A\u0002\te\bb\u0002B0#\u0002\u0007!1M\u0001\bk:\f\u0007\u000f\u001d7z+\u0011\u0019)a!\u0005\u0015\t\r\u001d11\u0003\t\u0006}\u000657\u0011\u0002\t\b}\u000e-1q\u0002B2\u0013\r\u0019iA\u001b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t%3\u0011\u0003\u0003\b\u0005\u001b\u0012&\u0019\u0001B(\u0011%\u0019)BUA\u0001\u0002\u0004\u00199\"A\u0002yIA\u0002RA!\u001e=\u0007\u001f\t1B]3bIJ+7o\u001c7wKR\u00111Q\u0004\t\u0005\u0005o\u001by\"\u0003\u0003\u0004\"\te&AB(cU\u0016\u001cG/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007OQ3! BJ\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111Q\u0006\u0016\u0005\u0003\u000b\u0011\u0019\nE\u0003\u007f\u0003\u001b\u001c\t\u0004\u0005\u0003\u00044\reb\u0002BA\u0013\u0007kIAaa\u000e\u0002(\u0005aa)\u001a;dQJ+\u0017/^3ti&!11HB\u001f\u0005\u001d\u0011U/\u001b7eKJTAaa\u000e\u0002(!91\u0011I\rA\u0002\r\r\u0013\u0001\u00049beRLG/[8o\u001b\u0006\u0004\b\u0003\u0003B3\u0007\u000b\n\t/!\u001c\n\t\r\u001d#q\r\u0002\u0004\u001b\u0006\u0004\u0018a\u00037bi\u0016\u001cH/\u00129pG\"$Ba!\u0014\u0004PA!a0!4~\u0011\u001d\tyN\u0007a\u0001\u0003C\fA\u0002\\8h\u000b:$wJ\u001a4tKR$B!!<\u0004V!9\u0011q\\\u000eA\u0002\u0005\u0005\u0018!E3oI>3gm]3u\r>\u0014X\t]8dQR111LB2\u0007K\u0002RA`Ag\u0007;\u0002B!a\u0005\u0004`%\u00191\u0011M,\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"9\u0011q\u001c\u000fA\u0002\u0005\u0005\bBBB49\u0001\u0007Q0A\u0003fa>\u001c\u0007.\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0007[\u001a)\b\u0005\u0005\u0003f\r\u0015\u0013\u0011]B8!\u0011\t)c!\u001d\n\t\rM\u0014q\u0005\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011\u001d\u00199(\ba\u0001\u0007s\n!\u0002]1si&$\u0018n\u001c8t!!\u0011)g!\u0012\u0002b\u000em\u0004cAA}\u0013\u0005ya-\u001a;dQ\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0003\u0004\u0002\u000eU\u0005CBBB\u0007\u001b\u001b\u0019J\u0004\u0003\u0004\u0006\u000e%ebA4\u0004\b&\t1.C\u0002\u0004\f*\fq\u0001]1dW\u0006<W-\u0003\u0003\u0004\u0010\u000eE%aA*fc*\u001911\u00126\u0011\u000fy\u001cY!!9\u0002x\"91q\u0013\u0010A\u0002\rE\u0012\u0001\u00044fi\u000eD'+Z9vKN$\u0018!\b4fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u000558QTBP\u0011\u001d\tyn\ba\u0001\u0003CDaa!) \u0001\u0004i\u0018AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f1DZ3uG\"d\u0015\r^3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBAw\u0007O\u001bI\u000bC\u0004\u0002`\u0002\u0002\r!!9\t\r\r\u0005\u0006\u00051\u0001~\u0003}I7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u0003\u000b\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u007f\fa\u0001Z8X_J\\\u0017AC7bs\n,g)\u001a;dQ\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR!\u0011q`B^\u0011\u001d\u00199(\na\u0001\u0007{\u0003baa!\u0004@\u0006\u0005\u0018\u0002BBa\u0007#\u0013\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u001aM\u0016$8\r\u001b+sk:\u001c\u0017\r^5oOB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0004HB9apa\u0003\u0004z\t\r\u0014!D7bs\n,GK];oG\u0006$X-A\rueVt7-\u0019;f)>,\u0005o\\2i\u000b:$wJ\u001a4tKR\u001cH\u0003BA\u0000\u0007\u001fDqa!5)\u0001\u0004\u0019I(A\rmCR,7\u000f^#q_\u000eD7OR8s!\u0006\u0014H/\u001b;j_:\u001c\u0018a\u0006;sk:\u001c\u0017\r^3U_\"Kw\r[,bi\u0016\u0014X.\u0019:l)\u0011\typa6\t\u000f\r]\u0014\u00061\u0001\u0003d\u0005qR.Y=cKR\u0013XO\\2bi\u0016$v.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0007;\u001c\t\u000fE\u0003\u0003\"q\u001ay\u000e\u0005\u0005\u0003f\r\u0015\u0013\u0011\u001dB\u0006\u0011\u001d\u0019\u0019O\u000ba\u0001\u0007[\nQBZ3uG\",G-\u00129pG\"\u001c\u0018!E8o!\u0006\u0014H/\u001b;j_:4UM\\2fIR!\u0011q`Bu\u0011\u001d\u0019Yo\u000ba\u0001\u0003C\f!\u0001\u001e9\u0002'A\u0014xnY3tg\u001a+Go\u00195SKF,Xm\u001d;\u0015\r\u0005}8\u0011_B{\u0011\u001d\u0019\u0019\u0010\fa\u0001\u0007\u0007\n1BZ3uG\"\u001cF/\u0019;fg\"91q\u0013\u0017A\u0002\rE\u0012aG7be.\u0004\u0016M\u001d;ji&|gn\u001d$peR\u0013XO\\2bi&|g\u000e\u0006\u0004\u0002\u0000\u000em8Q \u0005\b\u0003?l\u0003\u0019AAq\u0011\u001d\u0019y0\fa\u0001\u0003[\f\u0001\u0003\u001e:v]\u000e\fG/[8o\u001f\u001a47/\u001a;\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0011\ty\u0010\"\u0002\t\u000f\u0011\u001da\u00061\u0001\u0005\n\u0005\u0011\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3t!!\u0011)g!\u0012\u0002b\u000eu\u0013aL;qI\u0006$XMR3uG\"|eMZ:fi\u0006sG-T1zE\u0016l\u0015M]6UeVt7-\u0019;j_:\u001cu.\u001c9mKR,G\u0003BA\u0000\t\u001fAq\u0001\"\u00050\u0001\u0004\u0019y.\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$8/\u0001\rhKR|eMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016$bAa\u0003\u0005\u0018\u0011e\u0001bBBva\u0001\u0007\u0011\u0011\u001d\u0005\b\t7\u0001\u0004\u0019AB8\u0003EaW-\u00193fe\u0016\u0003xn\u00195PM\u001a\u001cX\r^\u0001\u0016Q\u0006tG\r\\3PkR|eMU1oO\u0016,%O]8s)\u0019\t)\u0001\"\t\u0005$!9\u0011q\\\u0019A\u0002\u0005\u0005\bb\u0002C\u0013c\u0001\u0007\u0011QN\u0001\u000bM\u0016$8\r[*uCR,\u0017A\u00064fi\u000eDwJ\u001a4tKR\fe\u000e\u001a+sk:\u001c\u0017\r^3\u0015\r\u00055H1\u0006C\u0017\u0011\u001d\tyN\ra\u0001\u0003CDaa!)3\u0001\u0004i\u0018a\u00043fY\u0006L\b+\u0019:uSRLwN\\:\u0015\r\u0005}H1\u0007C\u001b\u0011\u001d\u00199h\ra\u0001\u0007{Cq\u0001b\u000e4\u0001\u0004\ti/A\u0003eK2\f\u00170\u0001\tsK6|g/\u001a)beRLG/[8ogR!\u0011q C\u001f\u0011\u001d!y\u0004\u000ea\u0001\u0005G\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u)\u0011!)\u0005b\u0012\u0011\u000by\fi-!\u001c\t\u000f\u0005}g\u00071\u0001\u0002b\u0006!\u0002/\u0019:uSRLwN\\:B]\u0012|eMZ:fiN,\"\u0001\"\u0014\u0011\u0011\t\u00154QIAq\t\u001f\u0002B!a\u0005\u0005R%\u0019A1K,\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X-A\bu_6+Wn\u001c:z%\u0016\u001cwN\u001d3t)\u0011!I\u0006b\u0018\u0011\t\u0005\u0015C1L\u0005\u0005\t;\n9EA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\tCB\u0004\u0019AA\"\u0003\u001d\u0011XmY8sIN\u0004")
public abstract class AbstractFetcherThread
extends ShutdownableThread {
    private final BrokerEndPoint sourceBroker;
    private final int fetchBackOffMs;
    private final PartitionStates<PartitionFetchState> partitionStates;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;

    public static boolean $lessinit$greater$default$5() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$4();
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    private PartitionStates<PartitionFetchState> partitionStates() {
        return this.partitionStates;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public abstract Option<LogAppendInfo> processPartitionData(TopicPartition var1, long var2, FetchResponse.PartitionData<Records> var4);

    public abstract void truncate(TopicPartition var1, OffsetTruncationState var2);

    public abstract void truncateFullyAndStartAt(TopicPartition var1, long var2);

    public abstract ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> var1);

    public abstract Option<Object> latestEpoch(TopicPartition var1);

    public abstract long logEndOffset(TopicPartition var1);

    public abstract Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition var1, int var2);

    public abstract Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> var1);

    public abstract Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder var1);

    public abstract long fetchEarliestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract long fetchLatestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract boolean isOffsetForLeaderEpochSupported();

    @Override
    public void shutdown() {
        this.initiateShutdown();
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.partitionMapCond().signalAll());
        this.awaitShutdown();
        this.fetcherStats().unregister();
        this.fetcherLagStats().unregister();
    }

    @Override
    public void doWork() {
        this.maybeTruncate();
        this.maybeFetch();
    }

    private void maybeFetch() {
        Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.partitionStates().partitionStateMap()).asScala();
            ResultWithPartitions<Option<FetchRequest.Builder>> resultWithPartitions = this.buildFetch((Map<TopicPartition, PartitionFetchState>)fetchStates);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Option<FetchRequest.Builder> fetchRequestOpt = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchRequestOpt, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Option fetchRequestOpt2 = (Option)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2);
            if (fetchRequestOpt2.isEmpty()) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("There are no active partitions. Back off for ").append($this.fetchBackOffMs).append(" ms before sending a fetch request").toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            return new Tuple2((Object)fetchStates, (Object)fetchRequestOpt2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)tuple2._1();
        Option fetchRequestOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetchStates, (Object)fetchRequestOpt);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map fetchStates2 = (scala.collection.mutable.Map)tuple23._1();
        Option fetchRequestOpt2 = (Option)tuple23._2();
        fetchRequestOpt2.foreach((Function1 & Serializable & scala.Serializable)fetchRequest -> {
            this.processFetchRequest((Map<TopicPartition, PartitionFetchState>)fetchStates2, fetchRequest);
            return BoxedUnit.UNIT;
        });
    }

    private void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.delayPartitions(partitions, this.fetchBackOffMs);
        }
    }

    private Tuple2<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>, Set<TopicPartition>> fetchTruncatingPartitions() {
        return (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map partitionsWithEpochs = Map$.MODULE$.empty();
            scala.collection.mutable.Set partitionsWithoutEpochs = Set$.MODULE$.empty();
            this.partitionStates().stream().forEach(new Consumer<PartitionStates.PartitionState<PartitionFetchState>>(this, partitionsWithEpochs, partitionsWithoutEpochs){
                private final /* synthetic */ AbstractFetcherThread $outer;
                private final scala.collection.mutable.Map partitionsWithEpochs$1;
                private final scala.collection.mutable.Set partitionsWithoutEpochs$1;

                public Consumer<PartitionStates.PartitionState<PartitionFetchState>> andThen(Consumer<? super PartitionStates.PartitionState<PartitionFetchState>> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void accept(PartitionStates.PartitionState<PartitionFetchState> state) {
                    if (!state.value().isTruncating()) return;
                    TopicPartition tp = state.topicPartition();
                    Option<Object> option = this.$outer.latestEpoch(tp);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int epoch = BoxesRunTime.unboxToInt((Object)some.value());
                        if (this.$outer.isOffsetForLeaderEpochSupported()) {
                            this.partitionsWithEpochs$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.of(Predef$.MODULE$.int2Integer(state.value().currentLeaderEpoch())), epoch)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                    this.partitionsWithoutEpochs$1.$plus$eq((Object)tp);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionsWithEpochs$1 = partitionsWithEpochs$1;
                    this.partitionsWithoutEpochs$1 = partitionsWithoutEpochs$1;
                }
            });
            return new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
        });
    }

    private void maybeTruncate() {
        block2: {
            Tuple2<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>, Set<TopicPartition>> tuple2 = this.fetchTruncatingPartitions();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Map partitionsWithEpochs = (Map)tuple2._1();
            Set partitionsWithoutEpochs = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
            Tuple2 tuple23 = tuple22;
            Map partitionsWithEpochs2 = (Map)tuple23._1();
            Set partitionsWithoutEpochs2 = (Set)tuple23._2();
            if (partitionsWithEpochs2.nonEmpty()) {
                this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>)partitionsWithEpochs2);
            }
            if (!partitionsWithoutEpochs2.nonEmpty()) break block2;
            this.truncateToHighWatermark((Set<TopicPartition>)partitionsWithoutEpochs2);
        }
    }

    private void truncateToEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> latestEpochsForPartitions) {
        Map<TopicPartition, EpochEndOffset> endOffsets = this.fetchEpochEndOffsets(latestEpochsForPartitions);
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map epochEndOffsets = (Map)endOffsets.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$truncateToEpochEndOffsets$2(this, latestEpochsForPartitions, x0$1)));
            ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> resultWithPartitions = this.maybeTruncateToEpochEndOffsets((Map<TopicPartition, EpochEndOffset>)epochEndOffsets);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Map<TopicPartition, OffsetTruncationState> fetchOffsets = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchOffsets, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Map fetchOffsets2 = (Map)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2);
            this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets2);
        });
    }

    public void truncateToHighWatermark(Set<TopicPartition> partitions) {
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HashMap fetchOffsets = HashMap$.MODULE$.empty();
            HashSet partitionsWithError = HashSet$.MODULE$.empty();
            partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
                BoxedUnit boxedUnit;
                PartitionFetchState partitionState = this.partitionStates().stateValue((TopicPartition)tp);
                if (partitionState != null) {
                    try {
                        long highWatermark = partitionState.fetchOffset();
                        OffsetTruncationState truncationState = new OffsetTruncationState(highWatermark, true);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Truncating partition ").append(tp).append(" to local high watermark ").append(highWatermark).toString());
                        this.truncate((TopicPartition)tp, truncationState);
                        boxedUnit = fetchOffsets.put(tp, (Object)truncationState);
                    }
                    catch (KafkaStorageException e) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to truncate ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        boxedUnit = partitionsWithError.$plus$eq(tp);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError);
            this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets);
        });
    }

    private ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncateToEpochEndOffsets(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        HashSet partitionsWithError = HashSet$.MODULE$.empty();
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HashSet hashSet;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset leaderEpochOffset = (EpochEndOffset)tuple2._2();
                try {
                    BoxedUnit boxedUnit;
                    Errors errors = leaderEpochOffset.error();
                    if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
                        OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState(tp, leaderEpochOffset);
                        this.truncate(tp, offsetTruncationState);
                        boxedUnit = fetchOffsets.put((Object)tp, (Object)offsetTruncationState);
                    } else if (((Object)((Object)Errors.FENCED_LEADER_EPOCH)).equals((Object)errors)) {
                        this.onPartitionFenced(tp);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Retrying leaderEpoch request for partition ").append(tp).append(" as the leader reported an error: ").append((Object)errors).toString());
                        boxedUnit = partitionsWithError.$plus$eq((Object)tp);
                    }
                    hashSet = boxedUnit;
                }
                catch (KafkaStorageException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to truncate ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    hashSet = partitionsWithError.$plus$eq((Object)tp);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        });
        return new ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    private void onPartitionFenced(TopicPartition tp) {
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.partitionStates().stateValue(tp)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$onPartitionFenced$2(this, tp, currentFetchState);
            return BoxedUnit.UNIT;
        }));
    }

    private void processFetchRequest(Map<TopicPartition, PartitionFetchState> fetchStates, FetchRequest.Builder fetchRequest) {
        block3: {
            Object object;
            scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            ObjectRef responseData = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
            try {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Sending fetch request ").append(fetchRequest).toString());
                responseData.elem = this.fetchFromLeader(fetchRequest);
                object = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                if (this.isRunning()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error in response for fetch request ").append(fetchRequest).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    object = CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        partitionsWithError.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.partitionStates().partitionSet()).asScala());
                        return this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS);
                    });
                }
                object = BoxedUnit.UNIT;
            }
            this.fetcherStats().requestRate().mark();
            Object object2 = ((Seq)responseData.elem).nonEmpty() ? CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Seq)responseData$1.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbstractFetcherThread.$anonfun$processFetchRequest$6(this, fetchStates, partitionsWithError, x0$1);
                return BoxedUnit.UNIT;
            })) : BoxedUnit.UNIT;
            if (!partitionsWithError.nonEmpty()) break block3;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Handling errors for partitions ").append(partitionsWithError).toString());
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError);
        }
    }

    public void markPartitionsForTruncation(TopicPartition topicPartition, long truncationOffset) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Option$.MODULE$.apply((Object)this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)state -> {
                AbstractFetcherThread.$anonfun$markPartitionsForTruncation$1(this, truncationOffset, topicPartition, state);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        this.partitionMapLock().lockInterruptibly();
        try {
            initialFetchStates.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbstractFetcherThread.$anonfun$addPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        scala.collection.immutable.Map newStates = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)state -> {
            PartitionFetchState partitionFetchState;
            PartitionFetchState currentFetchState = (PartitionFetchState)state.value();
            Option option = fetchOffsets.get((Object)state.topicPartition());
            if (option instanceof Some) {
                Some some = (Some)option;
                OffsetTruncationState offsetTruncationState = (OffsetTruncationState)some.value();
                Product state2 = offsetTruncationState.truncationCompleted() ? Fetching$.MODULE$ : Truncating$.MODULE$;
                partitionFetchState = new PartitionFetchState(offsetTruncationState.offset(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), (ReplicaState)state2);
            } else if (None$.MODULE$.equals(option)) {
                partitionFetchState = currentFetchState;
            } else {
                throw new MatchError((Object)option);
            }
            PartitionFetchState maybeTruncationComplete = partitionFetchState;
            return new Tuple2((Object)state.topicPartition(), (Object)maybeTruncationComplete);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.partitionStates().set((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newStates).asJava());
    }

    private OffsetTruncationState getOffsetTruncationState(TopicPartition tp, EpochEndOffset leaderEpochOffset) {
        return (OffsetTruncationState)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetTruncationState offsetTruncationState;
            if (leaderEpochOffset.endOffset() == -1L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Based on replica's leader epoch, leader replied with an unknown offset in ").append(tp).append(". ").append(new StringBuilder(54).append("The initial fetch offset ").append(this.partitionStates().stateValue(tp).fetchOffset()).append(" will be used for truncation.").toString()).toString());
                offsetTruncationState = new OffsetTruncationState(this.partitionStates().stateValue(tp).fetchOffset(), true);
            } else if (leaderEpochOffset.leaderEpoch() == -1) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Leader or replica is on protocol version where leader epoch is not considered in the OffsetsForLeaderEpoch response. ").append(new StringBuilder(53).append("The leader's offset ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation in ").append(tp).append(".").toString()).toString());
                offsetTruncationState = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), this.logEndOffset(tp)), true);
            } else {
                OffsetTruncationState offsetTruncationState2;
                Some some;
                OffsetAndEpoch offsetAndEpoch;
                long replicaEndOffset = this.logEndOffset(tp);
                Option<OffsetAndEpoch> option = this.endOffsetForEpoch(tp, leaderEpochOffset.leaderEpoch());
                if (option instanceof Some && (offsetAndEpoch = (OffsetAndEpoch)(some = (Some)option).value()) != null) {
                    OffsetTruncationState offsetTruncationState3;
                    long followerEndOffset = offsetAndEpoch.offset();
                    int followerEpoch = offsetAndEpoch.leaderEpoch();
                    if (followerEpoch != leaderEpochOffset.leaderEpoch()) {
                        long intermediateOffsetToTruncateTo = package$.MODULE$.min(followerEndOffset, replicaEndOffset);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").append(new StringBuilder(29).append("unknown to the replica for ").append(tp).append(". ").toString()).append(new StringBuilder(70).append("Will truncate to ").append(intermediateOffsetToTruncateTo).append(" and send another leader epoch request to the leader.").toString()).toString());
                        offsetTruncationState3 = new OffsetTruncationState(intermediateOffsetToTruncateTo, false);
                    } else {
                        long offsetToTruncateTo = package$.MODULE$.min(followerEndOffset, leaderEpochOffset.endOffset());
                        offsetTruncationState3 = new OffsetTruncationState(package$.MODULE$.min(offsetToTruncateTo, replicaEndOffset), true);
                    }
                    offsetTruncationState2 = offsetTruncationState3;
                } else if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").append(new StringBuilder(41).append("below any replica's tracked epochs for ").append(tp).append(". ").toString()).append(new StringBuilder(54).append("The leader's offset only ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation.").toString()).toString());
                    offsetTruncationState2 = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), replicaEndOffset), true);
                } else {
                    throw new MatchError(option);
                }
                offsetTruncationState = offsetTruncationState2;
            }
            return offsetTruncationState;
        });
    }

    private boolean handleOutOfRangeError(TopicPartition topicPartition, PartitionFetchState fetchState) {
        boolean bl;
        try {
            long newOffset = this.fetchOffsetAndTruncate(topicPartition, fetchState.currentLeaderEpoch());
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(newOffset, fetchState.currentLeaderEpoch(), Fetching$.MODULE$);
            this.partitionStates().updateAndMoveToEnd(topicPartition, newFetchState);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Current offset ").append(fetchState.fetchOffset()).append(" for partition ").append(topicPartition).append(" is ").append(new StringBuilder(77).append("out of range, which typically implies a leader change. Reset fetch offset to ").append(newOffset).toString()).toString());
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FencedLeaderEpochException) {
                this.onPartitionFenced(topicPartition);
                bl2 = true;
            } else {
                boolean bl3 = throwable2 instanceof UnknownTopicOrPartitionException ? true : (throwable2 instanceof UnknownLeaderEpochException ? true : throwable2 instanceof NotLeaderForPartitionException);
                if (bl3) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Could not fetch offset for ").append(topicPartition).append(" due to error: ").append(throwable2.getMessage()).toString());
                    bl2 = false;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error getting offset for partition ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    bl2 = false;
                } else {
                    throw throwable;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public long fetchOffsetAndTruncate(TopicPartition topicPartition, int currentLeaderEpoch) {
        long l;
        long replicaEndOffset = this.logEndOffset(topicPartition);
        long leaderEndOffset = this.fetchLatestOffsetFromLeader(topicPartition, currentLeaderEpoch);
        if (leaderEndOffset < replicaEndOffset) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").append(new StringBuilder(23).append("leader's latest offset ").append(leaderEndOffset).toString()).toString());
            this.truncate(topicPartition, new OffsetTruncationState(leaderEndOffset, true));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.fetchEarliestOffsetFromLeader(topicPartition, currentLeaderEpoch);
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").append(new StringBuilder(22).append("leader's start offset ").append(leaderStartOffset).toString()).toString());
            long offsetToFetch = Math.max(leaderStartOffset, replicaEndOffset);
            if (leaderStartOffset > replicaEndOffset) {
                this.truncateFullyAndStartAt(topicPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    public void delayPartitions(Iterable<TopicPartition> partitions, long delay) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                AbstractFetcherThread.$anonfun$delayPartitions$1(this, delay, partition);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicPartition> topicPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                AbstractFetcherThread.$anonfun$removePartitions$1(this, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        int n;
        this.partitionMapLock().lockInterruptibly();
        try {
            n = this.partitionStates().size();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return n;
    }

    public Option<PartitionFetchState> fetchState(TopicPartition topicPartition) {
        return (Option)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.partitionStates().stateValue(topicPartition)));
    }

    public Map<TopicPartition, InitialFetchState> partitionsAndOffsets() {
        return (Map)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)state -> {
            InitialFetchState initialFetchState = new InitialFetchState(this.sourceBroker(), ((PartitionFetchState)state.value()).currentLeaderEpoch(), ((PartitionFetchState)state.value()).fetchOffset());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicPartition()), (Object)initialFetchState);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public MemoryRecords toMemoryRecords(Records records) {
        MemoryRecords memoryRecords;
        Records records2 = records;
        if (records2 instanceof MemoryRecords) {
            MemoryRecords memoryRecords2;
            memoryRecords = memoryRecords2 = (MemoryRecords)records2;
        } else if (records2 instanceof FileRecords) {
            FileRecords fileRecords = (FileRecords)records2;
            ByteBuffer buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
            fileRecords.readInto(buffer, 0);
            memoryRecords = MemoryRecords.readableRecords(buffer);
        } else {
            throw new MatchError((Object)records2);
        }
        return memoryRecords;
    }

    public static final /* synthetic */ boolean $anonfun$truncateToEpochEndOffsets$2(AbstractFetcherThread $this, Map latestEpochsForPartitions$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        PartitionFetchState curPartitionState = $this.partitionStates().stateValue(tp);
        OffsetsForLeaderEpochRequest.PartitionData partitionEpochRequest = (OffsetsForLeaderEpochRequest.PartitionData)latestEpochsForPartitions$1.get((Object)tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(77).append("Leader replied with partition ").append(tp).append(" not requested in OffsetsForLeaderEpoch request").toString());
        });
        Integer leaderEpochInRequest = partitionEpochRequest.currentLeaderEpoch.get();
        boolean bl = curPartitionState != null && BoxesRunTime.equalsNumObject((Number)leaderEpochInRequest, (Object)BoxesRunTime.boxToInteger((int)curPartitionState.currentLeaderEpoch()));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onPartitionFenced$2(AbstractFetcherThread $this, TopicPartition tp$4, PartitionFetchState currentFetchState) {
        int currentLeaderEpoch = currentFetchState.currentLeaderEpoch();
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Partition ").append(tp$4).append(" has an older epoch (").append(currentLeaderEpoch).append(") than the current leader. Will await ").append("the new LeaderAndIsr state before resuming fetching.").toString());
        $this.partitionStates().remove(tp$4);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$8(AbstractFetcherThread $this, PartitionFetchState currentFetchState$1, TopicPartition topicPartition$1, FetchResponse.PartitionData partitionData$1, PartitionFetchState fetchState$1, LogAppendInfo logAppendInfo) {
        block0: {
            int validBytes = logAppendInfo.validBytes();
            long nextOffset = validBytes > 0 ? logAppendInfo.lastOffset() + 1L : currentFetchState$1.fetchOffset();
            $this.fetcherLagStats().getAndMaybePut(topicPartition$1).lag_$eq(Math.max(0L, partitionData$1.highWatermark - nextOffset));
            if (validBytes <= 0 || !$this.partitionStates().contains(topicPartition$1)) break block0;
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(nextOffset, fetchState$1.currentLeaderEpoch(), Fetching$.MODULE$);
            $this.partitionStates().updateAndMoveToEnd(topicPartition$1, newFetchState);
            $this.fetcherStats().byteRate().mark(validBytes);
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$6(AbstractFetcherThread $this, Map fetchStates$2, scala.collection.mutable.Set partitionsWithError$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)tuple2._2();
        Option$.MODULE$.apply((Object)$this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            BoxedUnit boxedUnit;
            PartitionFetchState fetchState = (PartitionFetchState)fetchStates$2.apply((Object)topicPartition);
            if (fetchState.fetchOffset() == currentFetchState.fetchOffset() && currentFetchState.isReadyForFetch()) {
                BoxedUnit boxedUnit2;
                Errors errors = partitionData$1.error;
                if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
                    SetLike setLike;
                    try {
                        Option<LogAppendInfo> logAppendInfoOpt = $this.processPartitionData(topicPartition, currentFetchState.fetchOffset(), partitionData);
                        logAppendInfoOpt.foreach((Function1 & Serializable & scala.Serializable)logAppendInfo -> {
                            AbstractFetcherThread.$anonfun$processFetchRequest$8($this, currentFetchState, topicPartition, partitionData, fetchState, logAppendInfo);
                            return BoxedUnit.UNIT;
                        });
                        setLike = BoxedUnit.UNIT;
                    }
                    catch (CorruptRecordException ime) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found invalid messages during fetch for partition ").append(topicPartition).append(" ").append(new StringBuilder(7).append("offset ").append(currentFetchState.fetchOffset()).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ime);
                        setLike = partitionsWithError$3.$plus$eq((Object)topicPartition);
                    }
                    catch (KafkaStorageException e) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error while processing data for partition ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        setLike = partitionsWithError$3.$plus$eq((Object)topicPartition);
                    }
                    catch (Throwable e) {
                        throw new KafkaException(new StringBuilder(37).append("Error processing data for partition ").append(topicPartition).append(" ").append(new StringBuilder(7).append("offset ").append(currentFetchState.fetchOffset()).toString()).toString(), e);
                    }
                    boxedUnit2 = setLike;
                } else if (((Object)((Object)Errors.OFFSET_OUT_OF_RANGE)).equals((Object)errors)) {
                    boxedUnit2 = !$this.handleOutOfRangeError(topicPartition, (PartitionFetchState)currentFetchState) ? partitionsWithError$3.$plus$eq((Object)topicPartition) : BoxedUnit.UNIT;
                } else if (((Object)((Object)Errors.UNKNOWN_LEADER_EPOCH)).equals((Object)errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Remote broker has a smaller leader epoch for partition ").append(topicPartition).append(" than ").append(new StringBuilder(40).append("this replica's current leader epoch of ").append(fetchState.currentLeaderEpoch()).append(".").toString()).toString());
                    boxedUnit2 = partitionsWithError$3.$plus$eq((Object)topicPartition);
                } else if (((Object)((Object)Errors.FENCED_LEADER_EPOCH)).equals((Object)errors)) {
                    $this.onPartitionFenced(topicPartition);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (((Object)((Object)Errors.NOT_LEADER_FOR_PARTITION)).equals((Object)errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("Remote broker is not the leader for partition ").append(topicPartition).append(", which could indicate ").append("that the partition is being moved").toString());
                    boxedUnit2 = partitionsWithError$3.$plus$eq((Object)topicPartition);
                } else {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error for partition ").append(topicPartition).append(" at offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> partitionData$1.error.exception());
                    boxedUnit2 = partitionsWithError$3.$plus$eq((Object)topicPartition);
                }
                boxedUnit = boxedUnit2;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherThread $this, long truncationOffset$1, TopicPartition topicPartition$2, PartitionFetchState state) {
        PartitionFetchState newState = new PartitionFetchState(package$.MODULE$.min(truncationOffset$1, state.fetchOffset()), state.currentLeaderEpoch(), state.delay(), Truncating$.MODULE$);
        $this.partitionStates().updateAndMoveToEnd(topicPartition$2, newState);
        $this.partitionMapCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AbstractFetcherThread $this, Tuple2 x0$1) {
        PartitionFetchState partitionFetchState;
        TopicPartition tp;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            tp = (TopicPartition)tuple2._1();
            OffsetAndEpoch initialFetchState = (OffsetAndEpoch)tuple2._2();
            PartitionFetchState currentState = $this.partitionStates().stateValue(tp);
            if (currentState != null && currentState.currentLeaderEpoch() == initialFetchState.leaderEpoch()) {
                partitionFetchState = currentState;
            } else {
                long initialFetchOffset = initialFetchState.offset() < 0L ? $this.fetchOffsetAndTruncate(tp, initialFetchState.leaderEpoch()) : initialFetchState.offset();
                partitionFetchState = PartitionFetchState$.MODULE$.apply(initialFetchOffset, initialFetchState.leaderEpoch(), Truncating$.MODULE$);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState updatedState = partitionFetchState;
        $this.partitionStates().updateAndMoveToEnd(tp, updatedState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$2(AbstractFetcherThread $this, TopicPartition partition$1, long delay$1, PartitionFetchState currentFetchState) {
        block0: {
            if (currentFetchState.isDelayed()) break block0;
            $this.partitionStates().updateAndMoveToEnd(partition$1, new PartitionFetchState(currentFetchState.fetchOffset(), currentFetchState.currentLeaderEpoch(), new DelayedItem(delay$1), currentFetchState.state()));
        }
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$1(AbstractFetcherThread $this, long delay$1, TopicPartition partition) {
        Option$.MODULE$.apply((Object)$this.partitionStates().stateValue(partition)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$delayPartitions$2($this, partition, delay$1, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removePartitions$1(AbstractFetcherThread $this, TopicPartition topicPartition) {
        $this.partitionStates().remove(topicPartition);
        $this.fetcherLagStats().unregister(topicPartition);
    }

    public AbstractFetcherThread(String name, String clientId, BrokerEndPoint sourceBroker, int fetchBackOffMs, boolean isInterruptible) {
        this.sourceBroker = sourceBroker;
        this.fetchBackOffMs = fetchBackOffMs;
        super(name, isInterruptible);
        this.partitionStates = new PartitionStates();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.metricId = new ClientIdAndBroker(clientId, sourceBroker.host(), sourceBroker.port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
    }

    public static class ResultWithPartitions<R>
    implements Product,
    scala.Serializable {
        private final R result;
        private final Set<TopicPartition> partitionsWithError;

        public R result() {
            return this.result;
        }

        public Set<TopicPartition> partitionsWithError() {
            return this.partitionsWithError;
        }

        public <R> ResultWithPartitions<R> copy(R result, Set<TopicPartition> partitionsWithError) {
            return new ResultWithPartitions<R>(result, partitionsWithError);
        }

        public <R> R copy$default$1() {
            return this.result();
        }

        public <R> Set<TopicPartition> copy$default$2() {
            return this.partitionsWithError();
        }

        public String productPrefix() {
            return "ResultWithPartitions";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.result();
                    break;
                }
                case 1: {
                    object = this.partitionsWithError();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResultWithPartitions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResultWithPartitions)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResultWithPartitions resultWithPartitions = (ResultWithPartitions)x$1;
            if (!BoxesRunTime.equals(this.result(), resultWithPartitions.result())) return false;
            Set<TopicPartition> set = this.partitionsWithError();
            Set<TopicPartition> set2 = resultWithPartitions.partitionsWithError();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!resultWithPartitions.canEqual(this)) return false;
            return true;
        }

        public ResultWithPartitions(R result, Set<TopicPartition> partitionsWithError) {
            this.result = result;
            this.partitionsWithError = partitionsWithError;
            Product.$init$((Product)this);
        }
    }
}

