/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.DelayedDeleteRecordsMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.DeleteRecordsPartitionStatus;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0003\u0006\u0001\u001f!IA\u0003\u0001B\u0001B\u0003%Qc\u0007\u0005\t9\u0001\u0011\t\u0011)A\u0005;!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015)\u0006\u0001\"\u0011U\u0005Q!U\r\\1zK\u0012$U\r\\3uKJ+7m\u001c:eg*\u00111\u0002D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0015%\u00111C\u0003\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fq\u0001Z3mCfl5\u000f\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0003M_:<\u0017B\u0001\u000b\u0013\u0003M!W\r\\3uKJ+7m\u001c:egN#\u0018\r^;t!\u0011q\u0012e\t\u0018\u000e\u0003}Q!\u0001I\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002#?\t\u0019Q*\u00199\u0011\u0005\u0011bS\"A\u0013\u000b\u0005\u0019:\u0013AB2p[6|gN\u0003\u0002\u000eQ)\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\tiSE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005Ey\u0013B\u0001\u0019\u000b\u0005q!U\r\\3uKJ+7m\u001c:egB\u000b'\u000f^5uS>t7\u000b^1ukN\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\u0012g%\u0011AG\u0003\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0017oe\"\u0015B\u0001\u001d\u0018\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u001fC\rR\u0004CA\u001eB\u001d\tat(D\u0001>\u0015\tqT%\u0001\u0005sKF,Xm\u001d;t\u0013\t\u0001U(A\u000bEK2,G/\u001a*fG>\u0014Hm\u001d*fgB|gn]3\n\u0005\t\u001b%!\u0005)beRLG/[8o%\u0016\u001c\bo\u001c8tK*\u0011\u0001)\u0010\t\u0003-\u0015K!AR\f\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%S5\nT'\u0011\u0005E\u0001\u0001\"\u0002\u000b\u0006\u0001\u0004)\u0002\"\u0002\u000f\u0006\u0001\u0004i\u0002\"B\u0019\u0006\u0001\u0004\u0011\u0004\"B\u001b\u0006\u0001\u00041\u0014a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012\u0001\u0015\t\u0003-EK!AU\f\u0003\u000f\t{w\u000e\\3b]\u0006aqN\\#ya&\u0014\u0018\r^5p]R\tA)\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004")
public class DelayedDeleteRecords
extends DelayedOperation {
    private final Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, DeleteRecordsResponse.PartitionResponse>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        this.deleteRecordsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DelayedDeleteRecords.$anonfun$tryComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        return !this.deleteRecordsStatus.values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.acksPending())) ? this.forceComplete() : false;
    }

    @Override
    public void onExpiration() {
        this.deleteRecordsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DelayedDeleteRecords.$anonfun$onExpiration$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onComplete() {
        Map responseStatus = this.deleteRecordsStatus.mapValues((Function1 & Serializable & scala.Serializable)status -> status.responseStatus());
        this.responseCallback.apply((Object)responseStatus);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedDeleteRecords $this, Tuple2 x0$1) {
        DeleteRecordsPartitionStatus status;
        TopicPartition topicPartition;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            topicPartition = (TopicPartition)tuple2._1();
            status = (DeleteRecordsPartitionStatus)tuple2._2();
            Errors errors = status.responseStatus().error;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                status.acksPending_$eq(true);
                status.responseStatus().error = Errors.REQUEST_TIMED_OUT;
            } else {
                status.acksPending_$eq(false);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Initial partition status for %s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, status})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedDeleteRecords $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            DeleteRecordsPartitionStatus status = (DeleteRecordsPartitionStatus)tuple2._2();
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Checking delete records satisfaction for ").append(topicPartition).append(", current status ").append(status).toString());
            if (status.acksPending()) {
                Tuple3 tuple3;
                Option<Partition> option = $this.replicaManager.getPartition(topicPartition);
                if (option instanceof Some) {
                    Tuple3 tuple32;
                    Some some = (Some)option;
                    Partition partition = (Partition)some.value();
                    if (partition == ReplicaManager$.MODULE$.OfflinePartition()) {
                        tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.KAFKA_STORAGE_ERROR, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else {
                        Tuple3 tuple33;
                        Option<Replica> option2 = partition.leaderReplicaIfLocal();
                        if (option2 instanceof Some) {
                            long leaderLW = partition.lowWatermarkIfLeader();
                            tuple33 = new Tuple3((Object)BoxesRunTime.boxToBoolean((leaderLW >= status.requiredOffset() ? 1 : 0) != 0), (Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)leaderLW));
                        } else if (None$.MODULE$.equals(option2)) {
                            tuple33 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)BoxesRunTime.boxToLong((long)-1L));
                        } else {
                            throw new MatchError(option2);
                        }
                        tuple32 = tuple33;
                    }
                    tuple3 = tuple32;
                } else if (None$.MODULE$.equals(option)) {
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    throw new MatchError(option);
                }
                Tuple3 tuple34 = tuple3;
                if (tuple34 == null) {
                    throw new MatchError((Object)tuple34);
                }
                boolean lowWatermarkReached = BoxesRunTime.unboxToBoolean((Object)tuple34._1());
                Errors error = (Errors)((Object)tuple34._2());
                long lw = BoxesRunTime.unboxToLong((Object)tuple34._3());
                Tuple3 tuple35 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)lowWatermarkReached), (Object)error, (Object)BoxesRunTime.boxToLong((long)lw));
                Tuple3 tuple36 = tuple35;
                boolean lowWatermarkReached2 = BoxesRunTime.unboxToBoolean((Object)tuple36._1());
                Errors error2 = (Errors)((Object)tuple36._2());
                long lw2 = BoxesRunTime.unboxToLong((Object)tuple36._3());
                Errors errors = error2;
                Errors errors2 = Errors.NONE;
                if ((errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null) || lowWatermarkReached2) {
                    status.acksPending_$eq(false);
                    status.responseStatus().error = error2;
                    status.responseStatus().lowWatermark = lw2;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            DeleteRecordsPartitionStatus status = (DeleteRecordsPartitionStatus)tuple2._2();
            if (status.acksPending()) {
                DelayedDeleteRecordsMetrics$.MODULE$.recordExpiration(topicPartition);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public DelayedDeleteRecords(long delayMs, Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus, ReplicaManager replicaManager, Function1<Map<TopicPartition, DeleteRecordsResponse.PartitionResponse>, BoxedUnit> responseCallback) {
        this.deleteRecordsStatus = deleteRecordsStatus;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
        deleteRecordsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DelayedDeleteRecords.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }
}

