/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u000e\u001d\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\ni\u0001\u0011\t\u0011)A\u0005kmB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d)\u0006A1A\u0005\nYCaa\u0017\u0001!\u0002\u00139\u0006b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00020\t\u000f\u001d\u0004!\u0019!C\u0005;\"1\u0001\u000e\u0001Q\u0001\nyCQ!\u001b\u0001\u0005R)DQa\u001f\u0001\u0005RqDq!a\u0001\u0001\t#\n)\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011Q\u0013\u0001\u0005R\u0005]\u0005bBAP\u0001\u0011E\u0013\u0011\u0015\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\t)\f\u0001C!\u0003oCq!!5\u0001\t#\n\u0019\u000eC\u0004\u0002\\\u0002!\t%!8\t\u000f\u0005E\b\u0001\"\u0015\u0002t\"9\u00111 \u0001\u0005\u0002\u0005u(!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012T!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003qI!!\n\u000f\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\tA\u0013G\u0004\u0002*_A\u0011!&L\u0007\u0002W)\u0011A\u0006I\u0001\u0007yI|w\u000e\u001e \u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a5\nAb]8ve\u000e,'I]8lKJ\u0004\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0010\u0002\u000f\rdWo\u001d;fe&\u0011!h\u000e\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0013\t!D%\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002$}%\u0011q\b\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006sKBd\u0017nY1NOJ\u0004\"a\t\"\n\u0005\rc\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0006cV|G/\u0019\t\u0003G\u0019K!a\u0012\u000f\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\t\u0019#*\u0003\u0002L9\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f9{\u0005+\u0015*T)B\u00111\u0005\u0001\u0005\u0006M\u001d\u0001\ra\n\u0005\u0006i\u001d\u0001\r!\u000e\u0005\u0006y\u001d\u0001\r!\u0010\u0005\u0006\u0001\u001e\u0001\r!\u0011\u0005\u0006\t\u001e\u0001\r!\u0012\u0005\u0006\u0011\u001e\u0001\r!S\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\u0012a\u0016\t\u00031fk\u0011!L\u0005\u000356\u00121!\u00138u\u0003)\u0011X\r\u001d7jG\u0006LE\rI\u0001\t[\u0006D()\u001f;fgV\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006!A.\u00198h\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a1\u0003\u000f%sG/Z4fe\u0006IQ.\u0019=CsR,7\u000fI\u0001\nM\u0016$8\r[*ju\u0016\f!BZ3uG\"\u001c\u0016N_3!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\u0005-t\u0007c\u0001-m/&\u0011Q.\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b=t\u0001\u0019\u00019\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011/_\u0007\u0002e*\u00111\u000f^\u0001\u0007G>lWn\u001c8\u000b\u0005})(B\u0001<x\u0003\u0019\t\u0007/Y2iK*\t\u00010A\u0002pe\u001eL!A\u001f:\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006aAn\\4F]\u0012|eMZ:fiR\u0019Q0!\u0001\u0011\u0005as\u0018BA@.\u0005\u0011auN\\4\t\u000b=|\u0001\u0019\u00019\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0002\b\u0005=\u0011\u0011\u0003\t\u000512\fI\u0001E\u0002$\u0003\u0017I1!!\u0004\u001d\u00059yeMZ:fi\u0006sG-\u00129pG\"DQa\u001c\tA\u0002ADa!a\u0005\u0011\u0001\u00049\u0016!B3q_\u000eD\u0017a\u00044fi\u000eDgI]8n\u0019\u0016\fG-\u001a:\u0015\t\u0005e\u00111\u0007\t\u0007\u00037\t\t#!\n\u000e\u0005\u0005u!bAA\u0010[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\u0004'\u0016\f\bC\u0002-\u0002(A\fY#C\u0002\u0002*5\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0017\u0003_i\u0011\u0001A\u0005\u0004\u0003c!#!\u0003$fi\u000eDG)\u0019;b\u0011\u001d\t)$\u0005a\u0001\u0003o\tABZ3uG\"\u0014V-];fgR\u0004B!!\u000f\u0002F9!\u00111HA!\u001b\t\tiDC\u0002\u0002@I\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u0007\ni$\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002H\u0005%#a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u0007\ni$\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003\u001f\ni&a\u0018\u0002dA!\u0001\f\\A)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,=\u0005\u0019An\\4\n\t\u0005m\u0013Q\u000b\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000b=\u0014\u0002\u0019\u00019\t\r\u0005\u0005$\u00031\u0001~\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005\u0015$\u00031\u0001\u0002h\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004b!!\u001b\u0002\u0004\u0006%e\u0002BA6\u0003\u007frA!!\u001c\u0002~9!\u0011qNA>\u001d\u0011\t\t(!\u001f\u000f\t\u0005M\u0014q\u000f\b\u0004U\u0005U\u0014\"\u0001=\n\u0005Y<\u0018BA\u0010v\u0013\t\u0019H/C\u0002\u0002@ILA!!!\u0002>\u0005ia)\u001a;dQJ+7\u000f]8og\u0016LA!!\"\u0002\b\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006TA!!!\u0002>A!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010J\faA]3d_J$\u0017\u0002BAJ\u0003\u001b\u0013qAU3d_J$7/A\u000fgKR\u001c\u0007.R1sY&,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0015i\u0018\u0011TAN\u0011\u0015y7\u00031\u0001q\u0011\u0019\tij\u0005a\u0001/\u0006YA.Z1eKJ,\u0005o\\2i\u0003m1W\r^2i\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR)Q0a)\u0002&\")q\u000e\u0006a\u0001a\"1\u0011Q\u0014\u000bA\u0002]\u000b\u0001e\u001c4gg\u0016$8K\\1qg\"|GO\u0012:p[\u000e+(O]3oiJ+\u0007\u000f\\5dCR1\u00111VAY\u0003g\u0003B!a\u0015\u0002.&!\u0011qVA+\u0005EaunZ(gMN,Go\u00158baNDw\u000e\u001e\u0005\u0006_V\u0001\r\u0001\u001d\u0005\u0007\u0003;+\u0002\u0019A,\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\tI,!2\u0011\u000f\u0005m\u00111\u00189\u0002@&!\u0011QXA\u000f\u0005\ri\u0015\r\u001d\t\u0005\u0003w\t\t-\u0003\u0003\u0002D\u0006u\"AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003\u000f4\u0002\u0019AAe\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\b\u00037\tY\f]Af!\u0011\ti#!4\n\u0007\u0005=GEA\u0005Fa>\u001c\u0007\u000eR1uC\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\u0005U\u0007c\u0001-\u0002X&\u0019\u0011\u0011\\\u0017\u0003\u000f\t{w\u000e\\3b]\u0006AAO];oG\u0006$X\r\u0006\u0004\u0002`\u0006\u0015\u0018q\u001d\t\u00041\u0006\u0005\u0018bAAr[\t!QK\\5u\u0011\u0015y\u0007\u00041\u0001q\u0011\u001d\tI\u000f\u0007a\u0001\u0003W\fq\u0002\u001e:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004G\u00055\u0018bAAx9\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0019\ty.!>\u0002x\")q.\u0007a\u0001a\"1\u0011\u0011`\rA\u0002u\faa\u001c4gg\u0016$\u0018A\u00032vS2$g)\u001a;dQR!\u0011q B\f!\u0019\u0011\tAa\u0004\u0003\u00169!!1\u0001B\u0006\u001d\u0011\u0011)A!\u0003\u000f\u0007)\u00129!C\u0001 \u0013\tib$C\u0002\u0003\u000eq\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0003\u0012\tM!\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0003\u000eq\u0001B\u0001\u00177\u00028!9!\u0011\u0004\u000eA\u0002\tm\u0011\u0001\u00049beRLG/[8o\u001b\u0006\u0004\bcBA\u000e\u0003w\u0003(Q\u0004\t\u0004G\t}\u0011b\u0001B\u00119\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0002")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return (Seq)partitionData.elem;
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica futureReplica = this.replicaMgr.futureLocalReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureReplica.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, true);
        long futureReplicaHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(futureReplica.logEndOffset()), partitionData.highWatermark);
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(futureReplicaHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logEndOffset().messageOffset();
    }

    private LogOffsetSnapshot offsetSnapshotFromCurrentReplica(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple22._2();
                try {
                    EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch == -1) {
                        epochEndOffset = new EpochEndOffset(-1, -1L);
                    } else {
                        Partition partition = $this.replicaMgr.getPartitionOrException(tp, false);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    }
                    EpochEndOffset endOffset = epochEndOffset;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException(t), -1, -1L));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return true;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateFullyAndStartAt(offset, true);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object;
        Option maxPartitionOpt = ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$buildFetch$1(this, x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$greater((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() < ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (maxPartitionOpt.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)maxPartitionOpt.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)partitionFetchState);
            Tuple2 tuple23 = tuple22;
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            PartitionFetchState partitionFetchState2 = (PartitionFetchState)tuple23._2();
            try {
                long logStartOffset = this.replicaMgr.futureLocalReplicaOrException(topicPartition2).logStartOffset();
                object = requestMap.put(topicPartition2, new FetchRequest.PartitionData(partitionFetchState2.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(partitionFetchState2.currentLeaderEpoch()))));
            }
            catch (KafkaStorageException kafkaStorageException) {
                object = partitionsWithError.$plus$eq((Object)topicPartition2);
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        None$ fetchRequestOpt = requestMap.isEmpty() ? None$.MODULE$ : new Some((Object)FetchRequest.Builder.forReplica(ApiKeys.FETCH.latestVersion(), this.replicaId(), 0, 0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())));
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), new FetchResponse.PartitionData<Records>(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, data.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$buildFetch$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch() && !$this.quota.isQuotaExceeded();
        return bl;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

