/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001\u0002\n\u0014\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011I\u0003!\u0011!Q\u0001\nMCQA\u0016\u0001\u0005\u0002]Cq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004g\u0001\u0001\u0006IA\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019I\u0007\u0001)A\u0005\u0007\"9!\u000e\u0001b\u0001\n\u0013Y\u0007B\u0002:\u0001A\u0003%A\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005}\u0002\u0001\"\u0001\u00028\tQ\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(\t\\8dW&twmU3oI*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001aE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005\u0019\u0012B\u0001\u0012\u0014\u00051\u0011En\\2lS:<7+\u001a8e\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\t)\u0003&D\u0001'\u0015\t9S#A\u0004dYV\u001cH/\u001a:\n\u0005%2#A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003A1J!!L\n\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\t\u0001\u0014(D\u00012\u0015\tq#G\u0003\u00024i\u000511m\\7n_:T!AF\u001b\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uE\u0012q!T3ue&\u001c7/\u0001\u0003uS6,\u0007CA\u001fA\u001b\u0005q$BA 3\u0003\u0015)H/\u001b7t\u0013\t\teH\u0001\u0003US6,\u0017!\u00034fi\u000eDWM]%e!\tQB)\u0003\u0002F7\t\u0019\u0011J\u001c;\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004\"\u0001S(\u000f\u0005%k\u0005C\u0001&\u001c\u001b\u0005Y%B\u0001'\u0018\u0003\u0019a$o\\8u}%\u0011ajG\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002O7\u0005QAn\\4D_:$X\r\u001f;\u0011\u0005u\"\u0016BA+?\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011aK&l\u0017/^=~\u0003\"\u0001\t\u0001\t\u000b\rB\u0001\u0019\u0001\u0013\t\u000b)B\u0001\u0019A\u0016\t\u000b9B\u0001\u0019A\u0018\t\u000bmB\u0001\u0019\u0001\u001f\t\u000b\tC\u0001\u0019A\"\t\u000b\u0019C\u0001\u0019A$\t\u000bIC\u0001\u0019A*\u0002\u0015M|WO]2f\u001d>$W-F\u0001c!\t\u0019G-D\u00013\u0013\t)'G\u0001\u0003O_\u0012,\u0017aC:pkJ\u001cWMT8eK\u0002\nQb]8dW\u0016$H+[7f_V$X#A\"\u0002\u001dM|7m[3u)&lWm\\;uA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_R\nqa\u00197jK:$8/\u0003\u0002r]\nia*\u001a;x_J\\7\t\\5f]R\faB\\3uo>\u00148n\u00117jK:$\b%A\u0006tK:$'+Z9vKN$HCA;y!\tig/\u0003\u0002x]\nq1\t\\5f]R\u0014Vm\u001d9p]N,\u0007\"B=\u0010\u0001\u0004Q\u0018A\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\u0019\u0004w\u0006\u0005\u0002#\u0002?\u0002\u0018\u0005uabA?\u0002\u00129\u0019a0!\u0004\u000f\u0007}\fYA\u0004\u0003\u0002\u0002\u0005%a\u0002BA\u0002\u0003\u000fq1ASA\u0003\u0013\u0005A\u0014B\u0001\u001c8\u0013\t1R'\u0003\u00024i%\u0019\u0011q\u0002\u001a\u0002\u0011I,\u0017/^3tiNLA!a\u0005\u0002\u0016\u0005y\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cHOC\u0002\u0002\u0010IJA!!\u0007\u0002\u001c\t9!)^5mI\u0016\u0014(\u0002BA\n\u0003+\u0001B!a\b\u0002\"1\u0001AaCA\u0012q\u0006\u0005\t\u0011!B\u0001\u0003K\u00111a\u0018\u00133#\u0011\t9#!\f\u0011\u0007i\tI#C\u0002\u0002,m\u0011qAT8uQ&tw\r\u0005\u0003\u00020\u0005ERBAA\u000b\u0013\u0011\t\u0019$!\u0006\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\fQ\"\u001b8ji&\fG/Z\"m_N,GCAA\u001d!\rQ\u00121H\u0005\u0004\u0003{Y\"\u0001B+oSR\fQa\u00197pg\u0016\u0004")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final Time time;
    private final Node sourceNode;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady(this.networkClient(), this.sourceNode(), this.time, this.socketTimeout())) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout()).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive(this.networkClient(), clientRequest, this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString());
            throw e;
        }
        return clientResponse;
    }

    @Override
    public void initiateClose() {
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext) {
        this.sourceBroker = sourceBroker;
        this.time = time;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(brokerConfig.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, brokerConfig, brokerConfig.interBrokerListenerName(), brokerConfig.saslMechanismInterBrokerProtocol(), time, brokerConfig.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceBroker.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder, logContext);
        this.networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), ClientDnsLookup.DEFAULT, time, false, new ApiVersions(), logContext);
    }
}

