/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001B\u001d;\u0001}B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Iq\u000b\u0001B\u0001B\u0003%\u0001L\u0018\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!!\bA!A!\u0002\u0013)\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0013}\u0004!\u0011!Q\u0001\n\u0005\u0005\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OAq!!\u000b\u0001A\u0003%1\u000bC\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!A\u00111\b\u0001!\u0002\u0013\t9\u0001\u0003\u0006\u0002>\u0001\u0011\r\u0011\"\u0001;\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\u000b\u0003\u0013\u0002!\u0019!C\u0001u\u0005}\u0002\u0002CA&\u0001\u0001\u0006I!!\u0011\t\u0015\u00055\u0003A1A\u0005\u0002i\ny\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA!\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA+\u0011%\t9\u0007\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA+\u0011%\tY\u0007\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA+\u0011%\ty\u0007\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA+\u0011%\t\u0019\b\u0001b\u0001\n\u0013\t)\b\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA<\u0011%\ty\b\u0001b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAB\u0011\u001d\t\t\n\u0001C)\u0003'Cq!a)\u0001\t#\n)\u000bC\u0004\u00020\u0002!\t&!-\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\u0011I\u0001\u0001C)\u0005\u0017AqA!\u0010\u0001\t#\u0012y\u0004C\u0004\u0003H\u0001!\tF!\u0013\t\u000f\t=\u0003\u0001\"\u0003\u0003R!9!1\f\u0001\u0005B\tu\u0003b\u0002BG\u0001\u0011\u0005#q\u0012\u0005\b\u0005?\u0003A\u0011\u000bBQ\u0011\u001d\u0011I\u000b\u0001C!\u0005WCqA!1\u0001\t\u0003\n)\bC\u0004\u0003D\u0002!IA!2\t\u001b\t-\u0007\u0001%A\u0002\u0002\u0003%IA!4_\u000f%\u0011yMOA\u0001\u0012\u0003\u0011\tN\u0002\u0005:u\u0005\u0005\t\u0012\u0001Bj\u0011\u001d\tiA\u000eC\u0001\u00057D\u0011B!87#\u0003%\tAa8\u0003)I+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0015\tYD(\u0001\u0004tKJ4XM\u001d\u0006\u0002{\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001A!\t\t%)D\u0001;\u0013\t\u0019%HA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\t9\fW.\u001a\t\u0003\r>s!aR'\u0011\u0005![U\"A%\u000b\u0005)s\u0014A\u0002\u001fs_>$hHC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5*\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(L\u0003%1W\r^2iKJLE\r\u0005\u0002U+6\t1*\u0003\u0002W\u0017\n\u0019\u0011J\u001c;\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005ecV\"\u0001.\u000b\u0005mc\u0014aB2mkN$XM]\u0005\u0003;j\u0013aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0003\u0002X\u0005\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0011\u0011)Y\u0005\u0003Ej\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005\u0005+\u0017B\u00014;\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fq!\\3ue&\u001c7\u000f\u0005\u0002je6\t!N\u0003\u0002hW*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005ur'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a\u001d6\u0003\u000f5+GO]5dg\u0006!A/[7f!\t1\u00180D\u0001x\u0015\tA8.A\u0003vi&d7/\u0003\u0002{o\n!A+[7f\u0003\u0015\tXo\u001c;b!\t\tU0\u0003\u0002\u007fu\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006QB.Z1eKJ,e\u000e\u001a9pS:$(\t\\8dW&twmU3oIB)A+a\u0001\u0002\b%\u0019\u0011QA&\u0003\r=\u0003H/[8o!\r\t\u0015\u0011B\u0005\u0004\u0003\u0017Q$\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0017A\u0002\u001fj]&$h\b\u0006\u000b\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\t\u0003\u0003\u0002AQ\u0001\u0012\u0006A\u0002\u0015CQA\u0015\u0006A\u0002MCQa\u0016\u0006A\u0002aCQa\u0018\u0006A\u0002\u0001DQa\u0019\u0006A\u0002\u0011DQa\u001a\u0006A\u0002!DQ\u0001\u001e\u0006A\u0002UDQa\u001f\u0006A\u0002qD\u0001b \u0006\u0011\u0002\u0003\u0007\u0011\u0011A\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\u0012aU\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0013A\u00037pO\u000e{g\u000e^3yiV\u0011\u0011q\u0006\t\u0004m\u0006E\u0012bAA\u001ao\nQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\u000fY\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u+\t\t9!A\bmK\u0006$WM]#oIB|\u0017N\u001c;!\u0003M1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8o+\t\t\t\u0005E\u0002U\u0003\u0007J1!!\u0012L\u0005\u0015\u0019\u0006n\u001c:u\u0003Q1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8oA\u0005\u0011sN\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014V-];fgR4VM]:j_:\f1e\u001c4gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$h+\u001a:tS>t\u0007%\u0001\rmSN$xJ\u001a4tKR\u0014V-];fgR4VM]:j_:\f\u0011\u0004\\5ti>3gm]3u%\u0016\fX/Z:u-\u0016\u00148/[8oA\u00059Q.\u0019=XC&$XCAA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\nA\u0001\\1oO*\u0011\u0011qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0005e#aB%oi\u0016<WM]\u0001\t[\u0006Dx+Y5uA\u0005AQ.\u001b8CsR,7/A\u0005nS:\u0014\u0015\u0010^3tA\u0005AQ.\u0019=CsR,7/A\u0005nCb\u0014\u0015\u0010^3tA\u0005Ia-\u001a;dQNK'0Z\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0013\u0001\t2s_.,'oU;qa>\u0014Ho\u001d'fC\u0012,'/\u00129pG\"\u0014V-];fgR,\"!a\u001e\u0011\u0007Q\u000bI(C\u0002\u0002|-\u0013qAQ8pY\u0016\fg.A\u0011ce>\\WM]*vaB|'\u000f^:MK\u0006$WM]#q_\u000eD'+Z9vKN$\b%A\ngKR\u001c\u0007nU3tg&|g\u000eS1oI2,'/\u0006\u0002\u0002\u0004B!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n6\fqa\u00197jK:$8/\u0003\u0003\u0002\u000e\u0006\u001d%a\u0005$fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\u0018\u0001\u00064fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\b%A\u0006mCR,7\u000f^#q_\u000eDG\u0003BAK\u0003/\u0003B\u0001VA\u0002'\"9\u0011\u0011T\u0012A\u0002\u0005m\u0015A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003;\u000by*D\u0001l\u0013\r\t\tk\u001b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00031awnZ#oI>3gm]3u)\u0011\t9+!,\u0011\u0007Q\u000bI+C\u0002\u0002,.\u0013A\u0001T8oO\"9\u0011\u0011\u0014\u0013A\u0002\u0005m\u0015!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u00111WA^\u0003{\u0003R\u0001VA\u0002\u0003k\u00032!QA\\\u0013\r\tIL\u000f\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u001d\tI*\na\u0001\u00037Ca!a0&\u0001\u0004\u0019\u0016!B3q_\u000eD\u0017\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\t9(A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u000b\u0003\u0003\u0013\u00042\u0001VAf\u0013\r\tim\u0013\u0002\u0005+:LG/\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003'\f\t/a9\u0002hB)A+a\u0001\u0002VB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\r\n1\u0001\\8h\u0013\u0011\ty.!7\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\tI\n\u000ba\u0001\u00037Cq!!:)\u0001\u0004\t9+A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBAuQ\u0001\u0007\u00111^\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\u00055\u0018q^\u0007\u0002\u0001%\u0019\u0011\u0011\u001f\"\u0003\u0013\u0019+Go\u00195ECR\f\u0017aG7bs\n,w+\u0019:o\u0013\u001a|e/\u001a:tSj,GMU3d_J$7\u000f\u0006\u0004\u0002J\u0006](q\u0001\u0005\b\u0003sL\u0003\u0019AA~\u0003\u001d\u0011XmY8sIN\u0004B!!@\u0003\u00045\u0011\u0011q \u0006\u0004\u0005\u0003Y\u0017A\u0002:fG>\u0014H-\u0003\u0003\u0003\u0006\u0005}(!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002\u001a&\u0002\r!a'\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$BA!\u0004\u0003&A1!q\u0002B\r\u0005?qAA!\u0005\u0003\u00169\u0019\u0001Ja\u0005\n\u00031K1Aa\u0006L\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0007\u0003\u001e\t\u00191+Z9\u000b\u0007\t]1\nE\u0004U\u0005C\tY*a;\n\u0007\t\r2J\u0001\u0004UkBdWM\r\u0005\b\u0005OQ\u0003\u0019\u0001B\u0015\u000311W\r^2i%\u0016\fX/Z:u!\u0011\u0011YCa\u000e\u000f\t\t5\"1G\u0007\u0003\u0005_Q1A!\rl\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B\u001b\u0005_\tABR3uG\"\u0014V-];fgRLAA!\u000f\u0003<\t9!)^5mI\u0016\u0014(\u0002\u0002B\u001b\u0005_\tQDZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003O\u0013\tEa\u0011\t\u000f\u0005e5\u00061\u0001\u0002\u001c\"1!QI\u0016A\u0002M\u000b!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\u0006Yb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$b!a*\u0003L\t5\u0003bBAMY\u0001\u0007\u00111\u0014\u0005\u0007\u0005\u000bb\u0003\u0019A*\u0002+\u0019,Go\u00195PM\u001a\u001cX\r\u001e$s_6dU-\u00193feRA\u0011q\u0015B*\u0005+\u00129\u0006C\u0004\u0002\u001a6\u0002\r!a'\t\r\t\u0015S\u00061\u0001T\u0011\u001d\u0011I&\fa\u0001\u0003O\u000b\u0001#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0003`\t]\u0004C\u0002B1\u0005_\u0012)H\u0004\u0003\u0003d\t-d\u0002\u0002B3\u0005Sr1\u0001\u0013B4\u0013\u0005i\u0014BA\u001e=\u0013\r\u0011iGO\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0011\tHa\u001d\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0011iG\u000f\t\u0006)\u0006\r!\u0011\u0006\u0005\b\u0005sr\u0003\u0019\u0001B>\u00031\u0001\u0018M\u001d;ji&|g.T1q!!\u0011iHa!\u0002\u001c\n\u001dUB\u0001B@\u0015\r\u0011\tiS\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BC\u0005\u007f\u00121!T1q!\r\t%\u0011R\u0005\u0004\u0005\u0017S$a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0017\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005%'\u0011\u0013BK\u0011\u001d\u0011\u0019j\fa\u0001\u00037\u000b!\u0001\u001e9\t\u000f\t]u\u00061\u0001\u0003\u001a\u0006)rN\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0007cA!\u0003\u001c&\u0019!Q\u0014\u001e\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003\u0013\u0014\u0019K!*\t\u000f\u0005e\u0005\u00071\u0001\u0002\u001c\"9!q\u0015\u0019A\u0002\u0005\u001d\u0016AB8gMN,G/\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0005[\u0013)\f\u0005\u0005\u0003~\t\r\u00151\u0014BX!\u0011\u0011iC!-\n\t\tM&q\u0006\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011\u001d\u00119,\ra\u0001\u0005s\u000b!\u0002]1si&$\u0018n\u001c8t!!\u0011iHa!\u0002\u001c\nm\u0006\u0003BAw\u0005{K1Aa0C\u0005%)\u0005o\\2i\t\u0006$\u0018-A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\fac\u001d5pk2$gi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u000b\u0007\u0003o\u00129M!3\t\u000bm\u001c\u0004\u0019\u0001?\t\u000f\u0005e5\u00071\u0001\u0002\u001c\u0006\u00112/\u001e9fe\u0012\u001ax.\u001e:dK\n\u0013xn[3s+\u0005A\u0016\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002BmM\u0019aG!6\u0011\u0007Q\u00139.C\u0002\u0003Z.\u0013a!\u00118z%\u00164GC\u0001Bi\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!\u0011\u001d\u0016\u0005\u0003\u0003\u0011\u0019o\u000b\u0002\u0003fB!!q\u001dBy\u001b\t\u0011IO\u0003\u0003\u0003l\n5\u0018!C;oG\",7m[3e\u0015\r\u0011yoS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bz\u0005S\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localReplicaOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localReplicaOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localReplicaOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block2: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown) break block2;
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica replica = this.replicaMgr.localReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData$1.highWatermark)})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset()), partitionData.highWatermark);
        long leaderLogStartOffset = partitionData.logStartOffset;
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        this.replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        block0: {
            if (this.fetchRequestVersion() > 2 || records.sizeInBytes() <= 0 || records.validBytes() > 0) break block0;
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        Object object;
        try {
            ClientResponse clientResponse = this.leaderEndpoint().sendRequest(fetchRequest);
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            object = !this.fetchSessionHandler().handleResponse(fetchResponse) ? Nil$.MODULE$ : ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchResponse.responseData()).asScala()).toSeq();
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return object;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)requestPartitionData)}));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica(this.listOffsetRequestVersion(), this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest(requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData responsePartitionData = response.responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (!((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long(responsePartitionData.offsets.get(0));
        return l;
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, topicPartition)) {
                    try {
                        long logStartOffset = $this.replicaMgr.localReplicaOrException(topicPartition).logStartOffset();
                        builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica(this.fetchRequestVersion(), this.replicaId(), Predef$.MODULE$.Integer2int(this.maxWait()), Predef$.MODULE$.Integer2int(this.minBytes()), fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)requestBuilder);
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        block1: {
            Replica replica = this.replicaMgr.localReplicaOrException(tp);
            Partition partition = (Partition)this.replicaMgr.getPartition(tp).get();
            partition.truncateTo(offsetTruncationState.offset(), false);
            if (offsetTruncationState.offset() < replica.highWatermark().messageOffset()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(String.valueOf(BoxesRunTime.boxToLong((long)replica.highWatermark().messageOffset()))).toString());
            }
            if (!offsetTruncationState.truncationCompleted()) break block1;
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        partition.truncateFullyAndStartAt(offset, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        Map map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(this.offsetForLeaderEpochRequestVersion(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest(epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException(t);
            map = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(error, -1, -1L));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition);
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(39).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").append(new StringBuilder(12).append("fetcherId=").append(fetcherId).append("] ").toString()).toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append(this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), this.logContext()));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

