/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ConsumerPerformance;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ConsumerPerformance$
implements LazyLogging {
    public static ConsumerPerformance$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger$lzycompute() {
        ConsumerPerformance$ consumerPerformance$ = this;
        synchronized (consumerPerformance$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void main(String[] args) {
        block5: {
            BoxedUnit boxedUnit;
            ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Starting consumer...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            AtomicLong totalMessagesRead = new AtomicLong(0L);
            AtomicLong totalBytesRead = new AtomicLong(0L);
            Map metrics = null;
            AtomicLong joinGroupTimeInMs = new AtomicLong(0L);
            if (!config.hideHeader()) {
                this.printHeader(config.showDetailedStats());
            }
            long startMs = 0L;
            long endMs = 0L;
            KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config.props());
            startMs = System.currentTimeMillis();
            this.consume(consumer, (List<String>)new .colon.colon((Object)config.topic(), (List)Nil$.MODULE$), config.numMessages(), config.recordFetchTimeoutMs(), config, totalMessagesRead, totalBytesRead, joinGroupTimeInMs, startMs);
            endMs = System.currentTimeMillis();
            if (config.printMetrics()) {
                metrics = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.metrics()).asScala();
            }
            consumer.close();
            double elapsedSecs = (double)(endMs - startMs) / 1000.0;
            long fetchTimeInMs = endMs - startMs - joinGroupTimeInMs.get();
            if (!config.showDetailedStats()) {
                double totalMBRead = (double)totalBytesRead.get() * 1.0 / (double)0x100000;
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %.4f, %.4f, %d, %.4f, %d, %d, %.4f, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesRead.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead.get() / elapsedSecs)), BoxesRunTime.boxToLong((long)joinGroupTimeInMs.get()), BoxesRunTime.boxToLong((long)fetchTimeInMs), BoxesRunTime.boxToDouble((double)(totalMBRead / ((double)fetchTimeInMs / 1000.0))), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead.get() / ((double)fetchTimeInMs / 1000.0)))})));
            }
            if (metrics == null) break block5;
            ToolsUtils$.MODULE$.printMetrics((Map<MetricName, ? extends Metric>)metrics);
        }
    }

    public void printHeader(boolean showDetailedStats) {
        String newFieldsInHeader = ", rebalance.time.ms, fetch.time.ms, fetch.MB.sec, fetch.nMsg.sec";
        if (!showDetailedStats) {
            Predef$.MODULE$.println((Object)new StringBuilder(82).append("start.time, end.time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append(newFieldsInHeader).toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(76).append("time, threadId, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append(newFieldsInHeader).toString());
        }
    }

    public void consume(KafkaConsumer<byte[], byte[]> consumer, List<String> topics, long count, long timeout, ConsumerPerformance.ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicLong joinTime, long testStartTime) {
        LongRef bytesRead = LongRef.create((long)0L);
        LongRef messagesRead = LongRef.create((long)0L);
        LongRef lastBytesRead = LongRef.create((long)0L);
        LongRef lastMessagesRead = LongRef.create((long)0L);
        LongRef joinStart = LongRef.create((long)0L);
        LongRef joinTimeMsInSingleRound = LongRef.create((long)0L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), new ConsumerRebalanceListener(joinTime, joinStart, joinTimeMsInSingleRound){
            private final AtomicLong joinTime$1;
            private final LongRef joinStart$1;
            private final LongRef joinTimeMsInSingleRound$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.joinTime$1.addAndGet(System.currentTimeMillis() - this.joinStart$1.elem);
                this.joinTimeMsInSingleRound$1.elem += System.currentTimeMillis() - this.joinStart$1.elem;
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                this.joinStart$1.elem = System.currentTimeMillis();
            }
            {
                this.joinTime$1 = joinTime$1;
                this.joinStart$1 = joinStart$1;
                this.joinTimeMsInSingleRound$1 = joinTimeMsInSingleRound$1;
            }
        });
        LongRef currentTimeMillis = LongRef.create((long)System.currentTimeMillis());
        LongRef lastReportTime = LongRef.create((long)currentTimeMillis.elem);
        long lastConsumedTime = currentTimeMillis.elem;
        while (messagesRead.elem < count && currentTimeMillis.elem - lastConsumedTime <= timeout) {
            Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(consumer.poll(Duration.ofMillis(100L))).asScala();
            currentTimeMillis.elem = System.currentTimeMillis();
            if (records.nonEmpty()) {
                lastConsumedTime = currentTimeMillis.elem;
            }
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerPerformance$.$anonfun$consume$1(messagesRead, bytesRead, currentTimeMillis, lastReportTime, config, lastBytesRead, lastMessagesRead, joinTimeMsInSingleRound, record);
                return BoxedUnit.UNIT;
            });
        }
        if (messagesRead.elem < count) {
            Predef$.MODULE$.println((Object)new StringBuilder(148).append("WARNING: Exiting before consuming the expected number of messages: timeout (").append(timeout).append(" ms) exceeded. ").append("You can use the --timeout option to increase the timeout.").toString());
        }
        totalMessagesRead.set(messagesRead.elem);
        totalBytesRead.set(bytesRead.elem);
    }

    public void printConsumerProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat, long periodicJoinTimeInMs) {
        this.printBasicProgress(id, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, dateFormat);
        this.printExtendedProgress(bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, periodicJoinTimeInMs);
        Predef$.MODULE$.println();
    }

    private void printBasicProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double elapsedMs = endMs - startMs;
        double totalMbRead = (double)bytesRead * 1.0 / (double)0x100000;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        double intervalMbPerSec = 1000.0 * intervalMbRead / elapsedMs;
        double intervalMessagesPerSec = (double)(messagesRead - lastMessagesRead) / elapsedMs * 1000.0;
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToDouble((double)totalMbRead), BoxesRunTime.boxToDouble((double)intervalMbPerSec), BoxesRunTime.boxToLong((long)messagesRead), BoxesRunTime.boxToDouble((double)intervalMessagesPerSec)})));
    }

    private void printExtendedProgress(long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, long periodicJoinTimeInMs) {
        Tuple2.mcDD.sp sp2;
        long fetchTimeMs = endMs - startMs - periodicJoinTimeInMs;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        long intervalMessagesRead = messagesRead - lastMessagesRead;
        Tuple2.mcDD.sp sp3 = sp2 = fetchTimeMs <= 0L ? new Tuple2.mcDD.sp(0.0, 0.0) : new Tuple2.mcDD.sp(1000.0 * intervalMbRead / (double)fetchTimeMs, 1000.0 * (double)intervalMessagesRead / (double)fetchTimeMs);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double intervalMbPerSec = sp2._1$mcD$sp();
        double intervalMessagesPerSec = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(intervalMbPerSec, intervalMessagesPerSec);
        Tuple2.mcDD.sp sp5 = sp4;
        double intervalMbPerSec2 = sp5._1$mcD$sp();
        double intervalMessagesPerSec2 = sp5._2$mcD$sp();
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString(", %d, %d, %.4f, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)periodicJoinTimeInMs), BoxesRunTime.boxToLong((long)fetchTimeMs), BoxesRunTime.boxToDouble((double)intervalMbPerSec2), BoxesRunTime.boxToDouble((double)intervalMessagesPerSec2)})));
    }

    public static final /* synthetic */ void $anonfun$consume$1(LongRef messagesRead$1, LongRef bytesRead$1, LongRef currentTimeMillis$1, LongRef lastReportTime$1, ConsumerPerformance.ConsumerPerfConfig config$1, LongRef lastBytesRead$1, LongRef lastMessagesRead$1, LongRef joinTimeMsInSingleRound$1, ConsumerRecord record) {
        block3: {
            ++messagesRead$1.elem;
            if (record.key() != null) {
                bytesRead$1.elem += (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])record.key())).size();
            }
            if (record.value() != null) {
                bytesRead$1.elem += (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])record.value())).size();
            }
            if (currentTimeMillis$1.elem - lastReportTime$1.elem < (long)config$1.reportingInterval()) break block3;
            if (config$1.showDetailedStats()) {
                MODULE$.printConsumerProgress(0, bytesRead$1.elem, lastBytesRead$1.elem, messagesRead$1.elem, lastMessagesRead$1.elem, lastReportTime$1.elem, currentTimeMillis$1.elem, config$1.dateFormat(), joinTimeMsInSingleRound$1.elem);
            }
            joinTimeMsInSingleRound$1.elem = 0L;
            lastReportTime$1.elem = currentTimeMillis$1.elem;
            lastMessagesRead$1.elem = messagesRead$1.elem;
            lastBytesRead$1.elem = bytesRead$1.elem;
        }
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
    }
}

