/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class BigDecimalSumAccumulateFunction
extends AbstractAccumulateFunction<SumData> {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public SumData createContext() {
        return new SumData();
    }

    @Override
    public void init(SumData data) {
        data.total = BigDecimal.ZERO;
    }

    @Override
    public void accumulate(SumData data, Object value) {
        if (value != null) {
            data.total = data.total.add((BigDecimal)value);
        }
    }

    @Override
    public void reverse(SumData data, Object value) {
        if (value != null) {
            data.total = data.total.subtract((BigDecimal)value);
        }
    }

    @Override
    public Object getResult(SumData data) {
        return data.total;
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return BigDecimal.class;
    }

    protected static class SumData
    implements Externalizable {
        public BigDecimal total = BigDecimal.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.total);
        }
    }
}

