/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.MvelAccumulator;
import org.drools.core.spi.Tuple;
import org.drools.core.util.MVELSafeHelper;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAccumulator
implements MVELCompileable,
MvelAccumulator,
Externalizable {
    private static final long serialVersionUID = 510L;
    MVELCompilationUnit initUnit;
    MVELCompilationUnit actionUnit;
    MVELCompilationUnit reverseUnit;
    MVELCompilationUnit resultUnit;
    private Serializable init;
    private Serializable action;
    private Serializable reverse;
    private Serializable result;

    public MVELAccumulator() {
    }

    public MVELAccumulator(MVELCompilationUnit initUnit, MVELCompilationUnit actionUnit, MVELCompilationUnit reverseUnit, MVELCompilationUnit resultUnit) {
        this.initUnit = initUnit;
        this.actionUnit = actionUnit;
        this.reverseUnit = reverseUnit;
        this.resultUnit = resultUnit;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initUnit = (MVELCompilationUnit)in.readObject();
        this.actionUnit = (MVELCompilationUnit)in.readObject();
        this.reverseUnit = (MVELCompilationUnit)in.readObject();
        this.resultUnit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.initUnit);
        out.writeObject(this.actionUnit);
        out.writeObject(this.reverseUnit);
        out.writeObject(this.resultUnit);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.compile(runtimeData, null);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.init = this.initUnit.getCompiledExpression(runtimeData);
        this.action = this.actionUnit.getCompiledExpression(runtimeData);
        this.result = this.resultUnit.getCompiledExpression(runtimeData);
        if (this.reverseUnit != null) {
            this.reverse = this.reverseUnit.getCompiledExpression(runtimeData, (Object)(rule != null ? rule.toRuleNameAndPathString() : null));
        }
    }

    @Override
    public Serializable createContext() {
        HashMap<Long, Object[]> shadow = null;
        if (this.reverse != null) {
            shadow = new HashMap<Long, Object[]>();
        }
        return new MVELAccumulatorContext(shadow);
    }

    @Override
    public void init(Object workingMemoryContext, Object context, Tuple tuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        Object[] localVars = new Object[this.initUnit.getOtherIdentifiers().length];
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getInitFactory();
        this.initUnit.updateFactory(null, tuple, localVars, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        InternalKnowledgePackage pkg = workingMemory.getKnowledgeBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
            factory.setNextFactory(data.getFunctionFactory());
        }
        MVELSafeHelper.getEvaluator().executeExpression((Object)this.init, null, factory);
        MVELCompilationUnit.DroolsVarFactory df = (MVELCompilationUnit.DroolsVarFactory)factory.getNextFactory();
        if (localVars.length > 0) {
            for (int i = 0; i < df.getOtherVarsLength(); ++i) {
                localVars[i] = factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).getValue();
            }
        }
        ((MVELAccumulatorContext)context).setVariables(localVars);
    }

    @Override
    public void accumulate(Object workingMemoryContext, Object context, Tuple tuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object[] localVars = ((MVELAccumulatorContext)context).getVariables();
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getActionFactory();
        this.actionUnit.updateFactory(handle, tuple, localVars, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        MVELCompilationUnit.DroolsVarFactory df = (MVELCompilationUnit.DroolsVarFactory)factory.getNextFactory();
        if (this.reverse != null) {
            Object[] shadow = new Object[df.getOtherVarsPos()];
            for (int i = 0; i < df.getOtherVarsPos(); ++i) {
                shadow[i] = factory.getIndexedVariableResolver(i).getValue();
            }
            ((MVELAccumulatorContext)context).getShadow().put(handle.getId(), shadow);
        }
        MVELSafeHelper.getEvaluator().executeExpression((Object)this.action, null, factory);
        if (localVars.length > 0) {
            for (int i = 0; i < df.getOtherVarsLength(); ++i) {
                localVars[i] = factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).getValue();
            }
        }
        ((MVELAccumulatorContext)context).setVariables(localVars);
    }

    @Override
    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        int i;
        Object[] localVars = ((MVELAccumulatorContext)context).getVariables();
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getActionFactory();
        MVELCompilationUnit.DroolsVarFactory df = (MVELCompilationUnit.DroolsVarFactory)factory.getNextFactory();
        Object[] vars = ((MVELAccumulatorContext)context).getShadow().remove(handle.getId());
        for (i = 0; i < df.getOtherVarsPos(); ++i) {
            factory.getIndexedVariableResolver(i).setValue(vars[i]);
        }
        if (localVars.length > 0) {
            for (i = 0; i < df.getOtherVarsLength(); ++i) {
                factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).setValue(localVars[i]);
            }
        }
        MVELSafeHelper.getEvaluator().executeExpression((Object)this.reverse, null, factory);
        if (localVars.length > 0) {
            for (i = 0; i < df.getOtherVarsLength(); ++i) {
                localVars[i] = factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).getValue();
            }
        }
        ((MVELAccumulatorContext)context).setVariables(localVars);
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple tuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        Object[] localVars = ((MVELAccumulatorContext)context).getVariables();
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getResultFactory();
        this.resultUnit.updateFactory(null, tuple, localVars, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        return MVELSafeHelper.getEvaluator().executeExpression((Object)this.result, null, factory);
    }

    @Override
    public boolean supportsReverse() {
        return this.reverse != null;
    }

    @Override
    public Object createWorkingMemoryContext() {
        return new MVELAccumulatorFactoryContext(this.initUnit.createFactory(), this.actionUnit.createFactory(), this.resultUnit.createFactory());
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        HashSet<Declaration> declarationSet = new HashSet<Declaration>();
        if (this.initUnit != null) {
            declarationSet.addAll(Arrays.asList(this.initUnit.getPreviousDeclarations()));
        }
        if (this.actionUnit != null) {
            declarationSet.addAll(Arrays.asList(this.actionUnit.getPreviousDeclarations()));
        }
        if (this.resultUnit != null) {
            declarationSet.addAll(Arrays.asList(this.resultUnit.getPreviousDeclarations()));
        }
        if (this.reverseUnit != null) {
            declarationSet.addAll(Arrays.asList(this.reverseUnit.getPreviousDeclarations()));
        }
        if (!declarationSet.isEmpty()) {
            return declarationSet.toArray(new Declaration[declarationSet.size()]);
        }
        return new Declaration[0];
    }

    private static class MVELAccumulatorContext
    implements Serializable {
        private static final long serialVersionUID = 510L;
        private Object[] variables;
        private Map<Long, Object[]> shadow;

        public MVELAccumulatorContext(Map<Long, Object[]> shadow) {
            this.shadow = shadow;
        }

        public Object[] getVariables() {
            return this.variables;
        }

        public void setVariables(Object[] variables) {
            this.variables = variables;
        }

        public Map<Long, Object[]> getShadow() {
            return this.shadow;
        }

        public void setShadow(Map<Long, Object[]> shadow) {
            this.shadow = shadow;
        }
    }

    private static class MVELAccumulatorFactoryContext {
        VariableResolverFactory initFactory;
        VariableResolverFactory actionFactory;
        VariableResolverFactory resultFactory;

        public MVELAccumulatorFactoryContext(VariableResolverFactory initFactory, VariableResolverFactory actionFactory, VariableResolverFactory resultFactory) {
            this.initFactory = initFactory;
            this.actionFactory = actionFactory;
            this.resultFactory = resultFactory;
        }

        public VariableResolverFactory getInitFactory() {
            return this.initFactory;
        }

        public VariableResolverFactory getActionFactory() {
            return this.actionFactory;
        }

        public VariableResolverFactory getResultFactory() {
            return this.resultFactory;
        }
    }
}

