/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.jtms;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.core.beliefsystem.jtms.JTMSMode;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTMSBeliefSystem<M extends JTMSMode<M>>
implements BeliefSystem<M> {
    protected static final Logger log = LoggerFactory.getLogger(JTMSBeliefSystem.class);
    public static boolean STRICT = false;
    private TruthMaintenanceSystem tms;
    protected InternalWorkingMemoryEntryPoint ep;

    public JTMSBeliefSystem(InternalWorkingMemoryEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public BeliefSet<M> insert(M mode, RuleImpl rule, Activation activation, Object payload, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        if (log.isTraceEnabled()) {
            log.trace("TMSInsert {} {}", payload, (Object)((JTMSMode)mode).getValue());
        }
        JTMSBeliefSet jtmsBeliefSet = (JTMSBeliefSet)beliefSet;
        boolean wasEmpty = jtmsBeliefSet.isEmpty();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean wasDecided = jtmsBeliefSet.isDecided();
        InternalFactHandle fh = jtmsBeliefSet.getFactHandle();
        jtmsBeliefSet.add(mode);
        if (!wasEmpty && wasDecided && fh.isNegated() != beliefSet.isNegated()) {
            this.ep.getObjectStore().removeHandle(fh);
            fh.setNegated(beliefSet.isNegated());
            this.ep.getObjectStore().addHandle(fh, fh.getObject());
        } else {
            fh.setNegated(beliefSet.isNegated());
        }
        if (wasEmpty && jtmsBeliefSet.isDecided()) {
            this.ep.insert(jtmsBeliefSet.getFactHandle(), payload, rule, activation != null ? (TerminalNode)activation.getTuple().getTupleSink() : null, typeConf);
        } else {
            this.processBeliefSet(rule, activation, payload, context, jtmsBeliefSet, wasDecided, wasNegated, fh);
        }
        return beliefSet;
    }

    @Override
    public BeliefSet<M> insert(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        return this.insert((JTMSMode)node.getMode(), node.getJustifier().getRule(), node.getJustifier(), node.getObject(), beliefSet, context, typeConf);
    }

    @Override
    public void read(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        throw new UnsupportedOperationException("This is not serializable yet");
    }

    @Override
    public void delete(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context) {
        this.delete((JTMSMode)node.getMode(), node.getJustifier().getRule(), node.getJustifier(), node.getObject(), beliefSet, context);
    }

    @Override
    public void delete(M mode, RuleImpl rule, Activation activation, Object payload, BeliefSet<M> beliefSet, PropagationContext context) {
        if (log.isTraceEnabled()) {
            log.trace("TMSDelete {} {}", payload, (Object)((JTMSMode)mode).getValue());
        }
        JTMSBeliefSet jtmsBeliefSet = (JTMSBeliefSet)beliefSet;
        boolean wasDecided = jtmsBeliefSet.isDecided();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        InternalFactHandle fh = jtmsBeliefSet.getFactHandle();
        beliefSet.remove(mode);
        if (wasDecided && fh.isNegated() != beliefSet.isNegated()) {
            this.ep.getObjectStore().removeHandle(fh);
            fh.setNegated(beliefSet.isNegated());
            this.ep.getObjectStore().addHandle(fh, fh.getObject());
        } else {
            fh.setNegated(beliefSet.isNegated());
        }
        if (beliefSet.isEmpty() && fh.getEqualityKey().getStatus() == 2) {
            this.ep.delete(fh, fh.getObject(), this.getObjectTypeConf(beliefSet), context.getRuleOrigin(), null, activation != null ? (TerminalNode)activation.getTuple().getTupleSink() : null);
        } else if (!(this.processBeliefSet(rule, activation, payload, context, jtmsBeliefSet, wasDecided, wasNegated, fh) && beliefSet.isEmpty() || fh.getObject() != payload)) {
            String value;
            Object object = null;
            if (jtmsBeliefSet.isNegated()) {
                value = JTMSBeliefSetImpl.MODE.NEGATIVE.getId();
                for (JTMSMode entry = (JTMSMode)jtmsBeliefSet.getLast(); entry != null; entry = (JTMSMode)entry.getPrevious()) {
                    if (!entry.getValue().equals(value)) continue;
                    object = entry.getLogicalDependency().getObject();
                    break;
                }
            } else {
                value = JTMSBeliefSetImpl.MODE.POSITIVE.getId();
                for (JTMSMode entry = (JTMSMode)jtmsBeliefSet.getFirst(); entry != null; entry = (JTMSMode)entry.getNext()) {
                    if (entry.getValue() != null && !entry.getValue().equals(value)) continue;
                    object = entry.getLogicalDependency().getObject();
                    break;
                }
            }
            if (fh.getObject() != object) {
                fh.getEntryPoint().getObjectStore().updateHandle(fh, object);
                fh.getEntryPoint().update((FactHandle)fh, fh.getObject(), PropertySpecificUtil.allSetButTraitBitMask(), object.getClass(), null);
            }
        }
        if (beliefSet.isEmpty()) {
            EqualityKey key = fh.getEqualityKey();
            key.setLogicalFactHandle(null);
            key.setBeliefSet(null);
            if (key.getStatus() == 2) {
                this.tms.remove(key);
            }
        }
    }

    private boolean processBeliefSet(RuleImpl rule, Activation activation, Object payload, PropagationContext pctx, JTMSBeliefSet<M> jtmsBeliefSet, boolean wasDecided, boolean wasNegated, InternalFactHandle fh) {
        if (!wasDecided && jtmsBeliefSet.isDecided()) {
            this.ep.insert(jtmsBeliefSet.getFactHandle(), payload, rule, activation != null ? (TerminalNode)activation.getTuple().getTupleSink() : null, this.getObjectTypeConf(jtmsBeliefSet));
            return true;
        }
        if (wasDecided && !jtmsBeliefSet.isDecided()) {
            if (STRICT) {
                throw new IllegalStateException("FATAL : A fact and its negation have been asserted " + jtmsBeliefSet.getFactHandle().getObject());
            }
            this.ep.delete(fh, fh.getObject(), this.getObjectTypeConf(jtmsBeliefSet), pctx.getRuleOrigin(), null, activation != null ? (TerminalNode)activation.getTuple().getTupleSink() : null);
            return true;
        }
        if (wasNegated != jtmsBeliefSet.isNegated()) {
            PropagationContext updatePctx = this.ep.getPctxFactory().createPropagationContext(this.ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, pctx.getRuleOrigin(), pctx.getTerminalNodeOrigin(), fh, this.ep.getEntryPoint());
            this.ep.update(fh, fh.getObject(), fh.getObject(), this.getObjectTypeConf(jtmsBeliefSet), updatePctx);
        }
        return false;
    }

    @Override
    public void stage(PropagationContext context, BeliefSet<M> beliefSet) {
        InternalFactHandle bfh = beliefSet.getFactHandle();
        this.ep.delete(bfh, bfh.getObject(), this.getObjectTypeConf(beliefSet), context.getRuleOrigin(), null);
    }

    @Override
    public void unstage(PropagationContext context, BeliefSet<M> beliefSet) {
        InternalFactHandle bfh = beliefSet.getFactHandle();
        this.ep.insert(bfh, bfh.getObject(), context.getRuleOrigin(), null, this.getObjectTypeConf(beliefSet));
    }

    private ObjectTypeConf getObjectTypeConf(BeliefSet<M> jtmsBeliefSet) {
        InternalFactHandle fh = jtmsBeliefSet.getFactHandle();
        ObjectTypeConfigurationRegistry reg = this.ep.getObjectTypeConfigurationRegistry();
        ObjectTypeConf typeConf = reg.getObjectTypeConf(this.ep.getEntryPoint(), fh.getObject());
        return typeConf;
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new JTMSBeliefSetImpl(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(Activation<M> activation, BeliefSet<M> beliefSet, Object object, Object value) {
        ModedAssertion mode = this.asMode(value);
        SimpleLogicalDependency<ModedAssertion> dep = new SimpleLogicalDependency<ModedAssertion>(activation, beliefSet, object, mode);
        ((JTMSMode)mode).setLogicalDependency(dep);
        return dep;
    }

    @Override
    public M asMode(Object value) {
        JTMSMode mode = value == null ? new JTMSMode(JTMSBeliefSetImpl.MODE.POSITIVE.getId(), this) : (value instanceof String ? (JTMSBeliefSetImpl.MODE.POSITIVE.getId().equals(value) ? new JTMSMode(JTMSBeliefSetImpl.MODE.POSITIVE.getId(), this) : new JTMSMode(JTMSBeliefSetImpl.MODE.NEGATIVE.getId(), this)) : new JTMSMode(((JTMSBeliefSetImpl.MODE)((Object)value)).getId(), this));
        return (M)mode;
    }
}

