/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.builder.conf.impl;

import java.util.Properties;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.ScoreCardConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreCardConfigurationImpl
extends ResourceConfigurationImpl
implements ScoreCardConfiguration {
    public static final String DROOLS_SCARD_WORKSHEET = "drools.dt.worksheet";
    public static final String DROOLS_SCARD_USE_EXTERNAL_TYPES = "drools.sc.useExternalTypes";
    public static final String DROOLS_SCARD_INPUT_TYPE = "drools.sc.inputType";
    private final Logger logger = LoggerFactory.getLogger(ScoreCardConfigurationImpl.class);
    private String worksheetName;
    private boolean useExternalTypes = false;
    private ScoreCardConfiguration.SCORECARD_INPUT_TYPE inputType = ScoreCardConfiguration.SCORECARD_INPUT_TYPE.EXCEL;

    @Override
    public void setWorksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
    }

    @Override
    public String getWorksheetName() {
        return this.worksheetName;
    }

    @Override
    public void setUsingExternalTypes(boolean useExternalTypes) {
        this.useExternalTypes = useExternalTypes;
    }

    @Override
    public boolean IsUsingExternalTypes() {
        return this.useExternalTypes;
    }

    @Override
    public void setInputType(ScoreCardConfiguration.SCORECARD_INPUT_TYPE inputType) {
        this.inputType = inputType;
    }

    @Override
    public String getInputType() {
        return this.inputType.toString();
    }

    @Override
    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.setProperty(DROOLS_SCARD_WORKSHEET, this.worksheetName);
        prop.setProperty(DROOLS_SCARD_USE_EXTERNAL_TYPES, Boolean.toString(this.useExternalTypes));
        prop.setProperty(DROOLS_SCARD_INPUT_TYPE, this.inputType.toString());
        return prop;
    }

    @Override
    public ResourceConfiguration fromProperties(Properties prop) {
        super.fromProperties(prop);
        this.worksheetName = prop.getProperty(DROOLS_SCARD_WORKSHEET, null);
        this.useExternalTypes = Boolean.getBoolean(prop.getProperty(DROOLS_SCARD_USE_EXTERNAL_TYPES, "false"));
        String inputTypeStr = prop.getProperty(DROOLS_SCARD_INPUT_TYPE, ScoreCardConfiguration.SCORECARD_INPUT_TYPE.EXCEL.toString());
        this.inputType = ScoreCardConfiguration.SCORECARD_INPUT_TYPE.valueOf(inputTypeStr);
        return this;
    }
}

