/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import java.util.function.BiFunction;
import org.drools.core.command.AbstractNewKieContainerCommand;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;

public class NewKieSessionCommand
extends AbstractNewKieContainerCommand
implements ExecutableCommand<KieSession> {
    private static final long serialVersionUID = 8748826714594402049L;
    private String sessionId;
    private ReleaseId releaseId;
    private BiFunction<String, KieContainer, KieContainer> beforeSessionCreation = (a, b) -> b;

    public NewKieSessionCommand(String sessionId) {
        this.sessionId = sessionId;
    }

    public NewKieSessionCommand(ReleaseId releaseId, String sessionId) {
        this.sessionId = sessionId;
        this.releaseId = releaseId;
    }

    @Override
    public KieSession execute(Context context) {
        KieContainer kieContainer = this.getKieContainer((RegistryContext)context, this.releaseId);
        kieContainer = this.beforeSessionCreation.apply(this.sessionId, kieContainer);
        KieSession ksession = this.sessionId != null ? kieContainer.newKieSession(this.sessionId) : kieContainer.newKieSession();
        ((RegistryContext)context).register(KieSession.class, ksession);
        return ksession;
    }

    public NewKieSessionCommand setBeforeSessionCreation(BiFunction<String, KieContainer, KieContainer> beforeSessionCreation) {
        this.beforeSessionCreation = beforeSessionCreation;
        return this;
    }

    public String toString() {
        return "NewKieSessionCommand{sessionId='" + this.sessionId + '\'' + ", releaseId=" + this.releaseId + '}';
    }
}

