/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.management;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.management.GenericKieSessionMonitoringImpl;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.management.StatelessKieSessionMonitoringMXBean;

public class StatelessKieSessionMonitoringImpl
extends GenericKieSessionMonitoringImpl
implements StatelessKieSessionMonitoringMXBean {
    private ObjectName name;
    public RuleRuntimeStats ruleRuntimeStats;

    public StatelessKieSessionMonitoringImpl(String containerId, String kbaseId, String ksessionName) {
        super(containerId, kbaseId, ksessionName);
        this.name = DroolsManagementAgent.createObjectNameBy(containerId, kbaseId, KieSessionModel.KieSessionType.STATELESS, ksessionName);
        this.ruleRuntimeStats = new RuleRuntimeStats();
    }

    @Override
    public ObjectName getName() {
        return this.name;
    }

    @Override
    public void attach(KieRuntimeEventManager ksession) {
        ksession.addEventListener(this.ruleRuntimeStats);
        super.attach(ksession);
    }

    @Override
    public void detach(KieRuntimeEventManager ksession) {
        ksession.removeEventListener(this.ruleRuntimeStats);
        super.detach(ksession);
    }

    @Override
    public void dispose() {
        for (KieRuntimeEventManager ksession : this.ksessions) {
            ksession.removeEventListener(this.ruleRuntimeStats);
        }
        super.dispose();
    }

    @Override
    public void reset() {
        this.ruleRuntimeStats.reset();
        super.reset();
    }

    @Override
    public long getTotalSessions() {
        long totalCount = 0L;
        for (KieRuntimeEventManager kr : this.ksessions) {
            totalCount += ((StatelessKnowledgeSessionImpl)kr).getWorkingMemoryCreatec();
        }
        return totalCount;
    }

    @Override
    public long getTotalObjectsInserted() {
        return this.ruleRuntimeStats.getConsolidatedStats().objectsInserted.get();
    }

    @Override
    public long getTotalObjectsDeleted() {
        return this.ruleRuntimeStats.getConsolidatedStats().objectsDeleted.get();
    }

    public static class RuleRuntimeStats
    implements RuleRuntimeEventListener {
        private RuleRuntimeStatsData data = new RuleRuntimeStatsData();

        public RuleRuntimeStatsData getConsolidatedStats() {
            return this.data;
        }

        public void reset() {
            this.data.reset();
        }

        @Override
        public void objectInserted(ObjectInsertedEvent event) {
            this.data.objectsInserted.incrementAndGet();
        }

        @Override
        public void objectUpdated(ObjectUpdatedEvent event) {
        }

        @Override
        public void objectDeleted(ObjectDeletedEvent event) {
            this.data.objectsDeleted.incrementAndGet();
        }

        public static class RuleRuntimeStatsData {
            public AtomicLong objectsInserted = new AtomicLong(0L);
            public AtomicLong objectsDeleted = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());

            public void reset() {
                this.objectsInserted.set(0L);
                this.objectsDeleted.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "objectsInserted=" + this.objectsInserted.get() + " objectsDeleted=" + this.objectsDeleted.get();
            }
        }
    }
}

