/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.util.HashSet;
import org.drools.core.util.StringUtils;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;

public class ObjectMarshallingStrategyStoreImpl
implements ObjectMarshallingStrategyStore {
    private ObjectMarshallingStrategy[] strategiesList;

    public ObjectMarshallingStrategyStoreImpl(ObjectMarshallingStrategy[] strategiesList) {
        this.strategiesList = strategiesList;
        HashSet<String> names = new HashSet<String>();
        for (ObjectMarshallingStrategy strategy : strategiesList) {
            String name = strategy.getName();
            if (names.contains(name)) {
                throw new RuntimeException("Multiple ObjectMarshallingStrategies with the same name found in environment:" + name);
            }
            names.add(name);
        }
        names.clear();
    }

    @Override
    public ObjectMarshallingStrategy getStrategy(int index) {
        return this.strategiesList[index];
    }

    @Override
    public int getStrategy(Object object) {
        int length = this.strategiesList.length;
        for (int i = 0; i < length; ++i) {
            if (!this.strategiesList[i].accept(object)) continue;
            return i;
        }
        throw new RuntimeException("Unable to find PlaceholderResolverStrategy for class : " + object.getClass() + " object : " + object);
    }

    @Override
    public ObjectMarshallingStrategy getStrategyObject(String strategyName) {
        if (StringUtils.isEmpty(strategyName)) {
            return null;
        }
        if (strategyName.startsWith("org.drools.marshalling.impl")) {
            strategyName = strategyName.replaceFirst("org.drools.marshalling.impl", "org.drools.core.marshalling.impl");
        }
        for (int i = 0; i < this.strategiesList.length; ++i) {
            if (!this.strategiesList[i].getName().equals(strategyName)) continue;
            return this.strategiesList[i];
        }
        throw new RuntimeException("Unable to find PlaceholderResolverStrategy for name : " + strategyName);
    }

    @Override
    public ObjectMarshallingStrategy getStrategyObject(Object object) {
        int length = this.strategiesList.length;
        for (int i = 0; i < length; ++i) {
            if (!this.strategiesList[i].accept(object)) continue;
            return this.strategiesList[i];
        }
        throw new RuntimeException("Unable to find PlaceholderResolverStrategy for class : " + object.getClass() + " object : " + object);
    }
}

