/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.process.workitem.Policy;

public class DefaultWorkItemManager
implements WorkItemManager,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<String, WorkItem> workItems = new ConcurrentHashMap<String, WorkItem>();
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();

    public DefaultWorkItemManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public DefaultWorkItemManager() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workItems = (Map)in.readObject();
        this.kruntime = (InternalKnowledgeRuntime)in.readObject();
        this.workItemHandlers = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workItems);
        out.writeObject(this.kruntime);
        out.writeObject(this.workItemHandlers);
    }

    @Override
    public void internalExecuteWorkItem(WorkItem workItem) {
        ((WorkItemImpl)workItem).setId(UUID.randomUUID().toString());
        this.internalAddWorkItem(workItem);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
        }
        handler.executeWorkItem(workItem, this);
    }

    @Override
    public void internalAddWorkItem(WorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
    }

    @Override
    public void internalAbortWorkItem(String id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getId());
                throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
            }
            handler.abortWorkItem(workItem, this);
            this.workItems.remove(workItem.getId());
        }
    }

    public WorkItemHandler getWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void retryWorkItem(String workItemId) {
        WorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(String workItemId, Map<String, Object> map) {
        WorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(WorkItem workItem) {
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem(workItem, this);
            } else {
                throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
            }
        }
    }

    @Override
    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>(this.workItems.values());
    }

    @Override
    public WorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    @Override
    public void completeWorkItem(String id, Map<String, Object> results, Policy<?> ... policies) {
        WorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", workItem);
            }
            this.workItems.remove(id);
        }
    }

    @Override
    public void abortWorkItem(String id, Policy<?> ... policies) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", workItem);
            }
            this.workItems.remove(id);
        }
    }

    @Override
    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    @Override
    public void clear() {
        this.workItems.clear();
    }

    @Override
    public void signalEvent(String type, Object event) {
        this.kruntime.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, String processInstanceId) {
        this.kruntime.signalEvent(type, event, processInstanceId);
    }

    @Override
    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, WorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)((Object)handlerEntry.getValue())).close();
            }
        }
    }

    @Override
    public void retryWorkItem(String workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }

    @Override
    public void internalCompleteWorkItem(WorkItem workItem) {
    }
}

