/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.runtime;

import java.util.Collections;
import java.util.List;
import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.BatchImpl;
import org.drools.core.fluent.impl.InternalExecutable;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.RequestContext;
import org.kie.internal.command.RegistryContext;

public interface InternalLocalRunner
extends ExecutableRunner<RequestContext> {
    @Override
    default public RequestContext execute(Executable executable) {
        return (RequestContext)this.execute(executable, this.createContext());
    }

    @Override
    default public <T> T execute(Command<T> command) {
        RequestContext ctx = this.execute(new SingleCommandExecutable(command));
        return (T)(command instanceof BatchExecutionCommand ? ((RegistryContext)((Object)ctx)).lookup(ExecutionResultImpl.class) : ctx.getResult());
    }

    @Override
    default public <T> T execute(Command<T> command, Context ctx) {
        this.execute(new SingleCommandExecutable(command), (RequestContext)ctx);
        return (T)(command instanceof BatchExecutionCommand ? ((RegistryContext)ctx).lookup(ExecutionResultImpl.class) : ((RequestContext)ctx).getResult());
    }

    public static class SingleCommandExecutable
    extends SingleBatchExecutable {
        public SingleCommandExecutable(Command command) {
            super(new BatchImpl().addCommand(command));
        }
    }

    public static class SingleBatchExecutable
    implements InternalExecutable {
        private final Batch batch;

        public SingleBatchExecutable(Batch batch) {
            this.batch = batch;
        }

        @Override
        public List<Batch> getBatches() {
            return Collections.singletonList(this.batch);
        }
    }
}

