/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAliasType;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.function.Function;

public class XStreamUtils {
    private static final String[] WHITELISTED_PACKAGES = new String[]{"org.drools.core.command.**", "org.drools.core.runtime.impl.ExecutionResultImpl", "org.drools.core.runtime.rule.impl.FlatQueryResults", "org.drools.core.common.DefaultFactHandle", "org.drools.core.common.EventFactHandle"};

    private XStreamUtils() {
    }

    public static XStream createTrustingXStream() {
        return XStreamUtils.internalCreateTrustingXStream(new XStream());
    }

    public static XStream createTrustingXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        return XStreamUtils.internalCreateTrustingXStream(new XStream(hierarchicalStreamDriver));
    }

    public static XStream createTrustingXStream(HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoader classLoader) {
        return XStreamUtils.internalCreateTrustingXStream(new XStream((ReflectionProvider)null, hierarchicalStreamDriver, new ClassLoaderReference(classLoader)));
    }

    public static XStream createTrustingXStream(ReflectionProvider reflectionProvider) {
        return XStreamUtils.internalCreateTrustingXStream(new XStream(reflectionProvider));
    }

    public static XStream createTrustingXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        return XStreamUtils.internalCreateTrustingXStream(new XStream(reflectionProvider, hierarchicalStreamDriver));
    }

    public static XStream createTrustingXStream(ReflectionProvider reflectionProvider, final Function<MapperWrapper, MapperWrapper> mapper) {
        return XStreamUtils.internalCreateTrustingXStream(new XStream(reflectionProvider){

            @Override
            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return (MapperWrapper)mapper.apply(next);
            }
        });
    }

    private static XStream internalCreateTrustingXStream(XStream xstream) {
        XStream.setupDefaultSecurity(xstream);
        xstream.addPermission(new AnyTypePermission());
        return xstream;
    }

    public static XStream createNonTrustingXStream() {
        return XStreamUtils.internalCreateNonTrustingXStream(new XStream());
    }

    public static XStream createNonTrustingXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        return XStreamUtils.internalCreateNonTrustingXStream(new XStream(hierarchicalStreamDriver));
    }

    public static XStream createNonTrustingXStream(HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoader classLoader) {
        return XStreamUtils.internalCreateNonTrustingXStream(new XStream((ReflectionProvider)null, hierarchicalStreamDriver, new ClassLoaderReference(classLoader)));
    }

    public static XStream createNonTrustingXStream(ReflectionProvider reflectionProvider) {
        return XStreamUtils.internalCreateNonTrustingXStream(new XStream(reflectionProvider));
    }

    public static XStream createNonTrustingXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        return XStreamUtils.internalCreateNonTrustingXStream(new XStream(reflectionProvider, hierarchicalStreamDriver));
    }

    public static XStream createNonTrustingXStream(ReflectionProvider reflectionProvider, final Function<MapperWrapper, MapperWrapper> mapper) {
        return XStreamUtils.internalCreateNonTrustingXStream(new XStream(reflectionProvider){

            @Override
            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return (MapperWrapper)mapper.apply(next);
            }
        });
    }

    private static XStream internalCreateNonTrustingXStream(XStream xstream) {
        XStream.setupDefaultSecurity(xstream);
        xstream.addPermission(new AnyAnnotationTypePermission());
        xstream.addPermission(new WildcardTypePermission(WHITELISTED_PACKAGES));
        return xstream;
    }

    public static class AnyAnnotationTypePermission
    implements TypePermission {
        @Override
        public boolean allows(Class type) {
            if (type == null) {
                return false;
            }
            return type.isAnnotationPresent(XStreamAlias.class) || type.isAnnotationPresent(XStreamAliasType.class) || type.isAnnotationPresent(XStreamInclude.class);
        }
    }
}

