/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml.jaxb.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbListAdapter
extends XmlAdapter<JaxbListWrapper, Collection> {
    protected static Logger logger = LoggerFactory.getLogger(JaxbListAdapter.class);
    private static final JaxbUnknownAdapter unknownAdapter = new JaxbUnknownAdapter();

    public JaxbListWrapper marshal(Collection v) throws Exception {
        if (v == null) {
            return new JaxbListWrapper(new Object[0]);
        }
        try {
            if (v instanceof List) {
                Object[] marshalledArr = JaxbListAdapter.marshalUnknownCollection(v);
                return new JaxbListWrapper(marshalledArr, JaxbListWrapper.JaxbWrapperType.LIST);
            }
            if (v instanceof Set) {
                Object[] marshalledArr = JaxbListAdapter.marshalUnknownCollection(v);
                return new JaxbListWrapper(marshalledArr, JaxbListWrapper.JaxbWrapperType.SET);
            }
            throw new UnsupportedOperationException("Unsupported collection type: " + v.getClass());
        }
        catch (Exception e) {
            logger.error("Unable to marshal " + v.getClass().getName() + " instance: " + e.getMessage(), e);
            throw e;
        }
    }

    private static Object[] marshalUnknownCollection(Collection objColl) throws Exception {
        Object[] wrapperArr = new Object[objColl.size()];
        int i = 0;
        for (Object obj : objColl) {
            wrapperArr[i++] = unknownAdapter.marshal(obj);
        }
        return wrapperArr;
    }

    public Collection unmarshal(JaxbListWrapper v) throws Exception {
        try {
            if (v.getType() == null) {
                return new ArrayList<Object>(Arrays.asList(v.getElements()));
            }
            switch (v.getType()) {
                case LIST: {
                    return new ArrayList(JaxbListAdapter.unmarshalWrappedArray(v.getElements()));
                }
                case SET: {
                    return new HashSet(JaxbListAdapter.unmarshalWrappedArray(v.getElements()));
                }
            }
            throw new UnsupportedOperationException("Unsupported collection type: " + (Object)((Object)v.getType()));
        }
        catch (Exception e) {
            logger.error("Unable to *un*marshal " + v.getClass().getName() + " instance: " + e.getMessage(), e);
            throw e;
        }
    }

    private static Collection unmarshalWrappedArray(Object[] objArr) throws Exception {
        if (objArr == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>(objArr.length);
        for (Object obj : objArr) {
            list.add(unknownAdapter.unmarshal(obj));
        }
        return list;
    }
}

