/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.StatisticsConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV2;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContextInitializer;

public class ConfigurationBuilder
implements ConfigurationChildBuilder,
Builder<Configuration> {
    private static final Log log = LogFactory.getLog(ConfigurationBuilder.class, Log.class);
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\[([0-9A-Fa-f:]+)\\]|([^:/?#]*))(?::(\\d*))?");
    private WeakReference<ClassLoader> classLoader;
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory = RoundRobinBalancingStrategy::new;
    private ClientIntelligence clientIntelligence = ClientIntelligence.getDefault();
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private int connectionTimeout = 60000;
    private final Class<? extends ConsistentHash>[] consistentHashImpl = new Class[]{null, ConsistentHashV2.class, SegmentConsistentHash.class};
    private boolean forceReturnValues;
    private int keySizeEstimate = 64;
    private Class<? extends Marshaller> marshallerClass;
    private Marshaller marshaller;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
    private final List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private int socketTimeout = 60000;
    private final SecurityConfigurationBuilder security;
    private boolean tcpNoDelay = true;
    private boolean tcpKeepAlive = false;
    private int valueSizeEstimate = 512;
    private int maxRetries = 10;
    private final NearCacheConfigurationBuilder nearCache;
    private final List<String> whiteListRegExs = new ArrayList<String>();
    private int batchSize = 10000;
    private final TransactionConfigurationBuilder transaction;
    private final StatisticsConfigurationBuilder statistics;
    private final List<ClusterConfigurationBuilder> clusters = new ArrayList<ClusterConfigurationBuilder>();
    private Features features;
    private final List<SerializationContextInitializer> contextInitializers = new ArrayList<SerializationContextInitializer>();

    public ConfigurationBuilder() {
        this.classLoader = new WeakReference<ClassLoader>(Thread.currentThread().getContextClassLoader());
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
        this.nearCache = new NearCacheConfigurationBuilder(this);
        this.transaction = new TransactionConfigurationBuilder(this);
        this.statistics = new StatisticsConfigurationBuilder(this);
    }

    @Override
    public ServerConfigurationBuilder addServer() {
        ServerConfigurationBuilder builder = new ServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    @Override
    public ClusterConfigurationBuilder addCluster(String clusterName) {
        ClusterConfigurationBuilder builder = new ClusterConfigurationBuilder(this, clusterName);
        this.clusters.add(builder);
        return builder;
    }

    @Override
    public ConfigurationBuilder addServers(String servers) {
        ConfigurationBuilder.parseServers(servers, (host, port) -> this.addServer().host((String)host).port((int)port));
        return this;
    }

    public static final void parseServers(String servers, BiConsumer<String, Integer> c) {
        for (String server : servers.split(";")) {
            Matcher matcher = ADDRESS_PATTERN.matcher(server.trim());
            if (!matcher.matches()) {
                throw Log.HOTROD.parseErrorServerAddress(server);
            }
            String v6host = matcher.group(2);
            String v4host = matcher.group(3);
            String host = v6host != null ? v6host : v4host;
            String portString = matcher.group(4);
            int port = portString == null ? 11222 : Integer.parseInt(portString);
            c.accept(host, port);
        }
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.balancingStrategyFactory = () -> (FailoverRequestBalancingStrategy)Util.getInstance(balancingStrategy, this.classLoader());
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationBuilder balancingStrategy(FailoverRequestBalancingStrategy balancingStrategy) {
        this.balancingStrategyFactory = () -> balancingStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory) {
        this.balancingStrategyFactory = balancingStrategyFactory;
        return this;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(Class<? extends FailoverRequestBalancingStrategy> balancingStrategy) {
        this.balancingStrategyFactory = () -> (FailoverRequestBalancingStrategy)Util.getInstance(balancingStrategy);
        return this;
    }

    @Override
    public ConfigurationBuilder classLoader(ClassLoader cl) {
        this.classLoader = new WeakReference<ClassLoader>(cl);
        return this;
    }

    ClassLoader classLoader() {
        return this.classLoader != null ? (ClassLoader)this.classLoader.get() : null;
    }

    @Override
    public ConfigurationBuilder clientIntelligence(ClientIntelligence clientIntelligence) {
        this.clientIntelligence = clientIntelligence;
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public ConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public ConfigurationBuilder consistentHashImpl(int version, Class<? extends ConsistentHash> consistentHashClass) {
        if (version == 1) {
            log.warn("Hash function version 1 is no longer supported.");
        } else {
            this.consistentHashImpl[version - 1] = consistentHashClass;
        }
        return this;
    }

    @Override
    public ConfigurationBuilder consistentHashImpl(int version, String consistentHashClass) {
        if (version == 1) {
            log.warn("Hash function version 1 is no longer supported.");
        } else {
            this.consistentHashImpl[version - 1] = Util.loadClass(consistentHashClass, this.classLoader());
        }
        return this;
    }

    @Override
    public ConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.forceReturnValues = forceReturnValues;
        return this;
    }

    @Override
    public ConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.keySizeEstimate = keySizeEstimate;
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(String marshaller) {
        this.marshallerClass = Util.loadClass(marshaller, this.classLoader());
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshallerClass = marshaller;
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        this.marshallerClass = marshaller == null ? null : marshaller.getClass();
        return this;
    }

    @Override
    public ConfigurationBuilder addContextInitializer(String contextInitializer) {
        SerializationContextInitializer sci = (SerializationContextInitializer)Util.getInstance(contextInitializer, this.classLoader());
        return this.addContextInitializers(sci);
    }

    @Override
    public ConfigurationBuilder addContextInitializer(SerializationContextInitializer contextInitializer) {
        if (contextInitializer != null) {
            this.contextInitializers.add(contextInitializer);
        }
        return this;
    }

    @Override
    public ConfigurationBuilder addContextInitializers(SerializationContextInitializer ... contextInitializers) {
        this.contextInitializers.addAll(Arrays.asList(contextInitializers));
        return this;
    }

    public NearCacheConfigurationBuilder nearCache() {
        return this.nearCache;
    }

    @Override
    @Deprecated
    public ConfigurationBuilder protocolVersion(String protocolVersion) {
        this.protocolVersion = ProtocolVersion.parseVersion(protocolVersion);
        return this;
    }

    @Override
    public ConfigurationBuilder version(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    @Override
    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public ConfigurationBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public ConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Override
    public ConfigurationBuilder tcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
        return this;
    }

    @Override
    public ConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.valueSizeEstimate = valueSizeEstimate;
        return this;
    }

    @Override
    public ConfigurationBuilder maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public ConfigurationBuilder addJavaSerialWhiteList(String ... regEx) {
        this.whiteListRegExs.addAll(Arrays.asList(regEx));
        return this;
    }

    @Override
    public ConfigurationBuilder batchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder statistics() {
        return this.statistics;
    }

    @Override
    public TransactionConfigurationBuilder transaction() {
        return this.transaction;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        if (typed.containsKey("infinispan.client.hotrod.async_executor_factory")) {
            this.asyncExecutorFactory().factoryClass(typed.getProperty("infinispan.client.hotrod.async_executor_factory", null, true));
        }
        this.asyncExecutorFactory().withExecutorProperties(typed);
        String balancingStrategyClass = typed.getProperty("infinispan.client.hotrod.request_balancing_strategy", null, true);
        if (balancingStrategyClass != null) {
            this.balancingStrategy(balancingStrategyClass);
        }
        this.clientIntelligence(typed.getEnumProperty("infinispan.client.hotrod.client_intelligence", ClientIntelligence.class, ClientIntelligence.getDefault(), true));
        this.connectionPool.withPoolProperties(typed);
        this.connectionTimeout(typed.getIntProperty("infinispan.client.hotrod.connect_timeout", this.connectionTimeout, true));
        if (typed.containsKey("infinispan.client.hotrod.hash_function_impl.1")) {
            log.warn("Hash function version 1 is no longer supported");
        }
        for (int i = 0; i < this.consistentHashImpl.length; ++i) {
            if (this.consistentHashImpl[i] == null) continue;
            int version = i + 1;
            String hashClassName = typed.getProperty("infinispan.client.hotrod.hash_function_impl." + version, null, true);
            if (hashClassName == null) continue;
            this.consistentHashImpl(version, hashClassName);
        }
        this.forceReturnValues(typed.getBooleanProperty("infinispan.client.hotrod.force_return_values", this.forceReturnValues, true));
        this.keySizeEstimate(typed.getIntProperty("infinispan.client.hotrod.key_size_estimate", this.keySizeEstimate, true));
        if (typed.containsKey("infinispan.client.hotrod.marshaller")) {
            this.marshaller(typed.getProperty("infinispan.client.hotrod.marshaller", null, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.context-initializers")) {
            String initializers = typed.getProperty("infinispan.client.hotrod.context-initializers");
            for (String sci : initializers.split(",")) {
                this.addContextInitializer(sci);
            }
        }
        this.version(ProtocolVersion.parseVersion(typed.getProperty("infinispan.client.hotrod.protocol_version", this.protocolVersion.toString(), true)));
        String serverList = typed.getProperty("infinispan.client.hotrod.server_list", null, true);
        if (serverList != null) {
            this.servers.clear();
            this.addServers(serverList);
        }
        this.socketTimeout(typed.getIntProperty("infinispan.client.hotrod.socket_timeout", this.socketTimeout, true));
        this.tcpNoDelay(typed.getBooleanProperty("infinispan.client.hotrod.tcp_no_delay", this.tcpNoDelay, true));
        this.tcpKeepAlive(typed.getBooleanProperty("infinispan.client.hotrod.tcp_keep_alive", this.tcpKeepAlive, true));
        this.valueSizeEstimate(typed.getIntProperty("infinispan.client.hotrod.value_size_estimate", this.valueSizeEstimate, true));
        this.maxRetries(typed.getIntProperty("infinispan.client.hotrod.max_retries", this.maxRetries, true));
        this.security.ssl().withProperties(properties);
        this.security.authentication().withProperties(properties);
        String serialWhitelist = typed.getProperty("infinispan.client.hotrod.java_serial_whitelist");
        if (serialWhitelist != null && !serialWhitelist.isEmpty()) {
            String[] classes = serialWhitelist.split(",");
            Collections.addAll(this.whiteListRegExs, classes);
        }
        this.batchSize(typed.getIntProperty("infinispan.client.hotrod.batch_size", this.batchSize, true));
        this.transaction.withTransactionProperties(properties);
        this.nearCache.withProperties(properties);
        Map<String, String> xsiteProperties = typed.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("infinispan.client.hotrod.cluster")).collect(Collectors.toMap(e -> ConfigurationProperties.CLUSTER_PROPERTIES_PREFIX_REGEX.matcher((String)e.getKey()).replaceFirst(""), e -> StringPropertyReplacer.replaceProperties((String)e.getValue())));
        xsiteProperties.entrySet().forEach(entry -> {
            ClusterConfigurationBuilder cluster = this.addCluster((String)entry.getKey());
            ConfigurationBuilder.parseServers((String)entry.getValue(), (host, port) -> cluster.addClusterNode((String)host, (int)port));
        });
        this.statistics.withProperties(properties);
        return this;
    }

    @Override
    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        this.security.validate();
        this.nearCache.validate();
        this.transaction.validate();
        this.statistics.validate();
        if (this.maxRetries < 0) {
            throw Log.HOTROD.invalidMaxRetries(this.maxRetries);
        }
        HashSet<String> clusterNameSet = new HashSet<String>(this.clusters.size());
        for (ClusterConfigurationBuilder clusterConfigBuilder : this.clusters) {
            if (!clusterNameSet.add(clusterConfigBuilder.getClusterName())) {
                throw Log.HOTROD.duplicateClusterDefinition(clusterConfigBuilder.getClusterName());
            }
            clusterConfigBuilder.validate();
        }
    }

    @Override
    public Configuration create() {
        ArrayList<ServerConfiguration> servers = new ArrayList<ServerConfiguration>();
        if (this.servers.size() > 0) {
            for (ServerConfigurationBuilder server : this.servers) {
                servers.add(server.create());
            }
        } else {
            servers.add(new ServerConfiguration("127.0.0.1", 11222));
        }
        List<ClusterConfiguration> serverClusterConfigs = this.clusters.stream().map(ClusterConfigurationBuilder::create).collect(Collectors.toList());
        if (this.marshaller == null && this.marshallerClass == null) {
            this.handleNullMarshaller();
        }
        return new Configuration(this.asyncExecutorFactory.create(), this.balancingStrategyFactory, this.classLoader == null ? null : (ClassLoader)this.classLoader.get(), this.clientIntelligence, this.connectionPool.create(), this.connectionTimeout, this.consistentHashImpl, this.forceReturnValues, this.keySizeEstimate, this.marshaller, this.marshallerClass, this.protocolVersion, servers, this.socketTimeout, this.security.create(), this.tcpNoDelay, this.tcpKeepAlive, this.valueSizeEstimate, this.maxRetries, this.nearCache.create(), serverClusterConfigs, this.whiteListRegExs, this.batchSize, this.transaction.create(), this.statistics.create(), this.features, this.contextInitializers);
    }

    private void handleNullMarshaller() {
        this.marshaller = Util.getJBossMarshaller(ConfigurationBuilder.class.getClassLoader(), null);
        if (this.marshaller == null) {
            this.marshaller = new ProtoStreamMarshaller();
        }
        this.marshallerClass = this.marshaller.getClass();
    }

    @Override
    public Configuration build() {
        this.features = new Features((ClassLoader)this.classLoader.get());
        return this.build(true);
    }

    public Configuration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public ConfigurationBuilder read(Configuration template) {
        this.classLoader = new WeakReference<ClassLoader>(template.classLoader());
        this.asyncExecutorFactory.read(template.asyncExecutorFactory());
        this.balancingStrategyFactory = template.balancingStrategyFactory();
        this.connectionPool.read(template.connectionPool());
        this.connectionTimeout = template.connectionTimeout();
        for (int i = 0; i < this.consistentHashImpl.length; ++i) {
            this.consistentHashImpl[i] = template.consistentHashImpl(i + 1);
        }
        this.forceReturnValues = template.forceReturnValues();
        this.keySizeEstimate = template.keySizeEstimate();
        this.marshaller = template.marshaller();
        this.marshallerClass = template.marshallerClass();
        this.protocolVersion = template.version();
        this.servers.clear();
        for (ServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.clusters.clear();
        template.clusters().forEach(cluster -> this.addCluster(cluster.getClusterName()).read((ClusterConfiguration)cluster));
        this.socketTimeout = template.socketTimeout();
        this.security.read(template.security());
        this.tcpNoDelay = template.tcpNoDelay();
        this.tcpKeepAlive = template.tcpKeepAlive();
        this.valueSizeEstimate = template.valueSizeEstimate();
        this.maxRetries = template.maxRetries();
        this.nearCache.read(template.nearCache());
        this.whiteListRegExs.addAll(template.serialWhitelist());
        this.transaction.read(template.transaction());
        this.statistics.read(template.statistics());
        this.contextInitializers.clear();
        this.contextInitializers.addAll(template.getContextInitializers());
        return this;
    }
}

