/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.time.TimeService;

public class InvalidatedNearRemoteCache<K, V>
extends RemoteCacheImpl<K, V> {
    private final NearCacheService<K, V> nearcache;

    public InvalidatedNearRemoteCache(RemoteCacheManager rcm, String name, TimeService timeService, NearCacheService<K, V> nearcache) {
        super(rcm, name, new ClientStatistics(rcm.getConfiguration().statistics().enabled(), timeService, nearcache));
        this.nearcache = nearcache;
    }

    @Override
    public CompletableFuture<V> getAsync(Object key) {
        CompletableFuture<MetadataValue<V>> value = this.getWithMetadataAsync(key);
        return value.thenApply(v -> v != null ? v.getValue() : null);
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        MetadataValue<V> nearValue = this.nearcache.get(key);
        if (nearValue == null) {
            this.clientStatistics.incrementNearCacheMisses();
            CompletableFuture remoteValue = super.getWithMetadataAsync(key);
            return remoteValue.thenApply(v -> {
                if (v != null) {
                    this.nearcache.putIfAbsent(key, (MetadataValue<V>)v);
                    if (v.getMaxIdle() > 0) {
                        Log.HOTROD.nearCacheMaxIdleUnsupported();
                    }
                }
                return v;
            });
        }
        this.clientStatistics.incrementNearCacheHits();
        return CompletableFuture.completedFuture(nearValue);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        CompletableFuture<V> ret = super.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return ret.thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit).thenRun(() -> map.keySet().forEach(this.nearcache::remove));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return this.invalidateNearCacheIfNeeded(this.operationsFactory.hasFlag(Flag.FORCE_RETURN_VALUE), key, super.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdleTime, maxIdleTimeUnit).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.invalidateNearCacheIfNeeded(this.operationsFactory.hasFlag(Flag.FORCE_RETURN_VALUE), key, super.removeAsync(key));
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        return super.removeWithVersionAsync(key, version).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return super.clearAsync().thenRun(() -> this.nearcache.clear());
    }

    CompletableFuture<V> invalidateNearCacheIfNeeded(boolean hasForceReturnValue, Object key, CompletableFuture<V> prev) {
        return prev.thenApply(v -> {
            if (!hasForceReturnValue || v != null) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public void start() {
        this.nearcache.start(this);
    }

    @Override
    public void stop() {
        this.nearcache.stop(this);
    }
}

