/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;

public final class FileDescriptorSource {
    private static final int BUFFER_SIZE = 1024;
    private final Map<String, char[]> descriptors = new LinkedHashMap<String, char[]>();
    private ProgressCallback progressCallback;

    public FileDescriptorSource withProgressCallback(ProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
        return this;
    }

    public FileDescriptorSource addProtoFiles(String ... classpathResources) throws IOException {
        return this.addProtoFiles((ClassLoader)null, classpathResources);
    }

    public FileDescriptorSource addProtoFiles(ClassLoader userClassLoader, String ... classpathResources) throws IOException {
        for (String classpathResource : classpathResources) {
            if (classpathResource == null) {
                throw new IllegalArgumentException("classpathResource cannot be null");
            }
            String absResPath = classpathResource.startsWith("/") ? classpathResource : "/" + classpathResource;
            InputStream resourceAsStream = FileDescriptorSource.getResourceAsStream(userClassLoader, absResPath);
            if (resourceAsStream == null) {
                throw new IOException("Resource not found in class path : " + absResPath);
            }
            String path = classpathResource.startsWith("/") ? classpathResource.substring(1) : classpathResource;
            this.addProtoFile(path, resourceAsStream);
        }
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, String contents) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, contents.toCharArray());
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, InputStream contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, this.toCharArray(contents));
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, Reader contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, this.toCharArray(contents));
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, File protofile) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (protofile == null) {
            throw new IllegalArgumentException("protofile cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, this.toCharArray(protofile));
        return this;
    }

    public static FileDescriptorSource fromResources(ClassLoader userClassLoader, String ... classPathResources) throws IOException {
        return new FileDescriptorSource().addProtoFiles(userClassLoader, classPathResources);
    }

    public static FileDescriptorSource fromResources(String ... classPathResources) throws IOException {
        return new FileDescriptorSource().addProtoFiles(classPathResources);
    }

    public static FileDescriptorSource fromString(String name, String protoSource) {
        return new FileDescriptorSource().addProtoFile(name, protoSource);
    }

    public Map<String, char[]> getFileDescriptors() {
        return Collections.unmodifiableMap(this.descriptors);
    }

    public ProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    private char[] toCharArray(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            char[] cArray = this.toCharArray(is);
            return cArray;
        }
    }

    private char[] toCharArray(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            char[] cArray = this.toCharArray(reader);
            return cArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] toCharArray(Reader reader) throws IOException {
        try {
            int count;
            CharArrayWriter writer = new CharArrayWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            char[] cArray = writer.toCharArray();
            return cArray;
        }
        finally {
            reader.close();
        }
    }

    private static InputStream getResourceAsStream(ClassLoader userClassLoader, String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        ClassLoader[] classLoaders = new ClassLoader[]{userClassLoader, FileDescriptorSource.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
        InputStream is = null;
        for (ClassLoader cl : classLoaders) {
            if (cl != null && (is = cl.getResourceAsStream(resourcePath)) != null) break;
        }
        return is;
    }

    /*
     * Exception decompiling
     */
    public static String getResourceAsString(Class<?> c, String name) throws UncheckedIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface ProgressCallback {
        default public void handleError(String fileName, DescriptorParserException exception) {
        }

        default public void handleSuccess(String fileName) {
        }
    }
}

