/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XConstructor;
import org.infinispan.protostream.annotations.impl.types.XExecutable;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;

public abstract class AbstractMarshallerCodeGenerator {
    private static final String PROTOSTREAM_PACKAGE = SerializationContext.class.getPackage().getName();
    private final XTypeFactory typeFactory;
    private final boolean noDefaults = false;
    private final String protobufSchemaPackage;

    protected AbstractMarshallerCodeGenerator(XTypeFactory typeFactory, String protobufSchemaPackage) {
        this.typeFactory = typeFactory;
        this.protobufSchemaPackage = protobufSchemaPackage;
    }

    protected String generateEnumDecodeMethodBody(ProtoEnumTypeMetadata enumTypeMetadata) {
        IndentWriter iw = new IndentWriter();
        iw.append("{\n");
        iw.inc();
        iw.append("switch ($1) {\n");
        iw.inc();
        for (ProtoEnumValueMetadata value : enumTypeMetadata.getMembers().values()) {
            iw.append("case ").append(String.valueOf(value.getNumber())).append(": return ").append(value.getJavaEnumName()).append(";\n");
        }
        iw.append("default: return null;\n");
        iw.dec();
        iw.append("}\n");
        iw.dec();
        iw.append("}\n");
        return iw.toString();
    }

    protected String generateEnumEncodeMethodBody(ProtoEnumTypeMetadata enumTypeMetadata) {
        IndentWriter iw = new IndentWriter();
        iw.append("{\n");
        iw.inc();
        iw.append("switch ($1.ordinal()) {\n");
        iw.inc();
        for (ProtoEnumValueMetadata value : enumTypeMetadata.getMembers().values()) {
            iw.append("case ").append(String.valueOf(value.getJavaEnumOrdinal())).append(": return ").append(String.valueOf(value.getNumber())).append(";\n");
        }
        iw.append("default: throw new IllegalArgumentException(\"Unexpected ").append(enumTypeMetadata.getJavaClassName()).append(" enum value : \" + $1.name());\n");
        iw.dec();
        iw.append("}\n");
        iw.dec();
        iw.append("}\n");
        return iw.toString();
    }

    protected String makeQualifiedTypeName(String fullName) {
        if (this.protobufSchemaPackage != null) {
            return this.protobufSchemaPackage + '.' + fullName;
        }
        return fullName;
    }

    private String makeTestFieldWasNotSet(Collection<ProtoFieldMetadata> fields, Map<String, Integer> trackedFields) {
        HashMap<Integer, Long> masks = new HashMap<Integer, Long>();
        for (ProtoFieldMetadata field : fields) {
            int fieldBitIndex = trackedFields.get(field.getName());
            masks.merge(fieldBitIndex >> 6, 1L << fieldBitIndex, (a, b) -> a | b);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator iterator = masks.keySet().iterator();
        while (iterator.hasNext()) {
            int set = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                sb.append(" || ");
            }
            long mask = (Long)masks.get(set);
            sb.append("(__bits$").append(set).append(" & ").append(mask).append("L) != ").append(mask).append('L');
        }
        return sb.toString();
    }

    private String makeTestFieldWasNotSet(ProtoFieldMetadata field, Map<String, Integer> trackedFields) {
        int fieldBitIndex = trackedFields.get(field.getName());
        return "((__bits$" + (fieldBitIndex >> 6) + " & " + (1L << fieldBitIndex) + "L) == 0)";
    }

    private String makeFieldWasSet(ProtoFieldMetadata field, Map<String, Integer> trackedFields) {
        int fieldBitIndex = trackedFields.get(field.getName());
        return "__bits$" + (fieldBitIndex >> 6) + " |= " + (1L << fieldBitIndex) + 'L';
    }

    private String makeFieldLocalVar(ProtoFieldMetadata field) {
        return "__v$" + field.getNumber();
    }

    private String makeCollectionLocalVar(ProtoFieldMetadata field) {
        return "__c$" + field.getNumber();
    }

    private String makeArrayLocalVar(ProtoFieldMetadata field) {
        return "__a$" + field.getNumber();
    }

    protected String makeMarshallerDelegateFieldName(ProtoFieldMetadata field) {
        return "__md$" + field.getNumber();
    }

    protected String generateReadFromMethodBody(ProtoMessageTypeMetadata messageTypeMetadata) {
        String val;
        boolean isMutableMessage;
        String getUnknownFieldSetFieldStatement = null;
        String setUnknownFieldSetFieldStatement = null;
        if (messageTypeMetadata.getUnknownFieldSetField() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetField().getName();
            setUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetField().getName() + " = u";
        } else if (messageTypeMetadata.getUnknownFieldSetGetter() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetGetter().getName() + "()";
            setUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetSetter().getName() + "(u)";
        } else if (messageTypeMetadata.getJavaClass().isAssignableTo(this.typeFactory.fromClass(Message.class))) {
            getUnknownFieldSetFieldStatement = "o.getUnknownFieldSet()";
            setUnknownFieldSetFieldStatement = "o.setUnknownFieldSet(u)";
        }
        IndentWriter iw = new IndentWriter();
        iw.append("{\n");
        iw.inc();
        boolean bl = isMutableMessage = messageTypeMetadata.getFactory() == null;
        if (isMutableMessage) {
            iw.append("final ").append(messageTypeMetadata.getJavaClassName()).append(" o = new ").append(messageTypeMetadata.getJavaClassName()).append("();\n");
        }
        int mandatoryFields = 0;
        LinkedHashMap<String, Integer> trackedFields = new LinkedHashMap<String, Integer>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            if (fieldMetadata.isRequired() && fieldMetadata.getDefaultValue() == null) {
                ++mandatoryFields;
            }
            if (!fieldMetadata.isRequired() && (fieldMetadata.getDefaultValue() == null || !isMutableMessage && !fieldMetadata.isRepeated() && fieldMetadata.getProtobufType() != Type.BYTES)) continue;
            int trackedFieldsSize = trackedFields.size();
            if (trackedFieldsSize % 64 == 0) {
                iw.append("long __bits$").append(String.valueOf(trackedFieldsSize >> 6)).append(" = 0;\n");
            }
            trackedFields.put(fieldMetadata.getName(), trackedFieldsSize);
        }
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            if (fieldMetadata.isRepeated()) {
                iw.append(fieldMetadata.getCollectionImplementation().getCanonicalName()).append(' ').append(this.makeCollectionLocalVar(fieldMetadata)).append(" = ");
                if (fieldMetadata.isArray()) {
                    iw.append("null");
                } else {
                    iw.append("new ").append(fieldMetadata.getCollectionImplementation().getCanonicalName()).append("()");
                }
                iw.append(";\n");
                if (isMutableMessage || !fieldMetadata.isArray()) continue;
                iw.append(fieldMetadata.getJavaTypeName()).append("[] ").append(this.makeArrayLocalVar(fieldMetadata)).append(" = ");
                iw.append("new ").append(fieldMetadata.getJavaTypeName()).append("[0]");
                iw.append(";\n");
                continue;
            }
            if (isMutableMessage) continue;
            iw.append(fieldMetadata.getJavaTypeName()).append(' ').append(this.makeFieldLocalVar(fieldMetadata));
            Object defaultValue = fieldMetadata.getDefaultValue();
            if (defaultValue != null && fieldMetadata.getProtobufType() != Type.BYTES) {
                val = this.toJavaLiteral(defaultValue, fieldMetadata.getJavaType());
                iw.append(" = ").append(this.box(val, fieldMetadata.getJavaType()));
            } else if (fieldMetadata.isBoxedPrimitive() || fieldMetadata.getProtobufType() == Type.BYTES || fieldMetadata.getProtobufType().getJavaType() == JavaType.STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.BYTE_STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.ENUM || fieldMetadata.getProtobufType().getJavaType() == JavaType.MESSAGE) {
                iw.append(" = null");
            }
            iw.append(";\n");
        }
        iw.append("boolean done = false;\n");
        iw.append("while (!done) {\n");
        iw.inc();
        iw.append("final int tag = $2.readTag();\n");
        iw.append("switch (tag) {\n");
        iw.inc();
        iw.append("case 0:\n");
        iw.inc();
        iw.append("done = true;\nbreak;\n");
        iw.dec();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            String v = this.makeFieldLocalVar(fieldMetadata);
            iw.append("case ").append(String.valueOf(fieldMetadata.getNumber() << 3 | fieldMetadata.getProtobufType().getWireType())).append(": {\n");
            iw.inc();
            if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
                iw.append("// type = ").append(fieldMetadata.getProtobufType().toString()).append(", name = ").append(fieldMetadata.getName()).append('\n');
            }
            switch (fieldMetadata.getProtobufType()) {
                case DOUBLE: 
                case FLOAT: 
                case INT64: 
                case UINT64: 
                case INT32: 
                case FIXED64: 
                case FIXED32: 
                case BOOL: 
                case STRING: 
                case BYTES: 
                case UINT32: 
                case SFIXED32: 
                case SFIXED64: 
                case SINT32: 
                case SINT64: {
                    if (isMutableMessage || fieldMetadata.isRepeated()) {
                        iw.append(fieldMetadata.getJavaTypeName()).append(' ');
                    }
                    iw.append(v).append(" = ").append(this.box(this.convert("$2." + this.makeStreamIOMethodName(fieldMetadata, false) + "()", fieldMetadata), fieldMetadata.getJavaType())).append(";\n");
                    this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                    break;
                }
                case GROUP: {
                    this.initMarshallerDelegateField(iw, fieldMetadata);
                    if (isMutableMessage || fieldMetadata.isRepeated()) {
                        iw.append(fieldMetadata.getJavaTypeName()).append(' ');
                    }
                    iw.append(v).append(" = (").append(fieldMetadata.getJavaTypeName()).append(") readMessage(").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(", $2);\n");
                    iw.append("$2.checkLastTagWas(").append(String.valueOf(fieldMetadata.getNumber() << 3 | 4)).append(");\n");
                    this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                    break;
                }
                case MESSAGE: {
                    this.initMarshallerDelegateField(iw, fieldMetadata);
                    iw.append("int length = $2.readRawVarint32();\n");
                    iw.append("int oldLimit = $2.pushLimit(length);\n");
                    if (isMutableMessage || fieldMetadata.isRepeated()) {
                        iw.append(fieldMetadata.getJavaTypeName()).append(' ');
                    }
                    iw.append(v).append(" = (").append(fieldMetadata.getJavaTypeName()).append(") readMessage(").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(", $2);\n");
                    iw.append("$2.checkLastTagWas(0);\n");
                    iw.append("$2.popLimit(oldLimit);\n");
                    this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                    break;
                }
                case ENUM: {
                    this.initMarshallerDelegateField(iw, fieldMetadata);
                    iw.append("int enumVal = $2.readEnum();\n");
                    if (isMutableMessage || fieldMetadata.isRepeated()) {
                        iw.append(fieldMetadata.getJavaTypeName()).append(' ');
                    }
                    iw.append(v).append(" = (").append(fieldMetadata.getJavaTypeName()).append(") ((").append(PROTOSTREAM_PACKAGE).append(".EnumMarshaller) $1.getMarshaller(").append(fieldMetadata.getJavaTypeName()).append(".class)).decode(enumVal);\n");
                    iw.append("if (").append(v).append(" == null) {\n");
                    if (getUnknownFieldSetFieldStatement != null) {
                        iw.inc();
                        iw.append(PROTOSTREAM_PACKAGE).append(".UnknownFieldSet u = ").append(getUnknownFieldSetFieldStatement).append(";\n");
                        iw.append("if (u == null) { u = new ").append(PROTOSTREAM_PACKAGE).append(".impl.UnknownFieldSetImpl(); ").append(setUnknownFieldSetFieldStatement).append("; }\n");
                        iw.append("u.putVarintField(").append(String.valueOf(fieldMetadata.getNumber())).append(", enumVal);\n");
                        iw.dec();
                    }
                    iw.append("} else {\n").inc();
                    this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                    iw.dec().append("}\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type : " + (Object)((Object)fieldMetadata.getProtobufType()));
                }
            }
            iw.append("break;\n");
            iw.dec();
            iw.append("}\n");
        }
        iw.append("default: {\n");
        iw.inc();
        if (getUnknownFieldSetFieldStatement != null) {
            iw.append(PROTOSTREAM_PACKAGE).append(".UnknownFieldSet u = ").append(getUnknownFieldSetFieldStatement).append(";\n");
            iw.append("if (u == null) u = new ").append(PROTOSTREAM_PACKAGE).append(".impl.UnknownFieldSetImpl();\n");
            iw.append("if (!u.readSingleField(tag, $2)) done = true;\n");
            iw.append("if (!u.isEmpty()) ").append(setUnknownFieldSetFieldStatement).append(";\n");
        } else {
            iw.append("if (!$2.skipField(tag)) done = true;\n");
        }
        iw.dec().append("}\n");
        iw.dec().append("}\n");
        iw.dec().append("}\n");
        if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
            iw.append("\n// default values\n\n");
        }
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            Object defaultValue = fieldMetadata.getDefaultValue();
            if (defaultValue == null || !isMutableMessage && !fieldMetadata.isRepeated() && fieldMetadata.getProtobufType() != Type.BYTES) continue;
            iw.append("if ").append(this.makeTestFieldWasNotSet(fieldMetadata, trackedFields)).append(" {\n");
            iw.inc();
            val = this.toJavaLiteral(defaultValue, fieldMetadata.getJavaType());
            if (fieldMetadata.isRepeated()) {
                String c = this.makeCollectionLocalVar(fieldMetadata);
                if (fieldMetadata.isArray()) {
                    iw.append("if (").append(c).append(" == null) ").append(c).append(" = new ").append(fieldMetadata.getCollectionImplementation().getCanonicalName()).append("();\n");
                }
                iw.append(c).append(".add(").append(this.box(val, this.typeFactory.fromClass(defaultValue.getClass()))).append(");\n");
            } else if (isMutableMessage) {
                iw.append("o.").append(this.createSetPropExpr(fieldMetadata, this.box(val, fieldMetadata.getJavaType()))).append(";\n");
            } else {
                iw.append(this.makeFieldLocalVar(fieldMetadata)).append(" = ").append(this.box(val, fieldMetadata.getJavaType())).append(";\n");
            }
            iw.dec();
            iw.append("}\n");
        }
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            if (!fieldMetadata.isRepeated()) continue;
            String c = this.makeCollectionLocalVar(fieldMetadata);
            if (fieldMetadata.isArray()) {
                if (fieldMetadata.getDefaultValue() == null) {
                    iw.append("if (").append(c).append(" != null) ");
                }
                iw.append("{\n").inc();
                String a = this.makeArrayLocalVar(fieldMetadata);
                if (fieldMetadata.getJavaType().isPrimitive()) {
                    if (isMutableMessage) {
                        iw.append(fieldMetadata.getJavaTypeName()).append("[] ");
                    }
                    iw.append(a).append(" = new ").append(fieldMetadata.getJavaTypeName()).append("[").append(c).append(".size()];\n");
                    XClass boxedType = this.box(fieldMetadata.getJavaType());
                    iw.append("int _j = 0;\nfor (java.util.Iterator _it = ").append(c).append(".iterator(); _it.hasNext();) ").append(a).append("[_j++] = ").append(this.unbox("((" + boxedType.getName() + ") _it.next())", boxedType)).append(";\n");
                    c = a;
                } else {
                    c = "(" + fieldMetadata.getJavaTypeName() + "[])" + c + ".toArray(new " + fieldMetadata.getJavaTypeName() + "[0])";
                }
            }
            if (isMutableMessage) {
                iw.append("o.").append(this.createSetPropExpr(fieldMetadata, c)).append(";\n");
            } else if (fieldMetadata.isArray() && !fieldMetadata.getJavaType().isPrimitive()) {
                iw.append(this.makeArrayLocalVar(fieldMetadata)).append(" = ").append(c).append(";\n");
            }
            if (fieldMetadata.isArray()) {
                iw.dec().append('}');
                if (fieldMetadata.getDefaultValue() == null) {
                    c = "new " + fieldMetadata.getJavaTypeName() + "[0]";
                    iw.append(" else {\n").inc();
                    if (isMutableMessage) {
                        iw.append("o.").append(this.createSetPropExpr(fieldMetadata, c)).append(";\n");
                    } else {
                        iw.append(this.makeArrayLocalVar(fieldMetadata)).append(" = ").append(c).append(";\n");
                    }
                    iw.dec().append("}\n");
                }
            }
            iw.append('\n');
        }
        if (mandatoryFields > 0) {
            List<ProtoFieldMetadata> mandatory = messageTypeMetadata.getFields().values().stream().filter(f -> f.isRequired() && f.getDefaultValue() == null).collect(Collectors.toList());
            iw.append("if (").append(this.makeTestFieldWasNotSet(mandatory, trackedFields)).append(") {\n");
            iw.inc();
            iw.append("final StringBuilder missing = new StringBuilder();\n");
            boolean first = true;
            for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
                if (!fieldMetadata.isRequired()) continue;
                iw.append("if ").append(this.makeTestFieldWasNotSet(fieldMetadata, trackedFields)).append(" {\n");
                iw.inc();
                if (first) {
                    first = false;
                } else {
                    iw.append("if (missing.length() > 0) missing.append(\", \");\n");
                }
                iw.append("missing.append(\"").append(fieldMetadata.getName()).append("\");\n");
                iw.dec();
                iw.append("}\n");
            }
            iw.append("throw new java.io.IOException(\"Required field(s) missing from input stream : \" + missing);\n");
            iw.dec();
            iw.append("}\n");
        }
        if (isMutableMessage) {
            iw.append("return o;\n");
        } else {
            iw.append("return ");
            XExecutable factory = messageTypeMetadata.getFactory();
            if (factory instanceof XConstructor) {
                iw.append("new ").append(messageTypeMetadata.getJavaClassName());
            } else {
                iw.append(messageTypeMetadata.getJavaClassName()).append('.').append(factory.getName());
            }
            iw.append('(');
            boolean first = true;
            for (String paramName : factory.getParameterNames()) {
                if (first) {
                    first = false;
                } else {
                    iw.append(", ");
                }
                boolean found = false;
                for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
                    if (!fieldMetadata.getPropertyName().equals(paramName)) continue;
                    String var = fieldMetadata.isRepeated() ? (fieldMetadata.isArray() ? this.makeArrayLocalVar(fieldMetadata) : this.makeCollectionLocalVar(fieldMetadata)) : this.makeFieldLocalVar(fieldMetadata);
                    iw.append(var);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ProtoSchemaBuilderException("Parameter '" + paramName + "' of factory " + factory + " does not map to any Protobuf field");
            }
            iw.append(");\n");
        }
        iw.dec().append("}\n");
        return iw.toString();
    }

    private String toJavaLiteral(Object value, XClass javaType) {
        String v;
        if (javaType.isAssignableTo(this.typeFactory.fromClass(Date.class))) {
            v = value + "L";
        } else if (javaType.isAssignableTo(this.typeFactory.fromClass(Instant.class))) {
            v = value + "L";
        } else if (value instanceof ProtoEnumValueMetadata) {
            v = ((ProtoEnumValueMetadata)value).getJavaEnumName();
        } else if (value instanceof Long) {
            v = value + "L";
        } else if (value instanceof Double) {
            v = value + "D";
        } else if (value instanceof Float) {
            v = value + "F";
        } else if (value instanceof Character) {
            v = "'" + value + "'";
        } else if (value instanceof String) {
            v = "\"" + value + "\"";
        } else if (value instanceof Short) {
            v = "(short) " + value;
        } else if (value instanceof Byte) {
            v = "(byte) " + value;
        } else if (value instanceof byte[]) {
            StringBuilder sb = new StringBuilder();
            sb.append("new byte[] {");
            byte[] bytes = (byte[])value;
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(bytes[i]);
            }
            sb.append('}');
            v = sb.toString();
        } else {
            v = value.toString();
        }
        return v;
    }

    private void genSetField(IndentWriter iw, ProtoFieldMetadata fieldMetadata, Map<String, Integer> trackedFields, ProtoMessageTypeMetadata messageTypeMetadata) {
        String v = this.makeFieldLocalVar(fieldMetadata);
        if (fieldMetadata.isRepeated()) {
            String c = this.makeCollectionLocalVar(fieldMetadata);
            if (fieldMetadata.isArray()) {
                iw.append("if (").append(c).append(" == null) ").append(c).append(" = new ").append(fieldMetadata.getCollectionImplementation().getCanonicalName()).append("();\n");
            }
            iw.append(c).append(".add(").append(this.box(v, this.box(fieldMetadata.getJavaType()))).append(");\n");
        } else if (messageTypeMetadata.getFactory() == null) {
            iw.append("o.").append(this.createSetPropExpr(fieldMetadata, v)).append(";\n");
        }
        if (trackedFields.containsKey(fieldMetadata.getName())) {
            iw.append(this.makeFieldWasSet(fieldMetadata, trackedFields)).append(";\n");
        }
    }

    protected String generateWriteToMethodBody(ProtoMessageTypeMetadata messageTypeMetadata) {
        String getUnknownFieldSetFieldStatement = null;
        if (messageTypeMetadata.getUnknownFieldSetField() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetField().getName();
        } else if (messageTypeMetadata.getUnknownFieldSetGetter() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetGetter().getName() + "()";
        } else if (messageTypeMetadata.getJavaClass().isAssignableTo(this.typeFactory.fromClass(Message.class))) {
            getUnknownFieldSetFieldStatement = "o.getUnknownFieldSet()";
        }
        IndentWriter iw = new IndentWriter();
        iw.append("{\n");
        iw.inc();
        iw.append("final ").append(messageTypeMetadata.getJavaClassName()).append(" o = (").append(messageTypeMetadata.getJavaClassName()).append(") $3;\n");
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            iw.append("{\n");
            iw.inc();
            if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
                iw.append("// type = ").append(fieldMetadata.getProtobufType().toString()).append(", name = ").append(fieldMetadata.getName()).append('\n');
            }
            String v = this.makeFieldLocalVar(fieldMetadata);
            String f = fieldMetadata.isRepeated() ? (fieldMetadata.isArray() ? this.makeArrayLocalVar(fieldMetadata) : this.makeCollectionLocalVar(fieldMetadata)) : v;
            iw.append("final ");
            if (fieldMetadata.isRepeated()) {
                if (fieldMetadata.isArray()) {
                    iw.append(fieldMetadata.getJavaTypeName()).append("[]");
                } else {
                    iw.append("java.util.Collection");
                }
            } else {
                iw.append(fieldMetadata.getJavaTypeName());
            }
            iw.append(' ').append(f).append(" = ").append(this.createGetPropExpr(fieldMetadata, "o")).append(";\n");
            if (fieldMetadata.isRequired()) {
                boolean couldBeNull;
                boolean bl = couldBeNull = fieldMetadata.isRepeated() || fieldMetadata.isBoxedPrimitive() || fieldMetadata.getProtobufType() == Type.BYTES || fieldMetadata.getProtobufType().getJavaType() == JavaType.STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.BYTE_STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.ENUM || fieldMetadata.getProtobufType().getJavaType() == JavaType.MESSAGE;
                if (couldBeNull) {
                    iw.append("if (").append(f).append(" == null) throw new IllegalStateException(\"Required field must not be null : ").append(fieldMetadata.getName()).append("\");\n");
                }
            } else if (!fieldMetadata.getJavaType().isPrimitive() || fieldMetadata.isRepeated()) {
                iw.append("if (").append(f).append(" != null) ");
            }
            if (fieldMetadata.isRepeated()) {
                iw.append('\n');
                iw.inc();
                if (fieldMetadata.isArray()) {
                    iw.append("for (int i = 0; i < ").append(f).append(".length; i++) {\n");
                    iw.inc();
                    iw.append("final ").append(fieldMetadata.getJavaTypeName()).append(' ').append(v).append(" = ").append(f).append("[i];\n");
                } else {
                    iw.append("for (java.util.Iterator it = ").append(f).append(".iterator(); it.hasNext(); ) {\n");
                    iw.inc();
                    iw.append("final ").append(fieldMetadata.getJavaTypeName()).append(' ').append(v).append(" = (").append(fieldMetadata.getJavaTypeName()).append(") it.next();\n");
                }
            }
            switch (fieldMetadata.getProtobufType()) {
                case DOUBLE: 
                case FLOAT: 
                case INT64: 
                case UINT64: 
                case INT32: 
                case FIXED64: 
                case FIXED32: 
                case BOOL: 
                case STRING: 
                case BYTES: 
                case UINT32: 
                case SFIXED32: 
                case SFIXED64: 
                case SINT32: 
                case SINT64: {
                    iw.append("$2.").append(this.makeStreamIOMethodName(fieldMetadata, true)).append("(").append(String.valueOf(fieldMetadata.getNumber())).append(", ").append(this.unbox(v, fieldMetadata.getJavaType())).append(");\n");
                    break;
                }
                case GROUP: {
                    iw.append("{\n");
                    iw.inc();
                    this.initMarshallerDelegateField(iw, fieldMetadata);
                    iw.append("$2.writeTag(").append(String.valueOf(fieldMetadata.getNumber())).append(", ").append(PROTOSTREAM_PACKAGE).append(".impl.WireFormat.WIRETYPE_START_GROUP);\n");
                    iw.append("writeMessage(").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(", $2, ").append(v).append(");\n");
                    iw.append("$2.writeTag(").append(String.valueOf(fieldMetadata.getNumber())).append(", ").append(PROTOSTREAM_PACKAGE).append(".impl.WireFormat.WIRETYPE_END_GROUP);\n");
                    iw.dec();
                    iw.append("}\n");
                    break;
                }
                case MESSAGE: {
                    iw.append("{\n");
                    iw.inc();
                    this.initMarshallerDelegateField(iw, fieldMetadata);
                    iw.append("writeNestedMessage(").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(", $2, ").append(String.valueOf(fieldMetadata.getNumber())).append(", ").append(v).append(");\n");
                    iw.dec();
                    iw.append("}\n");
                    break;
                }
                case ENUM: {
                    iw.append("{\n");
                    iw.inc();
                    this.initMarshallerDelegateField(iw, fieldMetadata);
                    iw.append("$2.writeEnum(").append(String.valueOf(fieldMetadata.getNumber())).append(", ").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(".getMarshaller().encode(").append(v).append("));\n");
                    iw.dec();
                    iw.append("}\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type : " + (Object)((Object)fieldMetadata.getProtobufType()));
                }
            }
            if (fieldMetadata.isRepeated()) {
                iw.dec();
                iw.append("}\n");
                iw.dec();
            }
            iw.dec();
            iw.append("}\n");
        }
        if (getUnknownFieldSetFieldStatement != null) {
            iw.append("{\n").inc();
            iw.append(PROTOSTREAM_PACKAGE).append(".UnknownFieldSet u = ").append(getUnknownFieldSetFieldStatement).append(";\n");
            iw.append("if (u != null && !u.isEmpty()) u.writeTo($2);\n");
            iw.dec().append("}\n");
        }
        iw.dec();
        iw.append("}\n");
        return iw.toString();
    }

    private void initMarshallerDelegateField(IndentWriter iw, ProtoFieldMetadata fieldMetadata) {
        iw.append("if (").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(" == null) ").append(this.makeMarshallerDelegateFieldName(fieldMetadata)).append(" = ");
        if (fieldMetadata.getJavaType().isEnum()) {
            iw.append("(").append(PROTOSTREAM_PACKAGE).append(".impl.EnumMarshallerDelegate) ");
        }
        iw.append("((").append(PROTOSTREAM_PACKAGE).append(".impl.SerializationContextImpl) $1).getMarshallerDelegate(").append(fieldMetadata.getJavaTypeName()).append(".class);\n");
    }

    private String makeStreamIOMethodName(ProtoFieldMetadata fieldMetadata, boolean isWrite) {
        String suffix;
        switch (fieldMetadata.getProtobufType()) {
            case DOUBLE: {
                suffix = "Double";
                break;
            }
            case FLOAT: {
                suffix = "Float";
                break;
            }
            case INT64: {
                suffix = "Int64";
                break;
            }
            case UINT64: {
                suffix = "UInt64";
                break;
            }
            case INT32: {
                suffix = "Int32";
                break;
            }
            case FIXED64: {
                suffix = "Fixed64";
                break;
            }
            case FIXED32: {
                suffix = "Fixed32";
                break;
            }
            case BOOL: {
                suffix = "Bool";
                break;
            }
            case STRING: {
                suffix = "String";
                break;
            }
            case GROUP: {
                suffix = "Group";
                break;
            }
            case MESSAGE: {
                suffix = "Message";
                break;
            }
            case BYTES: {
                suffix = isWrite ? "Bytes" : "ByteArray";
                break;
            }
            case UINT32: {
                suffix = "UInt32";
                break;
            }
            case ENUM: {
                suffix = "Enum";
                break;
            }
            case SFIXED32: {
                suffix = "SFixed32";
                break;
            }
            case SFIXED64: {
                suffix = "SFixed64";
                break;
            }
            case SINT32: {
                suffix = "SInt32";
                break;
            }
            case SINT64: {
                suffix = "SInt64";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown field type : " + (Object)((Object)fieldMetadata.getProtobufType()));
            }
        }
        return (isWrite ? "write" : "read") + suffix;
    }

    private String convert(String v, ProtoFieldMetadata fieldMetadata) {
        if (fieldMetadata.getJavaType() == this.typeFactory.fromClass(Character.class) || fieldMetadata.getJavaType() == this.typeFactory.fromClass(Character.TYPE)) {
            return "(char) " + v;
        }
        if (fieldMetadata.getJavaType() == this.typeFactory.fromClass(Short.class) || fieldMetadata.getJavaType() == this.typeFactory.fromClass(Short.TYPE)) {
            return "(short) " + v;
        }
        if (fieldMetadata.getJavaType() == this.typeFactory.fromClass(Byte.class) || fieldMetadata.getJavaType() == this.typeFactory.fromClass(Byte.TYPE)) {
            return "(byte) " + v;
        }
        return v;
    }

    private XClass box(XClass clazz) {
        if (clazz == this.typeFactory.fromClass(Float.TYPE)) {
            return this.typeFactory.fromClass(Float.class);
        }
        if (clazz == this.typeFactory.fromClass(Double.TYPE)) {
            return this.typeFactory.fromClass(Double.class);
        }
        if (clazz == this.typeFactory.fromClass(Boolean.TYPE)) {
            return this.typeFactory.fromClass(Boolean.class);
        }
        if (clazz == this.typeFactory.fromClass(Long.TYPE)) {
            return this.typeFactory.fromClass(Long.class);
        }
        if (clazz == this.typeFactory.fromClass(Integer.TYPE)) {
            return this.typeFactory.fromClass(Integer.class);
        }
        if (clazz == this.typeFactory.fromClass(Short.TYPE)) {
            return this.typeFactory.fromClass(Short.class);
        }
        if (clazz == this.typeFactory.fromClass(Byte.TYPE)) {
            return this.typeFactory.fromClass(Byte.class);
        }
        if (clazz == this.typeFactory.fromClass(Character.TYPE)) {
            return this.typeFactory.fromClass(Character.class);
        }
        return null;
    }

    private String box(String v, XClass clazz) {
        if (clazz != null) {
            if (clazz.isAssignableTo(this.typeFactory.fromClass(Date.class))) {
                XConstructor ctor = clazz.getDeclaredConstructor(this.typeFactory.fromClass(Long.TYPE));
                if (ctor == null || !ctor.isPublic()) {
                    throw new ProtoSchemaBuilderException("Type " + clazz.getCanonicalName() + " is not a valid Date type because it does not have an accessible constructor that accepts a 'long' timestamp parameter");
                }
                return "new " + clazz.getName() + "(" + v + ")";
            }
            if (clazz.isAssignableTo(this.typeFactory.fromClass(Instant.class))) {
                return "java.time.Instant.ofEpochMilli(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Float.class)) {
                return "new java.lang.Float(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Double.class)) {
                return "new java.lang.Double(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Boolean.class)) {
                return "new java.lang.Boolean(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Long.class)) {
                return "new java.lang.Long(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Integer.class)) {
                return "new java.lang.Integer(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Short.class)) {
                return "new java.lang.Short(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Byte.class)) {
                return "new java.lang.Byte(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Character.class)) {
                return "new java.lang.Character(" + v + ")";
            }
        }
        return v;
    }

    private String unbox(String v, XClass clazz) {
        if (clazz.isAssignableTo(this.typeFactory.fromClass(Date.class))) {
            return v + ".getTime()";
        }
        if (clazz.isAssignableTo(this.typeFactory.fromClass(Instant.class))) {
            return v + ".toEpochMilli()";
        }
        if (clazz == this.typeFactory.fromClass(Float.class)) {
            return v + ".floatValue()";
        }
        if (clazz == this.typeFactory.fromClass(Double.class)) {
            return v + ".doubleValue()";
        }
        if (clazz == this.typeFactory.fromClass(Boolean.class)) {
            return v + ".booleanValue()";
        }
        if (clazz == this.typeFactory.fromClass(Long.class)) {
            return v + ".longValue()";
        }
        if (clazz == this.typeFactory.fromClass(Integer.class)) {
            return v + ".intValue()";
        }
        if (clazz == this.typeFactory.fromClass(Short.class)) {
            return v + ".shortValue()";
        }
        if (clazz == this.typeFactory.fromClass(Byte.class)) {
            return v + ".byteValue()";
        }
        if (clazz == this.typeFactory.fromClass(Character.class)) {
            return v + ".charValue()";
        }
        return v;
    }

    private String createGetPropExpr(ProtoFieldMetadata fieldMetadata, String obj) {
        boolean isJUOptional;
        StringBuilder readPropExpr = new StringBuilder();
        boolean bl = isJUOptional = fieldMetadata.getGetter() != null && fieldMetadata.getGetter().getReturnType() == this.typeFactory.fromClass(Optional.class);
        if (!(!isJUOptional && fieldMetadata.getProtobufType().getJavaType() != JavaType.MESSAGE && fieldMetadata.getProtobufType().getJavaType() != JavaType.ENUM || !fieldMetadata.isArray() && fieldMetadata.isRepeated())) {
            readPropExpr.append("(").append(fieldMetadata.getJavaTypeName());
            if (fieldMetadata.isArray()) {
                readPropExpr.append("[]");
            }
            readPropExpr.append(") ");
        }
        if (fieldMetadata.getField() != null) {
            readPropExpr.append(obj).append('.').append(fieldMetadata.getField().getName());
        } else {
            if (isJUOptional) {
                readPropExpr.append('(');
            }
            readPropExpr.append(obj).append('.').append(fieldMetadata.getGetter().getName()).append("()");
            if (isJUOptional) {
                readPropExpr.append(".isPresent() ? ").append(obj).append('.').append(fieldMetadata.getGetter().getName()).append("().get() : null)");
            }
        }
        return readPropExpr.toString();
    }

    private String createSetPropExpr(ProtoFieldMetadata fieldMetadata, String value) {
        if (fieldMetadata.getField() != null) {
            return fieldMetadata.getField().getName() + " = " + value;
        }
        return fieldMetadata.getSetter().getName() + '(' + value + ')';
    }

    public abstract void generateMarshaller(SerializationContext var1, ProtoTypeMetadata var2) throws Exception;
}

