/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.impl.Log;

public abstract class BaseProtoSchemaGenerator {
    private static final Log log = Log.LogFactory.getLog(BaseProtoSchemaGenerator.class);
    public static boolean generateSchemaDebugComments = false;
    public static boolean generateMarshallerDebugComments = false;
    protected final XTypeFactory typeFactory;
    protected final SerializationContext serializationContext;
    protected final String fileName;
    protected final String generator;
    protected final String packageName;
    protected final Set<XClass> classes;
    protected final boolean autoImportClasses;
    private final Set<XClass> knownClasses = new HashSet<XClass>();
    private final Set<String> imports = new HashSet<String>();
    private final Map<XClass, ProtoTypeMetadata> metadataByClass = new HashMap<XClass, ProtoTypeMetadata>();
    private final Map<String, ProtoTypeMetadata> metadataByTypeName = new HashMap<String, ProtoTypeMetadata>();

    protected BaseProtoSchemaGenerator(XTypeFactory typeFactory, SerializationContext serializationContext, String generator, String fileName, String packageName, Set<XClass> classes, boolean autoImportClasses) {
        if (fileName == null) {
            throw new ProtoSchemaBuilderException("fileName cannot be null");
        }
        this.typeFactory = typeFactory;
        this.serializationContext = serializationContext;
        this.generator = generator;
        this.fileName = fileName;
        this.packageName = packageName;
        this.classes = classes;
        this.autoImportClasses = autoImportClasses;
    }

    public String generateAndRegister() throws ProtoSchemaBuilderException {
        ProtoTypeMetadata m;
        ArrayList<ProtoTypeMetadata> meta;
        if (!this.autoImportClasses) {
            for (XClass xClass : this.classes) {
                this.collectKnownClasses(xClass);
            }
        }
        for (XClass xClass : this.classes) {
            this.defineMetadata(this.makeProtoTypeMetadata(xClass));
        }
        do {
            meta = new ArrayList<ProtoTypeMetadata>(this.metadataByClass.values());
            Iterator iterator = meta.iterator();
            while (iterator.hasNext()) {
                m = (ProtoTypeMetadata)iterator.next();
                m.scanMemberAnnotations();
            }
        } while (this.metadataByClass.size() != meta.size());
        for (XClass xClass : this.metadataByClass.keySet()) {
            ProtoMessageTypeMetadata outer;
            m = this.metadataByClass.get(xClass);
            if (m.isImported() || (outer = this.findOuterType(xClass)) == null) continue;
            m.setOuterType(outer);
            outer.addInnerType(m);
        }
        IndentWriter iw = new IndentWriter();
        iw.append("// File name: ").append(this.fileName).append('\n');
        if (this.generator != null) {
            iw.append("// Generated from : ").append(this.generator).append('\n');
        }
        if (generateSchemaDebugComments) {
            iw.append("// Scanned classes:\n");
            for (ProtoTypeMetadata ptm : this.metadataByClass.values()) {
                if (ptm.isImported()) continue;
                iw.append("//   ").append(ptm.getJavaClassName()).append('\n');
            }
        }
        iw.append("\nsyntax = \"proto2\";\n\n");
        if (this.packageName != null) {
            iw.append("package ").append(this.packageName).append(";\n\n");
        }
        for (String dependency : this.imports) {
            iw.append("import \"").append(dependency).append("\";\n");
        }
        for (XClass c : this.metadataByClass.keySet()) {
            ProtoTypeMetadata m2 = this.metadataByClass.get(c);
            if (m2.getOuterType() != null || m2.isImported()) continue;
            m2.generateProto(iw);
        }
        String string = iw.toString();
        if (log.isTraceEnabled()) {
            log.tracef("Generated proto file:\n%s", (Object)string);
        }
        this.serializationContext.registerProtoFiles(FileDescriptorSource.fromString(this.fileName, string));
        try {
            this.generateMarshallers();
        }
        catch (Exception e) {
            throw new ProtoSchemaBuilderException("Failed to generate marshaller implementation class", (Throwable)e);
        }
        return string;
    }

    private ProtoMessageTypeMetadata findOuterType(XClass c) {
        ProtoTypeMetadata outer = null;
        for (XClass ec = c.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
            if (ec.isEnum()) {
                throw new ProtoSchemaBuilderException("Classes defined inside an Enum are not allowed : " + c.getCanonicalName());
            }
            outer = this.metadataByClass.get(ec);
            if (outer != null) break;
        }
        return (ProtoMessageTypeMetadata)outer;
    }

    private void generateMarshallers() throws Exception {
        AbstractMarshallerCodeGenerator marshallerCodeGenerator = this.makeCodeGenerator();
        for (XClass c : this.metadataByClass.keySet()) {
            ProtoTypeMetadata ptm = this.metadataByClass.get(c);
            if (ptm.isImported()) continue;
            marshallerCodeGenerator.generateMarshaller(this.serializationContext, ptm);
        }
    }

    public Set<XClass> getMarshalledClasses() {
        return this.metadataByClass.entrySet().stream().filter(e -> !((ProtoTypeMetadata)e.getValue()).isImported()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    protected abstract AbstractMarshallerCodeGenerator makeCodeGenerator();

    protected ProtoTypeMetadata scanAnnotations(XClass javaType) {
        ProtoTypeMetadata protoTypeMetadata = this.metadataByClass.get(javaType);
        if (protoTypeMetadata != null) {
            return protoTypeMetadata;
        }
        protoTypeMetadata = this.importProtoTypeMetadata(javaType);
        if (protoTypeMetadata != null) {
            this.imports.add(protoTypeMetadata.getFileName());
        } else {
            protoTypeMetadata = this.makeProtoTypeMetadata(javaType);
        }
        this.defineMetadata(protoTypeMetadata);
        return protoTypeMetadata;
    }

    protected abstract ProtoTypeMetadata importProtoTypeMetadata(XClass var1);

    protected ProtoTypeMetadata makeProtoTypeMetadata(XClass javaType) {
        return javaType.isEnum() ? new ProtoEnumTypeMetadata(javaType) : new ProtoMessageTypeMetadata(this, javaType);
    }

    private void defineMetadata(ProtoTypeMetadata protoTypeMetadata) {
        boolean isUnknownClass = this.isUnknownClass(protoTypeMetadata.getJavaClass());
        if (!this.autoImportClasses && !protoTypeMetadata.isImported() && isUnknownClass) {
            throw new ProtoSchemaBuilderException("Found a reference to class " + protoTypeMetadata.getJavaClassName() + " which was not explicitly added to the builder and 'autoImportClasses' is disabled.");
        }
        String fullName = protoTypeMetadata.getFullName();
        ProtoTypeMetadata existing = this.metadataByTypeName.get(fullName);
        if (existing != null) {
            throw new ProtoSchemaBuilderException("Found a duplicate type definition. Type '" + fullName + "' is defined by " + protoTypeMetadata.getJavaClassName() + " and also by " + existing.getJavaClassName());
        }
        this.metadataByTypeName.put(fullName, protoTypeMetadata);
        this.metadataByClass.put(protoTypeMetadata.getJavaClass(), protoTypeMetadata);
    }

    protected boolean isUnknownClass(XClass c) {
        boolean isKnown;
        while (!(isKnown = this.knownClasses.contains(c)) && (c = c.getEnclosingClass()) != null) {
        }
        return !isKnown;
    }

    private void collectKnownClasses(XClass c) {
        this.knownClasses.add(c);
        if (c.getSuperclass() != null) {
            this.collectKnownClasses(c.getSuperclass());
        }
        for (XClass i : c.getInterfaces()) {
            this.collectKnownClasses(i);
        }
    }
}

