/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.Process;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.impl.ContextContainerImpl;
import org.kie.api.definition.KieDefinition;
import org.kie.api.io.Resource;

public class ProcessImpl
implements Process,
Serializable,
ContextResolver {
    private static final long serialVersionUID = 510L;
    private String id;
    private String name;
    private String version;
    private String type;
    private String visibility;
    private String packageName;
    private Resource resource;
    private ContextContainer contextContainer = new ContextContainerImpl();
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private transient Map<String, Object> runtimeMetaData = new HashMap<String, Object>();
    private Set<String> imports = new HashSet<String>();
    private Map<String, String> globals;
    private List<String> functionImports;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        if ("None".equals(visibility)) {
            visibility = "Public";
        }
        this.visibility = visibility;
    }

    @Override
    public List<Context> getContexts(String contextType) {
        return this.contextContainer.getContexts(contextType);
    }

    @Override
    public void addContext(Context context) {
        this.contextContainer.addContext(context);
        ((AbstractContext)context).setContextContainer(this);
    }

    @Override
    public Context getContext(String contextType, long id) {
        return this.contextContainer.getContext(contextType, id);
    }

    @Override
    public void setDefaultContext(Context context) {
        this.contextContainer.setDefaultContext(context);
        ((AbstractContext)context).setContextContainer(this);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.contextContainer.getDefaultContext(contextType);
    }

    public boolean equals(Object o) {
        if (o instanceof ProcessImpl) {
            if (this.id == null) {
                return ((ProcessImpl)o).getId() == null;
            }
            return this.id.equals(((ProcessImpl)o).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : 3 * this.id.hashCode();
    }

    @Override
    public Context resolveContext(String contextId, Object param) {
        Context context = this.getDefaultContext(contextId);
        if (context != null && (context = context.resolveContext(param)) != null) {
            return context;
        }
        return null;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public void setMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    @Override
    public List<String> getFunctionImports() {
        return this.functionImports;
    }

    @Override
    public void setFunctionImports(List<String> functionImports) {
        this.functionImports = functionImports;
    }

    @Override
    public Map<String, String> getGlobals() {
        return this.globals;
    }

    @Override
    public void setGlobals(Map<String, String> globals) {
        this.globals = globals;
    }

    @Override
    public String[] getGlobalNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.globals != null) {
            Iterator<String> iterator = this.globals.keySet().iterator();
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public KieDefinition.KnowledgeType getKnowledgeType() {
        return KieDefinition.KnowledgeType.PROCESS;
    }

    @Override
    public String getNamespace() {
        return this.packageName;
    }

    public Map<String, Object> getRuntimeMetaData() {
        return this.runtimeMetaData;
    }

    public void setRuntimeMetaData(Map<String, Object> runtimeMetaData) {
        this.runtimeMetaData = runtimeMetaData;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.runtimeMetaData = new HashMap<String, Object>();
    }
}

