/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.DummyKnowledgeRuntime;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeContext;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeContext;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.jobs.impl.InMemoryJobService;

public class LightProcessRuntime
implements InternalProcessRuntime {
    private ProcessRuntimeContext runtimeContext;
    private final InternalKnowledgeRuntime knowledgeRuntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private JobsService jobService;
    private ProcessEventSupport processEventSupport;
    private final WorkItemManager workItemManager;
    private UnitOfWorkManager unitOfWorkManager;

    public static LightProcessRuntime ofProcess(Process p) {
        LightProcessRuntimeServiceProvider services = new LightProcessRuntimeServiceProvider();
        LightProcessRuntimeContext rtc = new LightProcessRuntimeContext(Collections.singletonList(p));
        return new LightProcessRuntime(rtc, services);
    }

    public LightProcessRuntime(ProcessRuntimeContext runtimeContext, ProcessRuntimeServiceProvider services) {
        this.unitOfWorkManager = services.getUnitOfWorkManager();
        this.knowledgeRuntime = new DummyKnowledgeRuntime(this);
        this.runtimeContext = runtimeContext;
        this.processInstanceManager = services.getProcessInstanceManager();
        this.signalManager = services.getSignalManager();
        this.jobService = services.getJobsService() == null ? new InMemoryJobService(this, this.unitOfWorkManager) : services.getJobsService();
        this.processEventSupport = services.getEventSupport();
        this.workItemManager = services.getWorkItemManager();
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    public void initStartTimers() {
        Collection<Process> processes = this.runtimeContext.getProcesses();
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                this.jobService.scheduleProcessJob(ProcessJobDescription.of(this.createTimerInstance(startNode.getTimer(), this.knowledgeRuntime), p.getId()));
            }
        }
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.startProcess(processId, parameters, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId(), trigger);
        }
        return null;
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.createProcessInstance(processId, null, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(String processInstanceId, String trigger) {
        try {
            this.runtimeContext.startOperation();
            org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
            ((ProcessInstance)processInstance).configureSLA();
            this.getProcessEventSupport().fireBeforeProcessStarted(processInstance, this.knowledgeRuntime);
            ((ProcessInstance)processInstance).start(trigger);
            this.getProcessEventSupport().fireAfterProcessStarted(processInstance, this.knowledgeRuntime);
            org.kie.api.runtime.process.ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        finally {
            this.runtimeContext.endOperation();
        }
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(String processInstanceId) {
        return this.startProcessInstance(processInstanceId, null);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, correlationKey, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        try {
            this.runtimeContext.startOperation();
            Process process = this.runtimeContext.findProcess(processId).orElseThrow(() -> new IllegalArgumentException("Unknown process ID: " + processId));
            ProcessInstance processInstance = this.startProcess(process, correlationKey, parameters);
            return processInstance;
        }
        finally {
            this.runtimeContext.endOperation();
        }
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.processInstanceManager.getProcessInstance(correlationKey);
    }

    private ProcessInstance startProcess(Process process, CorrelationKey correlationKey, Map<String, Object> parameters) {
        ProcessInstance pi = this.runtimeContext.createProcessInstance(process, correlationKey);
        pi.setKnowledgeRuntime(this.knowledgeRuntime);
        this.runtimeContext.setupParameters(pi, parameters);
        this.processInstanceManager.addProcessInstance(pi, correlationKey);
        return pi;
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public JobsService getJobsService() {
        return this.jobService;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(String id) {
        return this.getProcessInstance(id, false);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(String id, boolean readOnly) {
        return this.processInstanceManager.getProcessInstance(id, readOnly);
    }

    public void removeProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    public void initProcessEventListeners() {
        for (Process process : this.runtimeContext.getProcesses()) {
            this.initProcessEventListener(process);
        }
    }

    public void removeProcessEventListeners() {
        for (Process process : this.runtimeContext.getProcesses()) {
            this.removeProcessEventListener(process);
        }
    }

    private void removeProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            String type = (String)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventType");
            StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventListener");
            if (type != null && listener != null) {
                this.signalManager.removeEventListener(type, listener);
            }
        }
    }

    private void initProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            for (Node node : ((RuleFlowProcess)process).getNodes()) {
                List<Trigger> triggers;
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node) == null || (triggers = startNode.getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                    String type = null;
                    for (EventFilter filter : filters) {
                        if (!(filter instanceof EventTypeFilter)) continue;
                        type = ((EventTypeFilter)filter).getType();
                    }
                    StartProcessEventListener listener = new StartProcessEventListener(process.getId(), filters, trigger.getInMappings(), startNode.getEventTransformer());
                    this.signalManager.addEventListener(type, listener);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventType", type);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventListener", listener);
                }
            }
        }
    }

    @Override
    public ProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    @Override
    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener(listener);
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    private void initProcessActivationListener() {
        this.runtimeContext.addEventListener(new DefaultAgendaEventListener(){

            @Override
            public void matchCreated(MatchCreatedEvent event) {
                String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlowStateNode-")) {
                        int index = ruleName.indexOf(45, 18);
                        index = ruleName.indexOf(45, index + 1);
                        String eventType = ruleName.substring(0, index);
                        LightProcessRuntime.this.runtimeContext.queueWorkingMemoryAction(new SignalManagerSignalAction(eventType, event));
                    } else if (ruleName.startsWith("RuleFlowStateEventSubProcess-") || ruleName.startsWith("RuleFlowStateEvent-") || ruleName.startsWith("RuleFlow-Milestone-") || ruleName.startsWith("RuleFlow-AdHocComplete-") || ruleName.startsWith("RuleFlow-AdHocActivate-")) {
                        LightProcessRuntime.this.runtimeContext.queueWorkingMemoryAction(new SignalManagerSignalAction(ruleName, event));
                    }
                } else {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlow-Start-")) {
                        String processId = ruleName.replace("RuleFlow-Start-", "");
                        LightProcessRuntime.this.startProcessWithParamsAndTrigger(processId, null, "conditional", true);
                    }
                }
            }
        });
        this.runtimeContext.addEventListener(new DefaultAgendaEventListener(){

            @Override
            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                if (LightProcessRuntime.this.runtimeContext instanceof StatefulKnowledgeSession) {
                    LightProcessRuntime.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)((Object)LightProcessRuntime.this.runtimeContext)).getIdentifier(), null);
                } else {
                    LightProcessRuntime.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                }
            }
        });
    }

    private void startProcessWithParamsAndTrigger(String processId, Map<String, Object> params, String type, boolean dispose) {
        this.startProcess(processId, params, type);
    }

    @Override
    public void abortProcessInstance(String processInstanceId) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        return this.workItemManager;
    }

    @Override
    public UnitOfWorkManager getUnitOfWorkManager() {
        return this.unitOfWorkManager;
    }

    @Override
    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, String processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    @Override
    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        this.processEventSupport = processEventSupport;
    }

    @Override
    public void dispose() {
        this.processEventSupport.reset();
        this.runtimeContext = null;
    }

    @Override
    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    @Override
    public void clearProcessInstancesState() {
        this.processInstanceManager.clearProcessInstancesState();
    }

    public boolean isActive() {
        return this.runtimeContext.isActive();
    }

    protected ExpirationTime createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            long delay = businessCalendar.calculateBusinessTimeAsDuration(timer.getDelay());
            if (timer.getPeriod() == null) {
                return DurationExpirationTime.repeat(delay);
            }
            long period = businessCalendar.calculateBusinessTimeAsDuration(timer.getPeriod());
            return DurationExpirationTime.repeat(delay, period);
        }
        return this.configureTimerInstance(timer);
    }

    private ExpirationTime configureTimerInstance(Timer timer) {
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount > -1) {
                        parsedReapedCount = Integer.MAX_VALUE;
                    }
                    return DurationExpirationTime.repeat(repeatValues[1], repeatValues[2]);
                }
                long delay = repeatValues[0];
                long period = -1L;
                try {
                    period = TimeUtils.parseTimeString(timer.getPeriod());
                }
                catch (RuntimeException e) {
                    period = repeatValues[0];
                }
                return DurationExpirationTime.repeat(delay, period);
            }
            case 1: {
                duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.repeat(duration);
            }
            case 3: {
                return ExactExpirationTime.of(timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    @Override
    public InternalKnowledgeRuntime getInternalKieRuntime() {
        return this.knowledgeRuntime;
    }

    public class SignalManagerSignalAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalManagerSignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public SignalManagerSignalAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            LightProcessRuntime.this.signalEvent(this.type, this.event);
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            LightProcessRuntime.this.signalEvent(this.type, this.event);
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            return null;
        }
    }

    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Map<String, String> inMappings;
        private EventTransformer eventTransformer;

        public StartProcessEventListener(String processId, List<EventFilter> eventFilters, Map<String, String> inMappings, EventTransformer eventTransformer) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.inMappings = inMappings;
            this.eventTransformer = eventTransformer;
        }

        @Override
        public String[] getEventTypes() {
            return null;
        }

        @Override
        public void signalEvent(String type, Object event) {
            for (EventFilter filter : this.eventFilters) {
                if (filter.acceptsEvent(type, event)) continue;
                return;
            }
            if (this.eventTransformer != null) {
                event = this.eventTransformer.transformEvent(event);
            }
            HashMap<String, Object> params = null;
            if (this.inMappings != null && !this.inMappings.isEmpty()) {
                params = new HashMap<String, Object>();
                if (this.inMappings.size() == 1) {
                    params.put(this.inMappings.keySet().iterator().next(), event);
                } else {
                    for (Map.Entry<String, String> entry : this.inMappings.entrySet()) {
                        if ("event".equals(entry.getValue())) {
                            params.put(entry.getKey(), event);
                            continue;
                        }
                        params.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            LightProcessRuntime.this.startProcessWithParamsAndTrigger(this.processId, params, type, false);
        }
    }
}

