/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

@XmlRootElement(name="get-completed-tasks-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MigrateProcessInstanceCommand
implements ExecutableCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 6L;
    @XmlElement
    @XmlSchemaType(name="string")
    private String processInstanceId;
    @XmlElement
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement
    private Map<String, Long> nodeMapping;

    public MigrateProcessInstanceCommand(String processInstanceId, String processId) {
        this.processInstanceId = processInstanceId;
        this.processId = processId;
    }

    public MigrateProcessInstanceCommand(String processInstanceId, String processId, Map<String, Long> nodeMapping) {
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.nodeMapping = nodeMapping;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Map<String, Long> getNodeMapping() {
        return this.nodeMapping;
    }

    public void setNodeMapping(Map<String, Long> nodeMapping) {
        this.nodeMapping = nodeMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)ksession.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance " + this.processInstanceId);
        }
        if (this.processId == null) {
            throw new IllegalArgumentException("Null process id");
        }
        WorkflowProcess process = (WorkflowProcess)ksession.getKieBase().getProcess(this.processId);
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + this.processId);
        }
        if (processInstance.getProcessId().equals(this.processId)) {
            return null;
        }
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = processInstance;
        synchronized (workflowProcessInstanceImpl) {
            Process oldProcess = processInstance.getProcess();
            processInstance.disconnect();
            processInstance.setProcess(oldProcess);
            if (this.nodeMapping == null) {
                this.nodeMapping = new HashMap<String, Long>();
            }
            this.updateNodeInstances(processInstance, this.nodeMapping);
            processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)((Object)ksession));
            processInstance.setProcess(process);
            processInstance.reconnect();
        }
        return null;
    }

    private void updateNodeInstances(NodeInstanceContainer nodeInstanceContainer, Map<String, Long> nodeMapping) {
        for (NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            String oldNodeId = ((NodeImpl)((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getNode()).getUniqueId();
            Long newNodeId = nodeMapping.get(oldNodeId);
            if (newNodeId == null) {
                newNodeId = nodeInstance.getNodeId();
            }
            ((NodeInstanceImpl)nodeInstance).setNodeId(newNodeId);
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.updateNodeInstances((NodeInstanceContainer)((Object)nodeInstance), nodeMapping);
        }
    }

    public String toString() {
        return "migrateProcessInstance(" + this.processInstanceId + ", \"" + this.processId + "\");";
    }
}

