/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.context.variable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.AbstractContextInstance;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;

public class VariableScopeInstance
extends AbstractContextInstance {
    private static final long serialVersionUID = 510L;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private transient String variableIdPrefix = null;
    private transient String variableInstanceIdPrefix = null;

    @Override
    public String getContextType() {
        return "VariableScope";
    }

    public Object getVariable(String name) {
        Object value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        if ("processInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getId();
        }
        if ("parentProcessInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getParentProcessInstanceId();
        }
        if (this.getProcessInstance() != null && this.getProcessInstance().getKnowledgeRuntime() != null && (value = this.getProcessInstance().getKnowledgeRuntime().getGlobal(name)) != null) {
            return value;
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public void setVariable(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The name of a variable may not be null!");
        }
        Object oldValue = this.getVariable(name);
        if (oldValue == null && value == null) {
            return;
        }
        ProcessEventSupport processEventSupport = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport();
        processEventSupport.fireBeforeVariableChanged((this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, value, this.getProcessInstance(), this.getProcessInstance().getKnowledgeRuntime());
        this.internalSetVariable(name, value);
        processEventSupport.fireAfterVariableChanged((this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, value, this.getProcessInstance(), this.getProcessInstance().getKnowledgeRuntime());
    }

    public void internalSetVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public VariableScope getVariableScope() {
        return (VariableScope)this.getContext();
    }

    @Override
    public void setContextInstanceContainer(ContextInstanceContainer contextInstanceContainer) {
        super.setContextInstanceContainer(contextInstanceContainer);
        for (Variable variable : this.getVariableScope().getVariables()) {
            if (variable.getValue() == null) continue;
            this.setVariable(variable.getName(), variable.getValue());
        }
        if (contextInstanceContainer instanceof CompositeContextNodeInstance) {
            this.variableIdPrefix = ((Node)((CompositeContextNodeInstance)contextInstanceContainer).getNode()).getUniqueId();
            this.variableInstanceIdPrefix = ((CompositeContextNodeInstance)contextInstanceContainer).getUniqueId();
        }
    }
}

