/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event.listeners;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;

public class RuleAwareProcessEventListener
implements ProcessEventListener {
    private ConcurrentHashMap<String, FactHandle> store = new ConcurrentHashMap();

    @Override
    public void beforeProcessStarted(ProcessStartedEvent event) {
        FactHandle handle = event.getKieRuntime().insert(event.getProcessInstance());
        this.store.put(event.getProcessInstance().getId(), handle);
    }

    @Override
    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    @Override
    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    @Override
    public void afterProcessCompleted(ProcessCompletedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().delete(handle);
        }
    }

    @Override
    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    @Override
    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    @Override
    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    @Override
    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    @Override
    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    @Override
    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().update(handle, event.getProcessInstance());
        } else {
            handle = event.getKieRuntime().insert(event.getProcessInstance());
            this.store.put(event.getProcessInstance().getId(), handle);
        }
    }

    protected FactHandle getProcessInstanceFactHandle(String processInstanceId, KieRuntime kruntime) {
        if (this.store.containsKey(processInstanceId)) {
            return this.store.get(processInstanceId);
        }
        Collection factHandles = kruntime.getFactHandles(object -> WorkflowProcessInstance.class.isAssignableFrom(object.getClass()) && ((WorkflowProcessInstance)object).getId().equals(processInstanceId));
        if (factHandles != null && !factHandles.isEmpty()) {
            FactHandle handle = (FactHandle)factHandles.iterator().next();
            this.store.put(processInstanceId, handle);
            return handle;
        }
        return null;
    }
}

