/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.ActionNodeInstance;
import org.jbpm.workflow.instance.node.BoundaryEventNodeInstance;
import org.jbpm.workflow.instance.node.CatchLinkNodeInstance;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.FaultNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.jbpm.workflow.instance.node.StartNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.ThrowLinkNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.Environment;

public class NodeInstanceFactoryRegistry {
    private static final NodeInstanceFactoryRegistry INSTANCE = new NodeInstanceFactoryRegistry();
    private Map<Class<? extends Node>, NodeInstanceFactory> registry = new HashMap<Class<? extends Node>, NodeInstanceFactory>();

    public static NodeInstanceFactoryRegistry getInstance(Environment environment) {
        if (environment != null && environment.get("NodeInstanceFactoryRegistry") != null) {
            return (NodeInstanceFactoryRegistry)environment.get("NodeInstanceFactoryRegistry");
        }
        return INSTANCE;
    }

    protected NodeInstanceFactoryRegistry() {
    }

    public void register(Class<? extends Node> cls, NodeInstanceFactory factory) {
        this.registry.put(cls, factory);
    }

    public NodeInstanceFactory getProcessNodeInstanceFactory(Node node) {
        for (Class<?> clazz = node.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            NodeInstanceFactory result = this.get(clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected NodeInstanceFactory get(Class<?> clazz) {
        if (RuleSetNode.class == clazz) {
            return this.factory(RuleSetNodeInstance::new);
        }
        if (Split.class == clazz) {
            return this.factory(SplitInstance::new);
        }
        if (Join.class == clazz) {
            return this.factoryOnce(JoinInstance::new);
        }
        if (StartNode.class == clazz) {
            return this.factory(StartNodeInstance::new);
        }
        if (EndNode.class == clazz) {
            return this.factory(EndNodeInstance::new);
        }
        if (MilestoneNode.class == clazz) {
            return this.factory(MilestoneNodeInstance::new);
        }
        if (SubProcessNode.class == clazz) {
            return this.factory(SubProcessNodeInstance::new);
        }
        if (ActionNode.class == clazz) {
            return this.factory(ActionNodeInstance::new);
        }
        if (WorkItemNode.class == clazz) {
            return this.factory(WorkItemNodeInstance::new);
        }
        if (TimerNode.class == clazz) {
            return this.factory(TimerNodeInstance::new);
        }
        if (FaultNode.class == clazz) {
            return this.factory(FaultNodeInstance::new);
        }
        if (EventSubProcessNode.class == clazz) {
            return this.factory(EventSubProcessNodeInstance::new);
        }
        if (CompositeNode.class == clazz) {
            return this.factory(CompositeNodeInstance::new);
        }
        if (CompositeContextNode.class == clazz) {
            return this.factory(CompositeContextNodeInstance::new);
        }
        if (HumanTaskNode.class == clazz) {
            return this.factory(HumanTaskNodeInstance::new);
        }
        if (ForEachNode.class == clazz) {
            return this.factory(ForEachNodeInstance::new);
        }
        if (EventNode.class == clazz) {
            return this.factory(EventNodeInstance::new);
        }
        if (StateNode.class == clazz) {
            return this.factory(StateNodeInstance::new);
        }
        if (DynamicNode.class == clazz) {
            return this.factory(DynamicNodeInstance::new);
        }
        if (BoundaryEventNode.class == clazz) {
            return this.factory(BoundaryEventNodeInstance::new);
        }
        if (CatchLinkNode.class == clazz) {
            return this.factory(CatchLinkNodeInstance::new);
        }
        if (ThrowLinkNode.class == clazz) {
            return this.factory(ThrowLinkNodeInstance::new);
        }
        return this.registry.get(clazz);
    }

    protected NodeInstanceFactory factoryOnce(Supplier<NodeInstanceImpl> supplier) {
        return (node, processInstance, nodeInstanceContainer) -> {
            NodeInstance result = ((NodeInstanceContainer)nodeInstanceContainer).getFirstNodeInstance(node.getId());
            if (result != null) {
                return result;
            }
            return NodeInstanceFactoryRegistry.createInstance((NodeInstanceImpl)supplier.get(), node, processInstance, nodeInstanceContainer);
        };
    }

    protected NodeInstanceFactory factory(Supplier<NodeInstanceImpl> supplier) {
        return (node, processInstance, nodeInstanceContainer) -> NodeInstanceFactoryRegistry.createInstance((NodeInstanceImpl)supplier.get(), node, processInstance, nodeInstanceContainer);
    }

    private static org.kie.api.runtime.process.NodeInstance createInstance(NodeInstanceImpl nodeInstance, Node node, WorkflowProcessInstance processInstance, org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer) {
        nodeInstance.setNodeId(node.getId());
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance(processInstance);
        String uniqueId = (String)node.getMetaData().get("UniqueId");
        if (uniqueId == null) {
            uniqueId = node.getId() + "";
        }
        nodeInstance.setMetaData("UniqueId", uniqueId);
        int level = ((NodeInstanceContainer)nodeInstanceContainer).getLevelForNode(uniqueId);
        nodeInstance.setLevel(level);
        return nodeInstance;
    }
}

