/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.kogito.index.domain.DomainDescriptor;
import org.kie.kogito.index.event.DomainModelRegisteredEvent;
import org.kie.kogito.index.graphql.GraphQLObjectTypeMapper;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.graphql.query.GraphQLInputObjectTypeMapper;
import org.kie.kogito.index.graphql.query.GraphQLOrderByTypeMapper;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GraphQLProtoSchemaMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLProtoSchemaMapper.class);
    @Inject
    GraphQLSchemaManager schemaManager;

    public void onDomainModelRegisteredEvent(@Observes DomainModelRegisteredEvent event) {
        LOGGER.debug("Received new domain event: {}", (Object)event);
        GraphQLSchema schema = this.schemaManager.getGraphQLSchema();
        this.schemaManager.transform(builder -> {
            builder.clearAdditionalTypes();
            Map<String, DomainDescriptor> map = event.getAdditionalTypes().stream().collect(Collectors.toMap(desc -> GraphQLObjectTypeMapper.getTypeName(desc.getTypeName()), desc -> desc));
            ConcurrentHashMap<String, GraphQLType> additionalTypes = new ConcurrentHashMap<String, GraphQLType>();
            GraphQLObjectType rootType = new GraphQLObjectTypeMapper(schema, additionalTypes, map).apply(event.getDomainDescriptor());
            additionalTypes.put(rootType.getName(), rootType);
            GraphQLInputObjectType whereArgumentType = new GraphQLInputObjectTypeMapper(schema, additionalTypes).apply(rootType);
            additionalTypes.put(whereArgumentType.getName(), whereArgumentType);
            GraphQLInputObjectType orderByType = new GraphQLOrderByTypeMapper(schema, additionalTypes).apply(rootType);
            additionalTypes.put(orderByType.getName(), orderByType);
            Set<GraphQLType> newTypes = additionalTypes.entrySet().stream().map(entry -> (GraphQLType)entry.getValue()).collect(Collectors.toSet());
            newTypes.addAll(schema.getAdditionalTypes().stream().filter(type -> !additionalTypes.containsKey(type.getName())).collect(Collectors.toSet()));
            LOGGER.debug("New GraphQL types: {}", (Object)newTypes);
            builder.additionalTypes(newTypes);
            GraphQLObjectType query = schema.getQueryType();
            query = query.transform(qBuilder -> {
                if (qBuilder.hasField(rootType.getName())) {
                    qBuilder.clearFields();
                    qBuilder.fields(schema.getQueryType().getFieldDefinitions().stream().filter(field -> !rootType.getName().equals(field.getName())).collect(Collectors.toList()));
                }
                GraphQLQueryParserRegistry.get().registerParser(whereArgumentType);
                GraphQLArgument where = GraphQLArgument.newArgument().name("where").type(whereArgumentType).build();
                GraphQLArgument orderBy = GraphQLArgument.newArgument().name("orderBy").type(orderByType).build();
                GraphQLArgument pagination = GraphQLArgument.newArgument().name("pagination").type(new GraphQLTypeReference("Pagination")).build();
                qBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName()).type(GraphQLList.list(rootType)).arguments(Arrays.asList(where, orderBy, pagination)));
            });
            builder.query(query);
            GraphQLObjectType subscription = schema.getSubscriptionType();
            subscription = subscription.transform(sBuilder -> {
                sBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName() + "Added").type(GraphQLNonNull.nonNull(rootType)).build());
                sBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName() + "Updated").type(GraphQLNonNull.nonNull(rootType)).build());
            });
            builder.subscription(subscription);
            GraphQLCodeRegistry registry = schema.getCodeRegistry().transform(codeBuilder -> {
                codeBuilder.dataFetcher(FieldCoordinates.coordinates("Query", rootType.getName()), this.schemaManager.getDomainModelDataFetcher(event.getProcessId()));
                codeBuilder.dataFetcher(FieldCoordinates.coordinates("Subscription", rootType.getName() + "Added"), this.schemaManager.getDomainModelAddedDataFetcher(event.getProcessId()));
                codeBuilder.dataFetcher(FieldCoordinates.coordinates("Subscription", rootType.getName() + "Updated"), this.schemaManager.getDomainModelUpdatedDataFetcher(event.getProcessId()));
            });
            builder.codeRegistry(registry);
        });
    }
}

