/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JsonDataFormatMarshaller
extends AbstractMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDataFormatMarshaller.class);
    @Inject
    ObjectMapper mapper;

    @Override
    protected ByteBuffer objectToBuffer(Object object, int estimatedSize) {
        String json = object.toString();
        LOGGER.debug("Serializing JSON: \n{}", (Object)json);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        return new ByteBufferImpl(bytes, 0, bytes.length);
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException {
        return this.mapper.readTree(buf);
    }

    @Override
    public boolean isMarshallable(Object o) {
        return o instanceof ObjectNode;
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

