/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.kogito.infinispan.marshallers.BooleanMessageMarshaller;
import org.kie.kogito.infinispan.marshallers.DateMessageMarshaller;
import org.kie.kogito.infinispan.marshallers.DoubleMessageMarshaller;
import org.kie.kogito.infinispan.marshallers.FloatMessageMarshaller;
import org.kie.kogito.infinispan.marshallers.IntegerMessageMarshaller;
import org.kie.kogito.infinispan.marshallers.LongMessageMarshaller;
import org.kie.kogito.infinispan.marshallers.StringMessageMarshaller;

public class ProtoStreamObjectMarshallingStrategy
implements ObjectMarshallingStrategy {
    private SerializationContext serializationContext;
    private Map<String, Class<?>> typeToClassMapping = new ConcurrentHashMap();

    public ProtoStreamObjectMarshallingStrategy(String proto, MessageMarshaller<?> ... marshallers) {
        this.serializationContext = new SerializationContextImpl(Configuration.builder().build());
        try {
            this.serializationContext.registerProtoFiles(FileDescriptorSource.fromResources("kogito-types.proto"));
            this.registerMarshaller(new StringMessageMarshaller(), new IntegerMessageMarshaller(), new LongMessageMarshaller(), new DoubleMessageMarshaller(), new FloatMessageMarshaller(), new BooleanMessageMarshaller(), new DateMessageMarshaller());
            if (proto != null) {
                this.serializationContext.registerProtoFiles(FileDescriptorSource.fromString(UUID.randomUUID().toString(), proto));
                this.registerMarshaller(marshallers);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean accept(Object object) {
        if (object == null) {
            return false;
        }
        return this.serializationContext.canMarshall(object.getClass());
    }

    @Override
    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        return ProtobufUtil.toByteArray(this.serializationContext, object);
    }

    @Override
    public Object unmarshal(String dataType, ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        return ProtobufUtil.fromByteArray(this.serializationContext, object, this.serializationContext.getMarshaller(dataType).getJavaClass());
    }

    @Override
    public String getType(Class<?> clazz) {
        BaseMarshaller<?> marshaller = this.serializationContext.getMarshaller(clazz);
        if (marshaller == null) {
            throw new IllegalStateException("No marshaller found for class " + clazz.getCanonicalName());
        }
        return marshaller.getTypeName();
    }

    public void registerMarshaller(MessageMarshaller<?> ... marshallers) {
        for (MessageMarshaller<?> marshaller : marshallers) {
            this.serializationContext.registerMarshaller(marshaller);
            this.typeToClassMapping.putIfAbsent(marshaller.getTypeName(), marshaller.getJavaClass());
        }
    }

    @Override
    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    @Override
    public void write(ObjectOutputStream os, Object object) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }
}

