/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Model;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.BaseWorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.ProcessInstanceWorkUnit;

public abstract class AbstractProcessInstance<T extends Model>
implements ProcessInstance<T> {
    private final T variables;
    private final AbstractProcess<T> process;
    private final ProcessRuntime rt;
    private org.kie.api.runtime.process.ProcessInstance legacyProcessInstance;
    private Integer status;
    private String id;
    private ProcessError processError;
    private Supplier<org.kie.api.runtime.process.ProcessInstance> reloadSupplier;
    private CompletionEventListener completionEventListener = new CompletionEventListener();

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt) {
        this.process = process;
        this.rt = rt;
        this.variables = variables;
        Map<String, Object> map = this.bind(variables);
        String processId = process.legacyProcess().getId();
        this.legacyProcessInstance = rt.createProcessInstance(processId, map);
        this.id = this.legacyProcessInstance.getId();
        this.status = 0;
    }

    public void internalSetProcessInstance(org.kie.api.runtime.process.ProcessInstance legacyProcessInstance) {
        if (this.legacyProcessInstance != null && this.status != 0) {
            throw new IllegalStateException("Impossible to override process instance that already exists");
        }
        this.legacyProcessInstance = legacyProcessInstance;
        this.status = legacyProcessInstance.getState();
        this.id = legacyProcessInstance.getId();
        ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).setKnowledgeRuntime(((InternalProcessRuntime)this.rt).getInternalKieRuntime());
        ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).reconnect();
        ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).setMetaData("KogitoProcessInstance", this);
        ((WorkflowProcessInstance)legacyProcessInstance).addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        for (NodeInstance nodeInstance : ((WorkflowProcessInstance)legacyProcessInstance).getNodeInstances()) {
            if (!(nodeInstance instanceof WorkItemNodeInstance)) continue;
            ((WorkItemNodeInstance)nodeInstance).internalRegisterWorkItem();
        }
        this.unbind(this.variables, legacyProcessInstance.getVariables());
    }

    public org.kie.api.runtime.process.ProcessInstance internalGetProcessInstance() {
        return this.legacyProcessInstance;
    }

    public void internalRemoveProcessInstance(Supplier<org.kie.api.runtime.process.ProcessInstance> reloadSupplier) {
        this.reloadSupplier = reloadSupplier;
        this.status = this.legacyProcessInstance.getState();
        if (this.status == 5) {
            this.processError = this.buildProcessError();
        }
        this.legacyProcessInstance = null;
    }

    @Override
    public void start() {
        this.start(null, null);
    }

    @Override
    public void start(String trigger, String referenceId) {
        if (this.status != 0) {
            throw new IllegalStateException("Impossible to start process instance that already was started");
        }
        this.status = 1;
        ((WorkflowProcessInstance)this.legacyProcessInstance).addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        if (referenceId != null) {
            ((WorkflowProcessInstance)this.legacyProcessInstance).setReferenceId(referenceId);
        }
        org.kie.api.runtime.process.ProcessInstance processInstance = this.rt.startProcessInstance(this.id, trigger);
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        this.unbind(this.variables, processInstance.getVariables());
        if (this.legacyProcessInstance != null) {
            this.status = this.legacyProcessInstance.getState();
        }
    }

    protected void addToUnitOfWork(Consumer<ProcessInstance<T>> action) {
        ((InternalProcessRuntime)this.rt).getUnitOfWorkManager().currentUnitOfWork().intercept(new ProcessInstanceWorkUnit(this, action));
    }

    @Override
    public void abort() {
        String pid = this.legacyProcessInstance().getId();
        this.unbind(this.variables, this.legacyProcessInstance().getVariables());
        this.rt.abortProcessInstance(pid);
        this.status = this.legacyProcessInstance.getState();
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).remove(pi.id()));
    }

    @Override
    public <S> void send(Signal<S> signal) {
        if (signal.referenceId() != null) {
            ((WorkflowProcessInstance)this.legacyProcessInstance()).setReferenceId(signal.referenceId());
        }
        this.legacyProcessInstance().signalEvent(signal.channel(), signal.payload());
        this.removeOnFinish();
    }

    @Override
    public Process<T> process() {
        return this.process;
    }

    @Override
    public T variables() {
        return this.variables;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void updateVariables(T updates) {
        Map<String, Object> map = this.bind(updates);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            ((WorkflowProcessInstance)this.legacyProcessInstance()).setVariable(entry.getKey(), entry.getValue());
        }
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
    }

    @Override
    public Optional<ProcessError> error() {
        if (this.status == 5) {
            return Optional.of(this.processError != null ? this.processError : this.buildProcessError());
        }
        return Optional.empty();
    }

    @Override
    public void startFrom(String nodeId) {
        this.startFrom(nodeId, null);
    }

    @Override
    public void startFrom(String nodeId, String referenceId) {
        ((WorkflowProcessInstance)this.legacyProcessInstance).setState(1);
        ((WorkflowProcessInstance)this.legacyProcessInstance).addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        if (referenceId != null) {
            ((WorkflowProcessInstance)this.legacyProcessInstance).setReferenceId(referenceId);
        }
        this.triggerNode(nodeId);
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        this.unbind(this.variables, this.legacyProcessInstance.getVariables());
        if (this.legacyProcessInstance != null) {
            this.status = this.legacyProcessInstance.getState();
        }
    }

    @Override
    public void triggerNode(String nodeId) {
        Node node;
        WorkflowProcessInstanceImpl wfpi = (WorkflowProcessInstanceImpl)this.legacyProcessInstance();
        RuleFlowProcess rfp = (RuleFlowProcess)wfpi.getProcess();
        Node parentNode = rfp.getParentNode((node = rfp.getNodesRecursively().stream().filter(ni -> nodeId.equals(ni.getMetaData().get("UniqueId"))).findFirst().orElseThrow(() -> new NodeNotFoundException(this.id, nodeId))).getId());
        WorkflowProcessInstanceImpl nodeInstanceContainerNode = parentNode == null ? wfpi : (NodeInstanceContainer)((Object)wfpi.getNodeInstance(parentNode));
        nodeInstanceContainerNode.getNodeInstance(node).trigger(null, "DROOLS_DEFAULT");
    }

    @Override
    public void cancelNodeInstance(String nodeInstanceId) {
        org.jbpm.workflow.instance.NodeInstance nodeInstance = ((WorkflowProcessInstanceImpl)this.legacyProcessInstance()).getNodeInstances(true).stream().filter(ni -> ni.getId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
        ((NodeInstanceImpl)nodeInstance).cancel();
        this.removeOnFinish();
    }

    @Override
    public void retriggerNodeInstance(String nodeInstanceId) {
        org.jbpm.workflow.instance.NodeInstance nodeInstance = ((WorkflowProcessInstanceImpl)this.legacyProcessInstance()).getNodeInstances(true).stream().filter(ni -> ni.getId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
        ((NodeInstanceImpl)nodeInstance).retrigger(true);
        this.removeOnFinish();
    }

    private org.kie.api.runtime.process.ProcessInstance legacyProcessInstance() {
        if (this.legacyProcessInstance == null) {
            this.legacyProcessInstance = this.reloadSupplier.get();
            if (this.legacyProcessInstance == null) {
                throw new ProcessInstanceNotFoundException(this.id);
            }
        }
        return this.legacyProcessInstance;
    }

    @Override
    public WorkItem workItem(String workItemId, Policy<?> ... policies) {
        WorkItemNodeInstance workItemInstance = (WorkItemNodeInstance)((WorkflowProcessInstance)this.legacyProcessInstance()).getNodeInstances().stream().filter(ni -> ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItemId().equals(workItemId) && ((WorkItemNodeInstance)ni).getWorkItem().enforce(policies)).findFirst().orElseThrow(() -> new WorkItemNotFoundException("Work item with id " + workItemId + " was not found in process instance " + this.id(), workItemId));
        return new BaseWorkItem(workItemInstance.getId(), workItemInstance.getWorkItem().getId(), (String)workItemInstance.getWorkItem().getParameters().getOrDefault("TaskName", workItemInstance.getNodeName()), workItemInstance.getWorkItem().getState(), workItemInstance.getWorkItem().getPhaseId(), workItemInstance.getWorkItem().getPhaseStatus(), workItemInstance.getWorkItem().getParameters(), workItemInstance.getWorkItem().getResults());
    }

    @Override
    public List<WorkItem> workItems(Policy<?> ... policies) {
        return ((WorkflowProcessInstance)this.legacyProcessInstance()).getNodeInstances().stream().filter(ni -> ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItem().enforce(policies)).map(ni -> new BaseWorkItem(ni.getId(), ((WorkItemNodeInstance)ni).getWorkItemId(), (String)((WorkItemNodeInstance)ni).getWorkItem().getParameters().getOrDefault("TaskName", ni.getNodeName()), ((WorkItemNodeInstance)ni).getWorkItem().getState(), ((WorkItemNodeInstance)ni).getWorkItem().getPhaseId(), ((WorkItemNodeInstance)ni).getWorkItem().getPhaseStatus(), ((WorkItemNodeInstance)ni).getWorkItem().getParameters(), ((WorkItemNodeInstance)ni).getWorkItem().getResults())).collect(Collectors.toList());
    }

    @Override
    public void completeWorkItem(String id, Map<String, Object> variables, Policy<?> ... policies) {
        this.rt.getWorkItemManager().completeWorkItem(id, variables, policies);
        this.removeOnFinish();
    }

    @Override
    public void abortWorkItem(String id, Policy<?> ... policies) {
        this.rt.getWorkItemManager().abortWorkItem(id, policies);
        this.removeOnFinish();
    }

    @Override
    public void transitionWorkItem(String id, Transition<?> transition) {
        this.rt.getWorkItemManager().transitionWorkItem(id, transition);
        this.removeOnFinish();
    }

    protected void removeOnFinish() {
        if (this.legacyProcessInstance.getState() != 1 && this.legacyProcessInstance.getState() != 5) {
            ((WorkflowProcessInstance)this.legacyProcessInstance).removeEventListener("processInstanceCompleted:" + this.legacyProcessInstance.getId(), this.completionEventListener, false);
            this.status = this.legacyProcessInstance.getState();
            this.id = this.legacyProcessInstance.getId();
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).remove(pi.id()));
        } else {
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        }
        this.unbind(this.variables, this.legacyProcessInstance().getVariables());
        this.status = this.legacyProcessInstance.getState();
    }

    protected Map<String, Object> bind(T variables) {
        HashMap<String, Object> vmap = new HashMap<String, Object>();
        if (variables == null) {
            return vmap;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = null;
                v = f.get(variables);
                vmap.put(f.getName(), v);
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
        return vmap;
    }

    protected void unbind(T variables, Map<String, Object> vmap) {
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                f.set(variables, vmap.get(f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcessInstance other = (AbstractProcessInstance)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    protected ProcessError buildProcessError() {
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)this.legacyProcessInstance();
        final String errorMessage = pi.getErrorMessage();
        final String nodeInError = pi.getNodeIdInError();
        return new ProcessError(){

            @Override
            public String failedNodeId() {
                return nodeInError;
            }

            @Override
            public String errorMessage() {
                return errorMessage;
            }

            @Override
            public void retrigger() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.legacyProcessInstance();
                org.jbpm.workflow.instance.NodeInstance ni = pInstance.getNodeInstanceByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorMessage(null);
                ni.trigger(null, "DROOLS_DEFAULT");
                AbstractProcessInstance.this.removeOnFinish();
            }

            @Override
            public void skip() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.legacyProcessInstance();
                org.jbpm.workflow.instance.NodeInstance ni = pInstance.getNodeInstanceByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorMessage(null);
                ((NodeInstanceImpl)ni).triggerCompleted("DROOLS_DEFAULT", true);
                AbstractProcessInstance.this.removeOnFinish();
            }
        };
    }

    private class CompletionEventListener
    implements EventListener {
        private CompletionEventListener() {
        }

        @Override
        public void signalEvent(String type, Object event) {
            AbstractProcessInstance.this.removeOnFinish();
        }

        @Override
        public String[] getEventTypes() {
            return new String[]{"processInstanceCompleted:" + AbstractProcessInstance.this.legacyProcessInstance.getId()};
        }
    }
}

