/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import org.drools.core.impl.EnvironmentImpl;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProcessMarshallerWriteContext;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProcessMarshallerRegistry;
import org.jbpm.marshalling.impl.ProtobufRuleFlowProcessInstanceMarshaller;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.AbstractProcessInstance;

public class ProcessInstanceMarshaller {
    private Environment env = new EnvironmentImpl();

    public ProcessInstanceMarshaller(ObjectMarshallingStrategy ... strategies) {
        ObjectMarshallingStrategy[] strats = null;
        if (strategies == null) {
            strats = new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy(ClassObjectMarshallingStrategyAcceptor.DEFAULT)};
        } else {
            strats = new ObjectMarshallingStrategy[strategies.length + 1];
            int i = 0;
            ObjectMarshallingStrategy[] objectMarshallingStrategyArray = strategies;
            int n = objectMarshallingStrategyArray.length;
            for (int j = 0; j < n; ++j) {
                ObjectMarshallingStrategy strategy;
                strats[i] = strategy = objectMarshallingStrategyArray[j];
                ++i;
            }
            strats[i] = new SerializablePlaceholderResolverStrategy(ClassObjectMarshallingStrategyAcceptor.DEFAULT);
        }
        this.env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", strats);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] marhsallProcessInstance(ProcessInstance<?> processInstance) {
        org.kie.api.runtime.process.ProcessInstance legacyProcessInstance = ((AbstractProcessInstance)processInstance).internalGetProcessInstance();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ProcessMarshallerWriteContext context = new ProcessMarshallerWriteContext(baos, null, null, null, null, this.env);
            context.setProcessInstanceId(legacyProcessInstance.getId());
            context.setState(legacyProcessInstance.getState());
            String processType = ((ProcessInstanceImpl)legacyProcessInstance).getProcess().getType();
            context.stream.writeUTF(processType);
            org.jbpm.marshalling.impl.ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType);
            Object result = marshaller.writeProcessInstance(context, legacyProcessInstance);
            if (marshaller instanceof ProtobufRuleFlowProcessInstanceMarshaller && result != null) {
                JBPMMessages.ProcessInstance _instance = (JBPMMessages.ProcessInstance)result;
                PersisterHelper.writeToStreamWithHeader(context, _instance);
            }
            context.close();
            ((WorkflowProcessInstanceImpl)legacyProcessInstance).disconnect();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while marshalling process instance", e);
        }
    }

    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process) {
        Model m = (Model)process.createModel();
        AbstractProcessInstance processInstance = (AbstractProcessInstance)process.createInstance(m);
        return this.unmarshallProcessInstance(data, process, processInstance);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process, AbstractProcessInstance<?> processInstance) {
        org.kie.api.runtime.process.ProcessInstance legacyProcessInstance = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, Collections.singletonMap(process.id(), ((AbstractProcess)process).legacyProcess()), null, null, null, this.env);
            MarshallerReaderContext stream = context.stream;
            String processInstanceType = stream.readUTF();
            org.jbpm.marshalling.impl.ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processInstanceType);
            legacyProcessInstance = marshaller.readProcessInstance(context);
            context.close();
            processInstance.internalSetProcessInstance(legacyProcessInstance);
            AbstractProcessInstance<?> abstractProcessInstance = processInstance;
            return abstractProcessInstance;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while unmarshalling process instance", e);
        }
    }
}

