/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kie.kogito.Addons;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventBatch;
import org.kie.kogito.event.EventManager;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.services.event.impl.ProcessInstanceEventBatch;

public class BaseEventManager
implements EventManager {
    private String service;
    private Addons addons;
    private Set<EventPublisher> publishers = new LinkedHashSet<EventPublisher>();

    @Override
    public EventBatch newBatch() {
        return new ProcessInstanceEventBatch(this.service, this.addons);
    }

    @Override
    public void publish(EventBatch batch) {
        if (this.publishers.isEmpty()) {
            return;
        }
        Collection<DataEvent<?>> events = batch.events();
        this.publishers.forEach(p -> p.publish(events));
    }

    @Override
    public void addPublisher(EventPublisher publisher) {
        this.publishers.add(publisher);
    }

    @Override
    public void setService(String service) {
        this.service = service;
    }

    @Override
    public void setAddons(Addons addons) {
        this.addons = addons;
    }
}

