/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kie.kogito.event.EventBatch;
import org.kie.kogito.event.EventManager;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.WorkUnit;

public class CollectingUnitOfWork
implements UnitOfWork {
    private Set<WorkUnit<?>> collectedWork;
    private boolean done;
    private final EventManager eventManager;

    public CollectingUnitOfWork(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void start() {
        this.checkDone();
        if (this.collectedWork == null) {
            this.collectedWork = new LinkedHashSet();
        }
    }

    @Override
    public void end() {
        this.checkStarted();
        EventBatch batch = this.eventManager.newBatch();
        for (WorkUnit<?> work : this.sorted()) {
            batch.append(work.data());
            work.perform();
        }
        this.eventManager.publish(batch);
        this.done();
    }

    @Override
    public void abort() {
        this.checkStarted();
        for (WorkUnit<?> work : this.sorted()) {
            work.abort();
        }
        this.done();
    }

    @Override
    public void intercept(WorkUnit work) {
        this.checkStarted();
        if (work == null) {
            throw new NullPointerException("Work must be non null");
        }
        this.collectedWork.remove(work);
        this.collectedWork.add(work);
    }

    protected Collection<WorkUnit<?>> sorted() {
        ArrayList sortedCollectedWork = new ArrayList(this.collectedWork);
        sortedCollectedWork.sort((u1, u2) -> u1.priority().compareTo(u2.priority()));
        return sortedCollectedWork;
    }

    protected void checkDone() {
        if (this.done) {
            throw new IllegalStateException("Unit of work is already done (ended or aborted)");
        }
    }

    protected void checkStarted() {
        if (this.collectedWork == null) {
            throw new IllegalStateException("Unit of work is not started");
        }
    }

    protected void done() {
        this.done = true;
        this.collectedWork = null;
    }
}

