/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.function.Consumer;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.uow.WorkUnit;

public class ProcessInstanceWorkUnit<T>
implements WorkUnit<ProcessInstance<T>> {
    private ProcessInstance<T> data;
    private Consumer<Object> action;
    private Consumer<Object> compensation;

    public ProcessInstanceWorkUnit(ProcessInstance<T> data, Consumer<Object> action) {
        this.data = data;
        this.action = action;
    }

    public ProcessInstanceWorkUnit(ProcessInstance<T> data, Consumer<Object> action, Consumer<Object> compensation) {
        this.data = data;
        this.action = action;
        this.compensation = compensation;
    }

    @Override
    public ProcessInstance<T> data() {
        return this.data;
    }

    @Override
    public void perform() {
        this.action.accept(this.data());
    }

    @Override
    public void abort() {
        if (this.compensation != null) {
            this.compensation.accept(this.data());
        }
    }

    @Override
    public Integer priority() {
        return 10;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceWorkUnit other = (ProcessInstanceWorkUnit)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }
}

