/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class InfinispanServerTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String INFINISPAN_VERSION = System.getProperty("infinispan.version");
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanServerTestResource.class);
    private GenericContainer infinispan;

    public Map<String, String> start() {
        if (INFINISPAN_VERSION == null) {
            throw new RuntimeException("Please define a valid Infinispan image version in system property infinispan.version");
        }
        LOGGER.info("Using Infinispan image version: {}", (Object)INFINISPAN_VERSION);
        this.infinispan = new FixedHostPortGenericContainer("quay.io/infinispan/server:" + INFINISPAN_VERSION).withFixedExposedPort(11232, 11222).withEnv("USER", "admin").withEnv("PASS", "admin").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.infinispan.start();
        return Collections.emptyMap();
    }

    public void stop() {
        this.infinispan.stop();
    }
}

