/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.model.ProcessInstance;

public class KogitoProcessCloudEvent
extends KogitoCloudEvent<ProcessInstance> {
    @JsonProperty(value="kogitoProcessinstanceState")
    private Integer state;
    @JsonProperty(value="kogitoParentProcessinstanceId")
    private String parentProcessInstanceId;

    public static Builder builder() {
        return new Builder();
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String id) {
        if (id != null && !id.trim().isEmpty()) {
            this.parentProcessInstanceId = id;
        }
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    @Override
    public void setSource(URI source) {
        super.setSource(source);
        if (this.getData() != null && source != null) {
            ((ProcessInstance)this.getData()).setEndpoint(source.toString());
        }
    }

    @Override
    public void setKogitoAddons(String kogitoAddons) {
        super.setKogitoAddons(kogitoAddons);
        if (this.getData() != null && kogitoAddons != null) {
            ((ProcessInstance)this.getData()).setAddons(new HashSet<String>(Arrays.asList(kogitoAddons.split(","))));
        }
    }

    @Override
    public void setTime(ZonedDateTime time) {
        super.setTime(time);
        if (this.getData() != null && time != null) {
            ((ProcessInstance)this.getData()).setLastUpdate(time);
        }
    }

    @Override
    public String toString() {
        return "KogitoProcessCloudEvent{state=" + this.state + ", parentProcessInstanceId='" + this.parentProcessInstanceId + '\'' + "} " + super.toString();
    }

    public static final class Builder {
        private KogitoProcessCloudEvent event = new KogitoProcessCloudEvent();

        private Builder() {
        }

        public Builder type(String type) {
            this.event.setType(type);
            return this;
        }

        public Builder source(URI source) {
            this.event.setSource(source);
            return this;
        }

        public Builder id(String id) {
            this.event.setId(id);
            return this;
        }

        public Builder time(ZonedDateTime time) {
            this.event.setTime(time);
            return this;
        }

        public Builder schemaURL(URI schemaURL) {
            this.event.setSchemaURL(schemaURL);
            return this;
        }

        public Builder contentType(String contentType) {
            this.event.setContentType(contentType);
            return this;
        }

        public Builder data(ProcessInstance data) {
            this.event.setData(data);
            return this;
        }

        public Builder processInstanceId(String processInstanceId) {
            this.event.setProcessInstanceId(processInstanceId);
            return this;
        }

        public Builder processId(String processId) {
            this.event.setProcessId(processId);
            return this;
        }

        public Builder state(Integer state) {
            this.event.setState(state);
            return this;
        }

        public Builder rootProcessInstanceId(String rootProcessInstanceId) {
            this.event.setRootProcessInstanceId(rootProcessInstanceId);
            return this;
        }

        public Builder rootProcessId(String rootProcessId) {
            this.event.setRootProcessId(rootProcessId);
            return this;
        }

        public Builder parentProcessInstanceId(String parentProcessInstanceId) {
            this.event.setParentProcessInstanceId(parentProcessInstanceId);
            return this;
        }

        public Builder kogitoReferenceId(String kogitoReferenceId) {
            this.event.setKogitoReferenceId(kogitoReferenceId);
            return this;
        }

        public Builder kogitoAddons(String kogitoAddons) {
            this.event.setKogitoAddons(kogitoAddons);
            return this;
        }

        public KogitoProcessCloudEvent build() {
            return this.event;
        }
    }
}

