/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.kogito.index.graphql.query.AbstractInputObjectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLOrderByTypeMapper
extends AbstractInputObjectTypeMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLOrderByTypeMapper.class);
    private static final String ORDER_BY = "OrderBy";

    public GraphQLOrderByTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes) {
        super(schema, additionalTypes);
    }

    @Override
    public String getTypeName(GraphQLObjectType type) {
        return type.getName() + ORDER_BY;
    }

    @Override
    protected Consumer<GraphQLInputObjectType.Builder> build(GraphQLObjectType domain) {
        return builder -> domain.getFieldDefinitions().forEach(field -> {
            LOGGER.debug("GraphQL mapping field: {}", field);
            switch (field.getName()) {
                case "processInstances": 
                case "userTasks": 
                case "id": {
                    break;
                }
                default: {
                    String typeName;
                    switch (field.getType().getName()) {
                        case "Int": 
                        case "String": 
                        case "Boolean": 
                        case "DateTime": {
                            typeName = ORDER_BY;
                            break;
                        }
                        default: {
                            typeName = field.getType().getName() + ORDER_BY;
                            if (this.getSchema().getType(typeName) != null || this.getAdditionalTypes().containsKey(typeName)) break;
                            GraphQLInputObjectType type = new GraphQLOrderByTypeMapper(this.getSchema(), this.getAdditionalTypes()).apply((GraphQLObjectType)this.getAdditionalTypes().get(field.getType().getName()));
                            this.getAdditionalTypes().put(typeName, (GraphQLType)type);
                        }
                    }
                    builder.field(GraphQLInputObjectField.newInputObjectField().name(field.getName()).type((GraphQLInputType)new GraphQLTypeReference(typeName)));
                }
            }
        });
    }
}

